/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredElement;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfiguredThemeEditorStyle
extends ThemeEditorStyle {
    @NotNull
    private final StyleResourceValue myStyleResourceValue;
    @NotNull
    private final Configuration myConfiguration;
    @Nullable
    private final Module mySourceModule;

    public ConfiguredThemeEditorStyle(@NotNull Configuration configuration, @NotNull StyleResourceValue styleResourceValue, @Nullable Module sourceModule) {
        if (configuration == null) {
            ConfiguredThemeEditorStyle.$$$reportNull$$$0(0);
        }
        if (styleResourceValue == null) {
            ConfiguredThemeEditorStyle.$$$reportNull$$$0(1);
        }
        super(configuration.getConfigurationManager(), ResolutionUtils.getQualifiedStyleName(styleResourceValue));
        this.myStyleResourceValue = styleResourceValue;
        this.myConfiguration = configuration;
        this.mySourceModule = sourceModule;
    }

    @NotNull
    public String getStyleResourceUrl() {
        String string = this.myStyleResourceValue.getResourceUrl().toString();
        if (string == null) {
            ConfiguredThemeEditorStyle.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public StyleResourceValue getStyleResourceValue() {
        StyleResourceValue styleResourceValue = this.myStyleResourceValue;
        if (styleResourceValue == null) {
            ConfiguredThemeEditorStyle.$$$reportNull$$$0(3);
        }
        return styleResourceValue;
    }

    public boolean isReadOnly() {
        return !this.isProjectStyle();
    }

    @NotNull
    public ImmutableCollection<ConfiguredElement<ItemResourceValue>> getConfiguredValues() {
        ImmutableList.Builder itemResourceValues = ImmutableList.builder();
        if (this.isFramework()) {
            assert (this.myConfiguration.getFrameworkResources() != null);
            ResourceItem styleItem = this.myConfiguration.getFrameworkResources().getResourceItem(ResourceType.STYLE, this.myStyleResourceValue.getName());
            for (ResourceFile file : styleItem.getSourceFileList()) {
                ResourceValue styleResourceValue = file.getValue(ResourceType.STYLE, styleItem.getName());
                FolderConfiguration folderConfiguration = file.getConfiguration();
                if (!(styleResourceValue instanceof StyleResourceValue)) continue;
                for (ItemResourceValue value : ((StyleResourceValue)styleResourceValue).getValues()) {
                    itemResourceValues.add(ConfiguredElement.create(folderConfiguration, value));
                }
            }
        } else {
            for (com.android.ide.common.res2.ResourceItem styleDefinition : this.getStyleResourceItems()) {
                ResourceValue styleResourceValue = styleDefinition.getResourceValue(this.isFramework());
                FolderConfiguration folderConfiguration = styleDefinition.getConfiguration();
                if (!(styleResourceValue instanceof StyleResourceValue)) continue;
                for (ItemResourceValue value : ((StyleResourceValue)styleResourceValue).getValues()) {
                    itemResourceValues.add(ConfiguredElement.create(folderConfiguration, value));
                }
            }
        }
        ImmutableList immutableList = itemResourceValues.build();
        if (immutableList == null) {
            ConfiguredThemeEditorStyle.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    public Collection<ConfiguredElement<String>> getParentNames() {
        if (this.isFramework()) {
            ConfiguredThemeEditorStyle parent = this.getParent();
            if (parent != null) {
                return ImmutableList.of(ConfiguredElement.create(new FolderConfiguration(), parent.getQualifiedName()));
            }
            return Collections.emptyList();
        }
        ImmutableList.Builder parents = ImmutableList.builder();
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            StyleResourceValue style = (StyleResourceValue)styleItem.getResourceValue(false);
            assert (style != null);
            String parentName = ResolutionUtils.getParentQualifiedName(style);
            if (parentName == null) continue;
            parents.add(ConfiguredElement.create(styleItem.getConfiguration(), parentName));
        }
        return parents.build();
    }

    public boolean hasItem(@Nullable EditedStyleItem item) {
        return item != null && this.getStyleResourceValue().getItem(item.getName(), item.isFrameworkAttr()) != null;
    }

    public ItemResourceValue getItem(@NotNull String name, boolean isFramework) {
        if (name == null) {
            ConfiguredThemeEditorStyle.$$$reportNull$$$0(5);
        }
        return this.getStyleResourceValue().getItem(name, isFramework);
    }

    public ConfiguredThemeEditorStyle getParent() {
        return this.getParent(null);
    }

    @Nullable
    public ConfiguredThemeEditorStyle getParent(@Nullable ThemeResolver themeResolver) {
        ResourceResolver resolver = this.myConfiguration.getResourceResolver();
        assert (resolver != null);
        StyleResourceValue parent = resolver.getParent(this.getStyleResourceValue());
        if (parent == null) {
            return null;
        }
        if (themeResolver == null) {
            return ResolutionUtils.getStyle(this.myConfiguration, ResolutionUtils.getQualifiedStyleName(parent), null);
        }
        return themeResolver.getTheme(ResolutionUtils.getQualifiedStyleName(parent));
    }

    public String toString() {
        if (!this.isReadOnly()) {
            return "[" + this.getName() + "]";
        }
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ConfiguredThemeEditorStyle)) {
            return false;
        }
        return this.getQualifiedName().equals(((ConfiguredThemeEditorStyle)obj).getQualifiedName());
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ConfiguredThemeEditorStyle.$$$reportNull$$$0(6);
        }
        return configuration;
    }

    @Nullable
    public Module getSourceModule() {
        return this.mySourceModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleResourceValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/datamodels/ConfiguredThemeEditorStyle";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/datamodels/ConfiguredThemeEditorStyle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleResourceUrl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleResourceValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredValues";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

