/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.utils.XmlUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFamilyCreator {
    private static final String PRELOADED_FONTS = "preloaded_fonts";
    private static final String PRELOADED_FONTS_FILE = "preloaded_fonts.xml";
    private static final String FONT_CERTS_FILE = "font_certs.xml";
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final DownloadableFontCacheService myService;

    public FontFamilyCreator(@NotNull AndroidFacet facet) {
        if (facet == null) {
            FontFamilyCreator.$$$reportNull$$$0(0);
        }
        this.myFacet = facet;
        this.myProject = facet.getModule().getProject();
        this.myService = DownloadableFontCacheService.getInstance();
    }

    @NotNull
    public String createFontFamily(final @NotNull FontDetail font, final @NotNull String fontName, final boolean downloadable) throws IOException {
        if (font == null) {
            FontFamilyCreator.$$$reportNull$$$0(1);
        }
        if (fontName == null) {
            FontFamilyCreator.$$$reportNull$$$0(2);
        }
        Project project = this.myFacet.getModule().getProject();
        TransactionGuard.submitTransaction((Disposable)project, () -> {
            if (font == null) {
                FontFamilyCreator.$$$reportNull$$$0(45);
            }
            if (fontName == null) {
                FontFamilyCreator.$$$reportNull$$$0(46);
            }
            new WriteCommandAction.Simple(project, "Create new font file", new PsiFile[0]){

                protected void run() throws Throwable {
                    if (downloadable) {
                        FontFamilyCreator.this.createDownloadableFont(font, fontName);
                    } else {
                        FontFamilyCreator.this.createEmbeddedFont(font, fontName);
                    }
                }
            }.execute();
        });
        String string = "@font/" + fontName;
        if (string == null) {
            FontFamilyCreator.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void createDownloadableFont(@NotNull FontDetail font, @NotNull String fontName) throws IOException {
        if (font == null) {
            FontFamilyCreator.$$$reportNull$$$0(4);
        }
        if (fontName == null) {
            FontFamilyCreator.$$$reportNull$$$0(5);
        }
        VirtualFile fontFolder = this.getResourceFolder(ResourceFolderType.FONT);
        String content = this.createFontFamilyContent(font);
        this.saveContent(fontFolder, fontName + ".xml", content.getBytes(StandardCharsets.UTF_8));
        FontProvider provider = font.getFamily().getProvider();
        this.createCertFileIfNeeded(provider);
        this.createOrUpdateFile(PRELOADED_FONTS_FILE, "array", PRELOADED_FONTS, "@font/", fontName, FontFamilyCreator::insertItem);
        this.addPreloadedFontsToManifest();
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    private void createEmbeddedFont(@NotNull FontDetail font, @NotNull String fontName) throws IOException {
        if (font == null) {
            FontFamilyCreator.$$$reportNull$$$0(6);
        }
        if (fontName == null) {
            FontFamilyCreator.$$$reportNull$$$0(7);
        }
        VirtualFile fontFolder = this.getResourceFolder(ResourceFolderType.FONT);
        File cachedFile = this.myService.getCachedFontFile(font);
        if (cachedFile != null && cachedFile.exists()) {
            this.saveContent(fontFolder, fontName + "." + FileUtilRt.getExtension((String)cachedFile.getName()), FileUtil.loadFileBytes((File)cachedFile));
        }
    }

    private void saveContent(@NotNull VirtualFile folder, @NotNull String fileName, byte[] content) throws IOException {
        if (folder == null) {
            FontFamilyCreator.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            FontFamilyCreator.$$$reportNull$$$0(9);
        }
        folder.createChildData((Object)this, fileName).setBinaryContent(content);
    }

    @NotNull
    private VirtualFile getResourceFolder(@NotNull ResourceFolderType folderType) throws IOException {
        VirtualFile resourceDirectory;
        if (folderType == null) {
            FontFamilyCreator.$$$reportNull$$$0(10);
        }
        if ((resourceDirectory = this.myFacet.getPrimaryResourceDir()) == null) {
            throw new IOException("PrimaryResourceDirectory is null");
        }
        VirtualFile fontFolder = resourceDirectory.findChild(folderType.getName());
        if (fontFolder == null) {
            fontFolder = resourceDirectory.createChildDirectory((Object)this, folderType.getName());
        }
        VirtualFile virtualFile = fontFolder;
        if (virtualFile == null) {
            FontFamilyCreator.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    public static String getFontName(@NotNull FontDetail font) {
        if (font == null) {
            FontFamilyCreator.$$$reportNull$$$0(12);
        }
        String name = font.getFamily().getName();
        String styleName = StringUtil.trimStart((String)font.getStyleName(), (String)"Regular").trim();
        if (!styleName.isEmpty()) {
            name = name + " " + styleName;
        }
        return DownloadableFontCacheServiceImpl.convertNameToFilename(name);
    }

    @NotNull
    @Language(value="XML")
    private String createFontFamilyContent(@NotNull FontDetail font) {
        if (font == null) {
            FontFamilyCreator.$$$reportNull$$$0(13);
        }
        FontFamily family = font.getFamily();
        FontProvider provider = family.getProvider();
        AndroidModuleInfo info = AndroidModuleInfo.getInstance(this.myFacet);
        AndroidVersion minSdkVersion = info.getMinSdkVersion();
        if (minSdkVersion.getApiLevel() > 27) {
            String string = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<font-family xmlns:android=\"http://schemas.android.com/apk/res/android\"%n        android:fontProviderAuthority=\"" + FontFamilyCreator.escapeXmlValue(provider.getAuthority()) + "\"%n        android:fontProviderPackage=\"" + FontFamilyCreator.escapeXmlValue(provider.getPackageName()) + "\"%n        android:fontProviderQuery=\"" + FontFamilyCreator.escapeXmlValue(font.generateQuery(false)) + "\"%n        android:fontProviderCerts=\"@array/" + FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName()) + "\">%n</font-family>%n", new Object[0]);
            if (string == null) {
                FontFamilyCreator.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<font-family xmlns:app=\"http://schemas.android.com/apk/res-auto\"%n        app:fontProviderAuthority=\"" + FontFamilyCreator.escapeXmlValue(provider.getAuthority()) + "\"%n        app:fontProviderPackage=\"" + FontFamilyCreator.escapeXmlValue(provider.getPackageName()) + "\"%n        app:fontProviderQuery=\"" + FontFamilyCreator.escapeXmlValue(font.generateQuery(false)) + "\"%n        app:fontProviderCerts=\"@array/" + FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName()) + "\">%n</font-family>%n", new Object[0]);
        if (string == null) {
            FontFamilyCreator.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    @Language(value="XML")
    private static String createValuesFileContent(@NotNull String tag, @NotNull String name, @NotNull String prefix, @NotNull String value) {
        if (tag == null) {
            FontFamilyCreator.$$$reportNull$$$0(16);
        }
        if (name == null) {
            FontFamilyCreator.$$$reportNull$$$0(17);
        }
        if (prefix == null) {
            FontFamilyCreator.$$$reportNull$$$0(18);
        }
        if (value == null) {
            FontFamilyCreator.$$$reportNull$$$0(19);
        }
        String string = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<resources>%n    <" + tag + " name=\"" + FontFamilyCreator.escapeXmlValue(name) + "\" translatable=\"false\">%n        <item>" + prefix + ValueXmlHelper.escapeResourceString((String)value) + "</item>%n    </" + tag + ">%n</resources>%n", new Object[0]);
        if (string == null) {
            FontFamilyCreator.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    @Language(value="XML")
    private static String createCertificateFileContent(@NotNull FontProvider provider) {
        if (provider == null) {
            FontFamilyCreator.$$$reportNull$$$0(21);
        }
        String certName = FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName());
        String string = String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<resources>%n    <array name=\"" + certName + "\">%n        <item>@array/" + certName + "_dev</item>%n        <item>@array/" + certName + "_prod</item>%n    </array>%n    <string-array name=\"" + certName + "_dev\">%n        <item>%n            " + provider.getDevelopmentCertificate() + "%n        </item>%n    </string-array>%n    <string-array name=\"" + certName + "_prod\">%n        <item>%n            " + provider.getCertificate() + "%n        </item>%n    </string-array>%n</resources>%n", new Object[0]);
        if (string == null) {
            FontFamilyCreator.$$$reportNull$$$0(22);
        }
        return string;
    }

    private void createOrUpdateFile(@NotNull String fileName, @NotNull String tagName, @NotNull String name, @NotNull String prefix, @NotNull String value, @NotNull XmlTagUpdater updater) throws IOException {
        VirtualFile valuesFolder;
        VirtualFile file;
        if (fileName == null) {
            FontFamilyCreator.$$$reportNull$$$0(23);
        }
        if (tagName == null) {
            FontFamilyCreator.$$$reportNull$$$0(24);
        }
        if (name == null) {
            FontFamilyCreator.$$$reportNull$$$0(25);
        }
        if (prefix == null) {
            FontFamilyCreator.$$$reportNull$$$0(26);
        }
        if (value == null) {
            FontFamilyCreator.$$$reportNull$$$0(27);
        }
        if (updater == null) {
            FontFamilyCreator.$$$reportNull$$$0(28);
        }
        if ((file = (valuesFolder = this.getResourceFolder(ResourceFolderType.VALUES)).findChild(fileName)) == null) {
            String content = FontFamilyCreator.createValuesFileContent(tagName, name, prefix, value);
            this.saveContent(valuesFolder, fileName, content.getBytes(StandardCharsets.UTF_8));
        } else {
            XmlTag newTag;
            XmlFile xmlFile;
            XmlTag rootTag;
            PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.myProject, file);
            if (psiFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)psiFile).getRootTag()) != null && (newTag = FontFamilyCreator.updateFile(rootTag, tagName, name, prefix, value, tag -> tag.getAttributeValue("name"), updater)) != null) {
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)rootTag);
            }
        }
    }

    private void createCertFileIfNeeded(@NotNull FontProvider provider) throws IOException {
        VirtualFile valuesFolder;
        VirtualFile file;
        if (provider == null) {
            FontFamilyCreator.$$$reportNull$$$0(29);
        }
        if ((file = (valuesFolder = this.getResourceFolder(ResourceFolderType.VALUES)).findChild(FONT_CERTS_FILE)) == null) {
            String content = FontFamilyCreator.createCertificateFileContent(provider);
            this.saveContent(valuesFolder, FONT_CERTS_FILE, content.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void addPreloadedFontsToManifest() {
        Manifest manifest = this.myFacet.getManifest();
        if (manifest == null) {
            return;
        }
        XmlTag manifestTag = manifest.getXmlTag();
        if (manifestTag == null) {
            return;
        }
        XmlTag applicationTag = manifestTag.findFirstSubTag("application");
        if (applicationTag == null) {
            return;
        }
        XmlTag newTag = FontFamilyCreator.updateFile(applicationTag, "meta-data", PRELOADED_FONTS, "@array/", PRELOADED_FONTS, tag -> tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android"), FontFamilyCreator::setMetaDataAttributes);
        if (newTag != null) {
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)newTag);
        }
    }

    @Nullable
    private static XmlTag updateFile(@NotNull XmlTag parent, @NotNull String tagName, @NotNull String name, @NotNull String prefix, @NotNull String value, @NotNull Function<XmlTag, String> nameAttributeGetter, @NotNull XmlTagUpdater updater) {
        if (parent == null) {
            FontFamilyCreator.$$$reportNull$$$0(30);
        }
        if (tagName == null) {
            FontFamilyCreator.$$$reportNull$$$0(31);
        }
        if (name == null) {
            FontFamilyCreator.$$$reportNull$$$0(32);
        }
        if (prefix == null) {
            FontFamilyCreator.$$$reportNull$$$0(33);
        }
        if (value == null) {
            FontFamilyCreator.$$$reportNull$$$0(34);
        }
        if (nameAttributeGetter == null) {
            FontFamilyCreator.$$$reportNull$$$0(35);
        }
        if (updater == null) {
            FontFamilyCreator.$$$reportNull$$$0(36);
        }
        XmlTag before = null;
        XmlTag last = null;
        for (XmlTag tag : parent.getSubTags()) {
            if (!tag.getName().equals(tagName)) continue;
            last = tag;
            String nameAttribute = nameAttributeGetter.apply(tag);
            if (nameAttribute == null || nameAttribute.compareTo(name) < 0) continue;
            if (nameAttribute.equals(name)) {
                return updater.update(tag, prefix, value);
            }
            before = tag;
        }
        XmlTag newTag = parent.createChildTag(tagName, "", null, false);
        if (newTag == null) {
            return null;
        }
        newTag = before != null ? (XmlTag)parent.addBefore((PsiElement)newTag, before) : (last != null ? (XmlTag)parent.addAfter((PsiElement)newTag, (PsiElement)last) : parent.addSubTag(newTag, false));
        updater.update(newTag, prefix, value);
        return newTag;
    }

    @Nullable
    private static XmlTag insertItem(@NotNull XmlTag parent, @NotNull String prefix, @NotNull String newValue) {
        if (parent == null) {
            FontFamilyCreator.$$$reportNull$$$0(37);
        }
        if (prefix == null) {
            FontFamilyCreator.$$$reportNull$$$0(38);
        }
        if (newValue == null) {
            FontFamilyCreator.$$$reportNull$$$0(39);
        }
        XmlTag before = null;
        for (XmlTag tag : parent.getSubTags()) {
            if (!tag.getName().equals("item")) continue;
            String value = tag.getValue().getText();
            int compare = value.compareTo(prefix + newValue);
            if (compare == 0) {
                return null;
            }
            if (compare <= 0) continue;
            before = tag;
            break;
        }
        XmlTag newTag = parent.createChildTag("item", "", prefix + ValueXmlHelper.escapeResourceString((String)newValue), false);
        if (before != null) {
            parent.addBefore((PsiElement)newTag, before);
        } else {
            parent.addSubTag(newTag, false);
        }
        return newTag;
    }

    private static XmlTag setMetaDataAttributes(@NotNull XmlTag tag, @NotNull String prefix, @NotNull String newValue) {
        if (tag == null) {
            FontFamilyCreator.$$$reportNull$$$0(40);
        }
        if (prefix == null) {
            FontFamilyCreator.$$$reportNull$$$0(41);
        }
        if (newValue == null) {
            FontFamilyCreator.$$$reportNull$$$0(42);
        }
        tag.setAttribute("name", "http://schemas.android.com/apk/res/android", PRELOADED_FONTS);
        tag.setAttribute("resource", "http://schemas.android.com/apk/res/android", prefix + FontFamilyCreator.escapeXmlValue(newValue));
        return tag;
    }

    @NotNull
    private static String escapeXmlValue(@NotNull String value) {
        if (value == null) {
            FontFamilyCreator.$$$reportNull$$$0(43);
        }
        String string = XmlUtils.toXmlAttributeValue((String)value);
        if (string == null) {
            FontFamilyCreator.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 12: 
            case 13: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontName";
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fonts/FontFamilyCreator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 16: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 17: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: 
            case 26: 
            case 33: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 19: 
            case 27: 
            case 34: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 28: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAttributeGetter";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fonts/FontFamilyCreator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFontFamily";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceFolder";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFontFamilyContent";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createValuesFileContent";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createCertificateFileContent";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeXmlValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFontFamily";
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 44: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDownloadableFont";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEmbeddedFont";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveContent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResourceFolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFontName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFontFamilyContent";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createValuesFileContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createCertificateFileContent";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createCertFileIfNeeded";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "updateFile";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "insertItem";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "setMetaDataAttributes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlValue";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createFontFamily$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface XmlTagUpdater {
        public XmlTag update(@NotNull XmlTag var1, @NotNull String var2, @NotNull String var3);
    }
}

