/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginInfo {
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidPluginGeneration myPluginGeneration;
    @Nullable
    private final GradleVersion myPluginVersion;
    @Nullable
    private final VirtualFile myPluginBuildFile;

    @Nullable
    public static AndroidPluginInfo find(@NotNull Project project) {
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(0);
        }
        return AndroidPluginInfo.find(project, false);
    }

    @Nullable
    public static AndroidPluginInfo searchInBuildFilesOnly(@NotNull Project project) {
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(1);
        }
        return AndroidPluginInfo.find(project, true);
    }

    @Nullable
    private static AndroidPluginInfo find(@NotNull Project project, boolean searchInBuildFilesOnly) {
        boolean pluginVersionFound;
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(2);
        }
        Module appModule = null;
        AndroidModuleModel appGradleModel = null;
        VirtualFile pluginBuildFile = null;
        if (!searchInBuildFilesOnly) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
                if (gradleModel == null || gradleModel.getAndroidProject().getProjectType() != 0) continue;
                appModule = module;
                appGradleModel = gradleModel;
                break;
            }
        }
        GradleVersion pluginVersion = appGradleModel != null ? appGradleModel.getModelVersion() : null;
        AndroidPluginGeneration pluginGeneration = null;
        if (appModule != null && (pluginGeneration = AndroidPluginGeneration.find(appModule)) == AndroidPluginGeneration.COMPONENT) {
            pluginVersion = null;
        }
        boolean appModuleFound = appModule != null;
        boolean bl = pluginVersionFound = pluginVersion != null;
        if (!appModuleFound || !pluginVersionFound) {
            BuildFileSearchResult result = AndroidPluginInfo.searchInBuildFiles(project, !appModuleFound);
            if (result.appVirtualFile != null) {
                appModule = ModuleUtilCore.findModuleForFile((VirtualFile)result.appVirtualFile, (Project)project);
            }
            if (StringUtil.isNotEmpty((String)result.pluginVersion)) {
                pluginVersion = GradleVersion.tryParse((String)result.pluginVersion);
            }
            if (pluginGeneration == null) {
                pluginGeneration = result.pluginGeneration;
            }
            pluginBuildFile = result.pluginVirtualFile;
        }
        if (appModule != null && pluginGeneration != null) {
            return new AndroidPluginInfo(appModule, pluginGeneration, pluginVersion, pluginBuildFile);
        }
        return null;
    }

    @NotNull
    private static BuildFileSearchResult searchInBuildFiles(@NotNull Project project, boolean searchForAppModule) {
        BuildFileSearchResult result;
        if (project == null) {
            AndroidPluginInfo.$$$reportNull$$$0(3);
        }
        BuildFileSearchResult buildFileSearchResult = result = new BuildFileSearchResult();
        if (buildFileSearchResult == null) {
            AndroidPluginInfo.$$$reportNull$$$0(4);
        }
        return buildFileSearchResult;
    }

    @VisibleForTesting
    public AndroidPluginInfo(@NotNull Module module, @NotNull AndroidPluginGeneration pluginGeneration, @Nullable GradleVersion pluginVersion, @Nullable VirtualFile pluginBuildFile) {
        if (module == null) {
            AndroidPluginInfo.$$$reportNull$$$0(5);
        }
        if (pluginGeneration == null) {
            AndroidPluginInfo.$$$reportNull$$$0(6);
        }
        this.myModule = module;
        this.myPluginGeneration = pluginGeneration;
        this.myPluginVersion = pluginVersion;
        this.myPluginBuildFile = pluginBuildFile;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            AndroidPluginInfo.$$$reportNull$$$0(7);
        }
        return module;
    }

    @NotNull
    public AndroidPluginGeneration getPluginGeneration() {
        AndroidPluginGeneration androidPluginGeneration = this.myPluginGeneration;
        if (androidPluginGeneration == null) {
            AndroidPluginInfo.$$$reportNull$$$0(8);
        }
        return androidPluginGeneration;
    }

    @Nullable
    public GradleVersion getPluginVersion() {
        return this.myPluginVersion;
    }

    @Nullable
    public VirtualFile getPluginBuildFile() {
        return this.myPluginBuildFile;
    }

    public boolean isExperimental() {
        return this.getPluginGeneration() == AndroidPluginGeneration.COMPONENT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPluginInfo that = (AndroidPluginInfo)o;
        return Objects.equals(this.myModule, that.myModule) && Objects.equals(this.myPluginGeneration, that.myPluginGeneration) && Objects.equals(this.myPluginVersion, that.myPluginVersion) && Objects.equals(this.myPluginBuildFile, that.myPluginBuildFile);
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myPluginGeneration, this.myPluginVersion, this.myPluginBuildFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/plugin/AndroidPluginInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginGeneration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/plugin/AndroidPluginInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "searchInBuildFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginGeneration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "searchInBuildFilesOnly";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "searchInBuildFiles";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BuildFileSearchResult {
        @Nullable
        VirtualFile appVirtualFile;
        @Nullable
        VirtualFile pluginVirtualFile;
        @Nullable
        AndroidPluginGeneration pluginGeneration;
        @Nullable
        String pluginVersion;

        private BuildFileSearchResult() {
        }
    }
}

