/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleFiles {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock;
    @NotNull
    private final Set<VirtualFile> myChangedFiles;
    @NotNull
    private final Set<VirtualFile> myChangedExternalFiles;
    @NotNull
    private final Map<VirtualFile, Integer> myFileHashes;
    @NotNull
    private final Set<VirtualFile> myExternalBuildFiles;
    @NotNull
    private final FileEditorManagerListener myFileEditorListener;

    @NotNull
    public static GradleFiles getInstance(@NotNull Project project) {
        if (project == null) {
            GradleFiles.$$$reportNull$$$0(0);
        }
        GradleFiles gradleFiles = (GradleFiles)ServiceManager.getService((Project)project, GradleFiles.class);
        if (gradleFiles == null) {
            GradleFiles.$$$reportNull$$$0(1);
        }
        return gradleFiles;
    }

    private GradleFiles(@NotNull Project project) {
        if (project == null) {
            GradleFiles.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myChangedFiles = new HashSet<VirtualFile>();
        this.myChangedExternalFiles = new HashSet<VirtualFile>();
        this.myFileHashes = new HashMap<VirtualFile, Integer>();
        this.myExternalBuildFiles = new HashSet<VirtualFile>();
        this.myProject = project;
        final GradleFileChangeListener fileChangeListener = new GradleFileChangeListener(this);
        this.myFileEditorListener = new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getNewFile() == null || !event.getNewFile().isValid()) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)GradleFiles.this.myProject).findFile(event.getNewFile());
                if (psiFile == null) {
                    return;
                }
                if (GradleFiles.this.isGradleFile(psiFile) || GradleFiles.this.isExternalBuildFile(psiFile)) {
                    PsiManager.getInstance((Project)GradleFiles.this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)fileChangeListener);
                } else {
                    PsiManager.getInstance((Project)GradleFiles.this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)fileChangeListener);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/gradle/project/sync/GradleFiles$1", "selectionChanged"));
            }
        };
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myFileEditorListener);
    }

    @NotNull
    FileEditorManagerListener getFileEditorListener() {
        FileEditorManagerListener fileEditorManagerListener = this.myFileEditorListener;
        if (fileEditorManagerListener == null) {
            GradleFiles.$$$reportNull$$$0(3);
        }
        return fileEditorManagerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasHashForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.containsKey(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChangedFiles.clear();
            this.myChangedExternalFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChangedFile(@NotNull VirtualFile file, boolean isExternal) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (isExternal) {
                this.myChangedExternalFiles.add(file);
            } else {
                this.myChangedFiles.add(file);
            }
        }
    }

    private void putHashForFile(@NotNull Map<VirtualFile, Integer> map, @NotNull VirtualFile file) {
        Integer hash;
        if (map == null) {
            GradleFiles.$$$reportNull$$$0(6);
        }
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(7);
        }
        if ((hash = this.computeHash(file)) != null) {
            map.put(file, hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeHashesForFiles(@NotNull Map<VirtualFile, Integer> files) {
        if (files == null) {
            GradleFiles.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myFileHashes.clear();
            this.myFileHashes.putAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Integer getStoredHashForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsChangedFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myChangedFiles.contains(file) || this.myChangedExternalFiles.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExternalBuildFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeExternalBuildFiles(@NotNull Collection<VirtualFile> externalBuildFiles) {
        if (externalBuildFiles == null) {
            GradleFiles.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.addAll(externalBuildFiles);
        }
    }

    @Nullable
    private Integer computeHash(@NotNull VirtualFile file) {
        PsiFile psiFile;
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(12);
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) != null && psiFile.isValid()) {
            return psiFile.getText().hashCode();
        }
        return null;
    }

    private boolean areHashesEqual(@NotNull VirtualFile file) {
        Integer oldHash;
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(13);
        }
        return (oldHash = this.getStoredHashForFile(file)) != null && oldHash.equals(this.computeHash(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHashesOfChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            return this.filterHashes(this.myChangedFiles) && this.filterHashes(this.myChangedExternalFiles);
        }
    }

    private boolean filterHashes(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            GradleFiles.$$$reportNull$$$0(14);
        }
        boolean status = true;
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>();
        for (VirtualFile file : files) {
            if (!this.areHashesEqual(file)) {
                status = false;
                continue;
            }
            toRemove.add(file);
        }
        files.removeAll(toRemove);
        return status;
    }

    public boolean areGradleFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> !this.checkHashesOfChangedFiles());
    }

    public boolean areExternalBuildFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return !this.filterHashes(this.myChangedExternalFiles);
            }
        });
    }

    public boolean isGradleFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GradleFiles.$$$reportNull$$$0(15);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternalBuildFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GradleFiles.$$$reportNull$$$0(16);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myExternalBuildFiles.contains(psiFile.getVirtualFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleFiles";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalBuildFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditorListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasHashForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChangedFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putHashForFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "storeHashesForFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStoredHashForFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsChangedFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "storeExternalBuildFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeHash";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "areHashesEqual";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "filterHashes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isGradleFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isExternalBuildFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradleFileChangeListener
    extends PsiTreeChangeAdapter {
        @NotNull
        private final GradleFiles myGradleFiles;

        private GradleFileChangeListener(@NotNull GradleFiles gradleFiles) {
            if (gradleFiles == null) {
                GradleFileChangeListener.$$$reportNull$$$0(0);
            }
            this.myGradleFiles = gradleFiles;
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(1);
            }
            if (event.getNewChild() != null) {
                this.processEvent(event, event.getNewChild());
            } else {
                this.processEvent(event, event.getChild());
            }
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(2);
            }
            this.processEvent(event, event.getOldChild());
        }

        public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(3);
            }
            this.processEvent(event, event.getNewChild(), event.getOldChild());
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(4);
            }
            this.processEvent(event, event.getChild());
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(5);
            }
            this.processEvent(event, event.getOldChild(), event.getNewChild());
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(6);
            }
            if (event.getNewChild() != null) {
                this.processEvent(event, event.getNewChild());
            } else {
                this.processEvent(event, event.getChild());
            }
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(7);
            }
            this.processEvent(event, event.getChild());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(8);
            }
            this.processEvent(event, event.getNewChild(), event.getOldChild());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(9);
            }
            this.processEvent(event, event.getChild());
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(10);
            }
            this.processEvent(event, event.getOldChild(), event.getNewChild());
        }

        private void processEvent(@NotNull PsiTreeChangeEvent event, PsiElement ... elements) {
            PsiFile psiFile;
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(11);
            }
            if (elements == null) {
                GradleFileChangeListener.$$$reportNull$$$0(12);
            }
            if ((psiFile = event.getFile()) == null) {
                return;
            }
            boolean isExternalBuildFile = this.myGradleFiles.isExternalBuildFile(psiFile);
            if (!this.myGradleFiles.isGradleFile(psiFile) && !isExternalBuildFile) {
                return;
            }
            if (this.myGradleFiles.containsChangedFile(psiFile.getVirtualFile())) {
                return;
            }
            if (!this.myGradleFiles.myProject.isInitialized() || !PsiManager.getInstance((Project)this.myGradleFiles.myProject).isInProject((PsiElement)psiFile)) {
                return;
            }
            boolean foundChange = false;
            for (PsiElement element : elements) {
                if (element == null || element instanceof PsiWhiteSpace) continue;
                foundChange = true;
                break;
            }
            if (foundChange) {
                this.myGradleFiles.addChangedFile(psiFile.getVirtualFile(), isExternalBuildFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleFiles";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleFiles$GradleFileChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildAddition";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildRemoval";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildReplacement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildMovement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeChildrenChange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

