/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.help;

import com.android.tools.idea.IdeInfo;
import com.intellij.help.impl.HelpManagerImpl;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StudioHelpManagerImpl
extends HelpManagerImpl {
    public static String STUDIO_HELP_PREFIX = "android-studio:";
    public static Browser myDefaultBrowser = url -> BrowserUtil.browse((String)url);
    public static String STUDIO_HELP_URL = "https://developer.android.com/";
    public static String REDIRECT_URL_EXTENSION = "r/studio-help/";
    private Browser myBrowser = myDefaultBrowser;

    void setBrowser(@NotNull Browser browser) {
        if (browser == null) {
            StudioHelpManagerImpl.$$$reportNull$$$0(0);
        }
        this.myBrowser = browser;
    }

    public void invokeHelp(@Nullable @NonNls String id) {
        if (id == null) {
            return;
        }
        if (id.startsWith(STUDIO_HELP_PREFIX)) {
            this.openStudioHelpPage(id.substring(STUDIO_HELP_PREFIX.length()));
            return;
        }
        if (id.startsWith("reference.dialogs.rundebug.Android")) {
            this.openStudioHelpPage("/r/studio-ui/rundebugconfig.html");
            return;
        }
        if (IdeInfo.getInstance().isAndroidStudio()) {
            this.openStudioHelpPage(REDIRECT_URL_EXTENSION + this.getVersion() + "/?" + id);
        } else {
            super.invokeHelp(id);
        }
    }

    private void openStudioHelpPage(@NotNull @NonNls String urlPath) {
        if (urlPath == null) {
            StudioHelpManagerImpl.$$$reportNull$$$0(1);
        }
        this.myBrowser.browse(STUDIO_HELP_URL + urlPath);
    }

    String getVersion() {
        ApplicationInfoEx info = ApplicationInfoEx.getInstanceEx();
        String minorVersion = info.getMinorVersion();
        int dot = minorVersion.indexOf(46);
        if (dot != -1) {
            minorVersion = minorVersion.substring(0, dot);
        }
        return info.getMajorVersion() + "." + minorVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPath";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/help/StudioHelpManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setBrowser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openStudioHelpPage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface Browser {
        public void browse(String var1);
    }
}

