/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.lint.LintIdeUtils;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.function.Predicate;

public class LintIdeGradleDetector
extends GradleDetector {
    static final Implementation IMPLEMENTATION = new Implementation(LintIdeGradleDetector.class, Scope.GRADLE_SCOPE);

    protected GradleVersion getHighestKnownVersion(LintClient client, GradleCoordinate coordinate, Predicate<GradleVersion> filter) {
        GradleCoordinate found;
        AndroidSdkHandler sdkHandler = client.getSdk();
        if (sdkHandler == null) {
            return null;
        }
        StudioLoggerProgressIndicator logger = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
        RemotePackage sdkPackage = SdkMavenRepository.findLatestRemoteVersion((GradleCoordinate)coordinate, (AndroidSdkHandler)sdkHandler, filter, (ProgressIndicator)logger);
        if (sdkPackage != null && (found = SdkMavenRepository.getCoordinateFromSdkPath((String)sdkPackage.getPath())) != null) {
            return found.getVersion();
        }
        return null;
    }

    public void visitBuildScript(final Context context) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (context instanceof JavaContext) {
                    LintIdeGradleDetector.this.handleGradleKotlinScript((JavaContext)context);
                    return;
                }
                PsiFile psiFile = LintIdeUtils.getPsiFile(context);
            }
        });
    }

    protected int getStartOffset(Context context, Object cookie) {
        int startOffset = super.getStartOffset(context, cookie);
        if (startOffset != -1) {
            return startOffset;
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset();
    }

    protected Object getPropertyPairCookie(Object cookie) {
        PsiElement element = (PsiElement)cookie;
        return element.getParent();
    }

    protected Object getPropertyKeyCookie(Object cookie) {
        PsiElement element = (PsiElement)cookie;
        PsiElement parent = element.getParent();
        return super.getPropertyKeyCookie(cookie);
    }

    protected Location createLocation(Context context, Object cookie) {
        Location location = super.createLocation(context, cookie);
        if (location != null) {
            return location;
        }
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        location = Location.create((File)context.file, (Position)new DefaultPosition(-1, -1, start), (Position)new DefaultPosition(-1, -1, end)).withSource((Object)element);
        return location;
    }
}

