/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.LintIdeClient;
import com.android.tools.idea.lint.LintIdeIssueRegistry;
import com.android.tools.idea.lint.LintIdeProject;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressLintIntentionAction
implements IntentionAction,
Iconable {
    private static final String NO_INSPECTION_PREFIX = "//noinspection ";
    private final String myId;
    private final PsiElement myElement;
    private Issue myIssue;

    public SuppressLintIntentionAction(String id, PsiElement element) {
        this.myId = id;
        this.myElement = element;
    }

    public SuppressLintIntentionAction(Issue issue, PsiElement element) {
        this(issue.getId(), element);
        this.myIssue = issue;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return AllIcons.Actions.Cancel;
    }

    @NotNull
    public String getText() {
        String id = SuppressLintIntentionAction.getLintId(this.myId);
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiFile.class);
        if (file == null) {
            if ("" == null) {
                SuppressLintIntentionAction.$$$reportNull$$$0(0);
            }
            return "";
        }
        if (file instanceof XmlFile) {
            String string = AndroidBundle.message("android.lint.fix.suppress.lint.api.attr", id);
            if (string == null) {
                SuppressLintIntentionAction.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (file instanceof PsiJavaFile) {
            String string = AndroidBundle.message("android.lint.fix.suppress.lint.api.annotation", id);
            if (string == null) {
                SuppressLintIntentionAction.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("" == null) {
            SuppressLintIntentionAction.$$$reportNull$$$0(3);
        }
        return "";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            SuppressLintIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull com.intellij.openapi.project.Project project, Editor editor, PsiFile file) {
        FileType type;
        if (project == null) {
            SuppressLintIntentionAction.$$$reportNull$$$0(5);
        }
        return (type = file.getFileType()) == StdFileTypes.JAVA || type == StdFileTypes.XML;
    }

    public void invoke(@NotNull com.intellij.openapi.project.Project project, @Nullable Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        VirtualFile virtualFile;
        if (project == null) {
            SuppressLintIntentionAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            SuppressLintIntentionAction.$$$reportNull$$$0(7);
        }
        if (file instanceof XmlFile) {
            XmlTag element = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, XmlTag.class);
            if (element == null) {
                return;
            }
            String lintId = SuppressLintIntentionAction.getLintId(this.myId);
            SuppressLintIntentionAction.addSuppressAttribute(project, (XmlFile)file, element, lintId);
        } else if (file instanceof PsiJavaFile) {
            PsiModifierListOwner container = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiModifierListOwner.class);
            if (container == null) {
                return;
            }
            PsiModifierList modifierList = container.getModifierList();
            if (modifierList != null) {
                String lintId = SuppressLintIntentionAction.getLintId(this.myId);
                SuppressLintIntentionAction.addSuppressAnnotation(project, (PsiElement)container, container, lintId);
            }
        } else if (file instanceof PsiBinaryFile && (virtualFile = file.getVirtualFile()) != null) {
            File dir;
            File binaryFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module != null && (dir = LintIdeProject.getLintProjectDirectory(module, AndroidFacet.getInstance(module))) != null) {
                LintIdeClient client = new LintIdeClient(project);
                Project lintProject = client.getProject(dir, dir);
                Configuration configuration = client.getConfiguration(lintProject, null);
                Issue issue = this.getIssue();
                if (issue != null) {
                    configuration.ignore(issue, binaryFile);
                }
            }
        }
    }

    @Nullable
    private Issue getIssue() {
        if (this.myIssue == null) {
            this.myIssue = new LintIdeIssueRegistry().getIssue(this.myId);
        }
        return this.myIssue;
    }

    static String getLintId(String intentionId) {
        String lintId = intentionId;
        lintId = StringUtil.trimStart((String)lintId, (String)"AndroidLint");
        return lintId;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void addSuppressAttribute(com.intellij.openapi.project.Project project, XmlFile file, XmlTag element, String id) throws IncorrectOperationException {
        String value;
        XmlAttribute attribute = element.getAttribute("ignore", "http://schemas.android.com/tools");
        if (attribute == null) {
            value = id;
        } else {
            ArrayList<String> ids = new ArrayList<String>();
            for (String existing : Splitter.on((char)',').trimResults().split((CharSequence)attribute.getValue())) {
                if (existing.equals(id)) continue;
                ids.add(existing);
            }
            ids.add(id);
            Collections.sort(ids);
            value = Joiner.on((char)',').join(ids);
        }
        AndroidResourceUtil.ensureNamespaceImported(file, "http://schemas.android.com/tools", null);
        element.setAttribute("ignore", "http://schemas.android.com/tools", value);
    }

    private static void addSuppressAnnotation(com.intellij.openapi.project.Project project, PsiElement container, PsiModifierListOwner modifierOwner, String id) throws IncorrectOperationException {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierOwner, (String[])new String[]{"android.annotation.SuppressLint"});
        PsiAnnotation newAnnotation = SuppressLintIntentionAction.createNewAnnotation(project, container, annotation, id);
        if (newAnnotation != null) {
            if (annotation != null && annotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                new AddAnnotationFix("android.annotation.SuppressLint", modifierOwner, attributes, new String[0]).invoke(project, null, container.getContainingFile());
            }
        }
    }

    @Nullable
    private static PsiAnnotation createNewAnnotation(@NotNull com.intellij.openapi.project.Project project, @NotNull PsiElement container, @Nullable PsiAnnotation annotation, @NotNull String id) {
        if (project == null) {
            SuppressLintIntentionAction.$$$reportNull$$$0(8);
        }
        if (container == null) {
            SuppressLintIntentionAction.$$$reportNull$$$0(9);
        }
        if (id == null) {
            SuppressLintIntentionAction.$$$reportNull$$$0(10);
        }
        if (annotation != null) {
            String currentSuppressedId = "\"" + id + "\"";
            String annotationText = annotation.getText();
            if (!annotationText.contains("{")) {
                PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
                if (attributes.length == 1) {
                    String suppressedWarnings = attributes[0].getText();
                    if (suppressedWarnings.contains(currentSuppressedId)) {
                        return null;
                    }
                    return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText("@android.annotation.SuppressLint({" + suppressedWarnings + ", " + currentSuppressedId + "})", container);
                }
            } else {
                int curlyBraceIndex = annotationText.lastIndexOf(125);
                if (curlyBraceIndex > 0) {
                    String oldSuppressWarning = annotationText.substring(0, curlyBraceIndex);
                    if (oldSuppressWarning.contains(currentSuppressedId)) {
                        return null;
                    }
                    return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText(oldSuppressWarning + ", " + currentSuppressedId + "})", container);
                }
            }
        } else {
            return JavaPsiFacade.getInstance((com.intellij.openapi.project.Project)project).getElementFactory().createAnnotationFromText("@android.annotation.SuppressLint(\"" + id + "\")", container);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/SuppressLintIntentionAction";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/SuppressLintIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createNewAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

