/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.logcat.AndroidLogConsole;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.ConfigureLogcatFormatDialog;
import com.android.tools.idea.logcat.DefaultAndroidLogcatFilter;
import com.android.tools.idea.logcat.EditLogFilterDialog;
import com.android.tools.idea.logcat.FormattedLogcatReceiver;
import com.android.tools.idea.logcat.LogcatFilterProvider;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatView
implements Disposable {
    public static final Key<AndroidLogcatView> ANDROID_LOGCAT_VIEW_KEY = Key.create((String)"ANDROID_LOGCAT_VIEW_KEY");
    private static final AndroidLogcatFilter EDIT_FILTER_CONFIGURATION_ITEM = new AndroidLogcatFilter(){

        @Override
        @NotNull
        public String getName() {
            String string = EDIT_FILTER_CONFIGURATION;
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isApplicable(@NotNull String message, @NotNull String tag, @NotNull String p, int pid, @NotNull Log.LogLevel logLevel) {
            if (message == null) {
                1.$$$reportNull$$$0(1);
            }
            if (tag == null) {
                1.$$$reportNull$$$0(2);
            }
            if (p == null) {
                1.$$$reportNull$$$0(3);
            }
            if (logLevel == null) {
                1.$$$reportNull$$$0(4);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatView$1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    static final String SELECTED_APP_FILTER = AndroidBundle.message("android.logcat.filters.selected", new Object[0]);
    static final String NO_FILTERS = AndroidBundle.message("android.logcat.filters.none", new Object[0]);
    static final String EDIT_FILTER_CONFIGURATION = AndroidBundle.message("android.logcat.filters.edit", new Object[0]);
    private final Project myProject;
    private final DeviceContext myDeviceContext;
    private final String myToolWindowId;
    private JPanel myPanel;
    private DefaultComboBoxModel<AndroidLogcatFilter> myFilterComboBoxModel;
    private volatile IDevice myDevice;
    private final AndroidLogConsole myLogConsole;
    private final FormattedLogcatReceiver myLogcatReceiver;
    private final AndroidLogFilterModel myLogFilterModel;
    @NotNull
    private final AndroidLogcatFilter myNoFilter;

    private void notifyDeviceUpdated(boolean forceReconnect) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (forceReconnect) {
                if (this.myDevice != null) {
                    AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
                }
                this.myDevice = null;
            }
            this.updateLogConsole();
        });
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AndroidLogcatView.$$$reportNull$$$0(0);
        }
        return project;
    }

    @NotNull
    DeviceContext getDeviceContext() {
        DeviceContext deviceContext = this.myDeviceContext;
        if (deviceContext == null) {
            AndroidLogcatView.$$$reportNull$$$0(1);
        }
        return deviceContext;
    }

    @NotNull
    public final LogConsoleBase getLogConsole() {
        AndroidLogConsole androidLogConsole = this.myLogConsole;
        if (androidLogConsole == null) {
            AndroidLogcatView.$$$reportNull$$$0(2);
        }
        return androidLogConsole;
    }

    public AndroidLogcatView(final @NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull String toolWindowId) {
        if (project == null) {
            AndroidLogcatView.$$$reportNull$$$0(3);
        }
        if (deviceContext == null) {
            AndroidLogcatView.$$$reportNull$$$0(4);
        }
        if (toolWindowId == null) {
            AndroidLogcatView.$$$reportNull$$$0(5);
        }
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.myToolWindowId = toolWindowId;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myLogFilterModel = new AndroidLogFilterModel(){

            @NotNull
            private AndroidLogcatPreferences getPreferences() {
                AndroidLogcatPreferences androidLogcatPreferences = AndroidLogcatPreferences.getInstance(project);
                if (androidLogcatPreferences == null) {
                    2.$$$reportNull$$$0(0);
                }
                return androidLogcatPreferences;
            }

            @Override
            protected void saveLogLevel(String logLevelName) {
                this.getPreferences().TOOL_WINDOW_LOG_LEVEL = logLevelName;
            }

            @Override
            public String getSelectedLogLevelName() {
                return this.getPreferences().TOOL_WINDOW_LOG_LEVEL;
            }

            @Override
            protected void saveConfiguredFilterName(String filterName) {
                this.getPreferences().TOOL_WINDOW_CONFIGURED_FILTER = filterName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/logcat/AndroidLogcatView$2", "getPreferences"));
            }
        };
        this.myLogConsole = new AndroidLogConsole(this, project, this.myLogFilterModel);
        this.myLogcatReceiver = new FormattedLogcatReceiver(){

            @Override
            protected void receiveFormattedLogLine(@NotNull String line) {
                if (line == null) {
                    3.$$$reportNull$$$0(0);
                }
                AndroidLogcatView.this.myLogConsole.addLogLine(line);
            }

            @Override
            public void onCleared() {
                AndroidLogcatView.this.myLogFilterModel.beginRejectingOldMessages();
                if (AndroidLogcatView.this.myLogConsole.getConsole() != null) {
                    AndroidLogcatView.this.myLogConsole.clear();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatView$3", "receiveFormattedLogLine"));
            }
        };
        DeviceContext.DeviceSelectionListener deviceSelectionListener = new DeviceContext.DeviceSelectionListener(){

            @Override
            public void deviceSelected(@Nullable IDevice device) {
                AndroidLogcatView.this.notifyDeviceUpdated(false);
            }

            @Override
            public void deviceChanged(@NotNull IDevice device, int changeMask) {
                if (device == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (device == AndroidLogcatView.this.myDevice && (changeMask & 1) == 1) {
                    AndroidLogcatView.this.notifyDeviceUpdated(true);
                }
            }

            @Override
            public void clientSelected(@Nullable Client c) {
                if (AndroidLogcatView.this.myFilterComboBoxModel == null) {
                    return;
                }
                AndroidLogcatFilter selected = (AndroidLogcatFilter)AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem();
                AndroidLogcatView.this.updateDefaultFilters(c != null ? c.getClientData() : null);
                if (selected != null && AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem() != selected) {
                    AndroidLogcatView.this.selectFilterByName(selected.getName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/logcat/AndroidLogcatView$4", "deviceChanged"));
            }
        };
        deviceContext.addListener(deviceSelectionListener, this);
        this.myNoFilter = new DefaultAndroidLogcatFilter.Builder(NO_FILTERS).build();
        JComponent consoleComponent = this.myLogConsole.getComponent();
        ConsoleView console = this.myLogConsole.getConsole();
        if (console != null) {
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("AndroidLogcatView", this.myLogConsole.getOrCreateActions(), false);
            toolbar.setTargetComponent(console.getComponent());
            JComponent tbComp1 = toolbar.getComponent();
            this.myPanel.add((Component)tbComp1, "West");
        }
        this.myPanel.add((Component)consoleComponent, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myLogConsole);
        this.updateLogConsole();
    }

    @NotNull
    public final JPanel createSearchComponent() {
        JPanel panel = new JPanel();
        panel.add(this.createEditFiltersComboBox());
        JPanel searchComponent = new JPanel();
        searchComponent.setLayout(new BoxLayout(searchComponent, 0));
        searchComponent.add(this.myLogConsole.getSearchComponent());
        searchComponent.add(panel);
        JPanel jPanel = searchComponent;
        if (jPanel == null) {
            AndroidLogcatView.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    public Component createEditFiltersComboBox() {
        ComboBox editFiltersCombo = new ComboBox();
        this.myFilterComboBoxModel = new DefaultComboBoxModel();
        this.myFilterComboBoxModel.addElement(this.myNoFilter);
        this.myFilterComboBoxModel.addElement(EDIT_FILTER_CONFIGURATION_ITEM);
        this.updateDefaultFilters(null);
        this.updateUserFilters();
        String selectName = AndroidLogcatPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER;
        if (StringUtil.isEmpty((String)selectName)) {
            selectName = this.myDeviceContext != null ? SELECTED_APP_FILTER : NO_FILTERS;
        }
        this.selectFilterByName(selectName);
        editFiltersCombo.setModel(this.myFilterComboBoxModel);
        this.applySelectedFilter();
        editFiltersCombo.addItemListener(new ItemListener((JComboBox)editFiltersCombo){
            @Nullable
            private AndroidLogcatFilter myLastSelected;
            final /* synthetic */ JComboBox val$editFiltersCombo;
            {
                this.val$editFiltersCombo = jComboBox;
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 2) {
                    if (item instanceof AndroidLogcatFilter) {
                        this.myLastSelected = (AndroidLogcatFilter)item;
                    }
                } else if (e.getStateChange() == 1) {
                    if (item.equals(EDIT_FILTER_CONFIGURATION_ITEM)) {
                        EditLogFilterDialog dialog = new EditLogFilterDialog(AndroidLogcatView.this, this.myLastSelected == null ? null : this.myLastSelected.getName());
                        dialog.setTitle(AndroidBundle.message("android.logcat.new.filter.dialog.title", new Object[0]));
                        if (dialog.showAndGet()) {
                            PersistentAndroidLogFilters.FilterData filterData = dialog.getActiveFilter();
                            AndroidLogcatView.this.updateUserFilters();
                            if (filterData != null) {
                                AndroidLogcatView.this.selectFilterByName(filterData.getName());
                            }
                        } else {
                            this.val$editFiltersCombo.setSelectedItem(this.myLastSelected);
                        }
                    } else {
                        AndroidLogcatView.this.applySelectedFilter();
                    }
                }
            }
        });
        editFiltersCombo.setRenderer(new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (value instanceof AndroidLogcatFilter) {
                    this.setBorder(null);
                    this.append(((AndroidLogcatFilter)value).getName());
                } else {
                    this.setBorder(IdeBorderFactory.createBorder((int)8));
                    this.append(value.toString());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/logcat/AndroidLogcatView$6", "customizeCellRenderer"));
            }
        });
        ComboBox comboBox = editFiltersCombo;
        if (comboBox == null) {
            AndroidLogcatView.$$$reportNull$$$0(7);
        }
        return comboBox;
    }

    boolean isActive() {
        ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(this.myToolWindowId);
        return window.isVisible();
    }

    public final void activate() {
        if (this.isActive()) {
            this.updateLogConsole();
        }
        if (this.myLogConsole != null) {
            this.myLogConsole.activate();
        }
    }

    private void updateLogConsole() {
        IDevice device = this.getSelectedDevice();
        if (this.myDevice != device) {
            AndroidLogcatService androidLogcatService = AndroidLogcatService.getInstance();
            if (this.myDevice != null) {
                androidLogcatService.removeListener(this.myDevice, this.myLogcatReceiver);
            }
            if (this.myLogConsole.getConsole() != null) {
                this.myLogConsole.clear();
            }
            this.myLogFilterModel.processingStarted();
            this.myDevice = device;
            androidLogcatService.addListener(this.myDevice, this.myLogcatReceiver, true);
        }
    }

    @Nullable
    IDevice getSelectedDevice() {
        if (this.myDeviceContext != null) {
            return this.myDeviceContext.getSelectedDevice();
        }
        return null;
    }

    private void applySelectedFilter() {
        final Object filter = this.myFilterComboBoxModel.getSelectedItem();
        if (filter instanceof AndroidLogcatFilter) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Applying Filter..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    AndroidLogcatView.this.myLogFilterModel.updateLogcatFilter((AndroidLogcatFilter)filter);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/logcat/AndroidLogcatView$7", "run"));
                }
            });
        }
    }

    private void updateDefaultFilters(@Nullable ClientData client) {
        int noFilterIndex = this.myFilterComboBoxModel.getIndexOf(this.myNoFilter);
        for (int i = 0; i < noFilterIndex; ++i) {
            this.myFilterComboBoxModel.removeElementAt(0);
        }
        int insertIndex = 0;
        DefaultAndroidLogcatFilter.Builder selectedAppFilterBuilder = new DefaultAndroidLogcatFilter.Builder(SELECTED_APP_FILTER);
        if (client != null) {
            selectedAppFilterBuilder.setPid(client.getPid());
        }
        this.myFilterComboBoxModel.insertElementAt(selectedAppFilterBuilder.build(), insertIndex++);
        for (LogcatFilterProvider filterProvider : (LogcatFilterProvider[])LogcatFilterProvider.EP_NAME.getExtensions()) {
            AndroidLogcatFilter filter = filterProvider.getFilter(client);
            this.myFilterComboBoxModel.insertElementAt(filter, insertIndex++);
        }
    }

    private void updateUserFilters() {
        int editFilterConfigurationItemIndex = this.myFilterComboBoxModel.getIndexOf(EDIT_FILTER_CONFIGURATION_ITEM);
        assert (editFilterConfigurationItemIndex != -1);
        int userFiltersStartIndex = editFilterConfigurationItemIndex + 1;
        while (this.myFilterComboBoxModel.getSize() > userFiltersStartIndex) {
            this.myFilterComboBoxModel.removeElementAt(userFiltersStartIndex);
        }
        List<PersistentAndroidLogFilters.FilterData> filters = PersistentAndroidLogFilters.getInstance(this.myProject).getFilters();
        for (PersistentAndroidLogFilters.FilterData filter : filters) {
            String name = filter.getName();
            assert (name != null);
            DefaultAndroidLogcatFilter compiled = DefaultAndroidLogcatFilter.compile(filter, name);
            this.myFilterComboBoxModel.addElement(compiled);
        }
    }

    private void selectFilterByName(String name) {
        Optional<AndroidLogcatFilter> optionalFilter = IntStream.range(0, this.myFilterComboBoxModel.getSize()).mapToObj(i -> this.myFilterComboBoxModel.getElementAt(i)).filter(filter -> filter.getName().equals(name)).findFirst();
        optionalFilter.ifPresent(filter -> this.myFilterComboBoxModel.setSelectedItem(filter));
    }

    @NotNull
    public final JPanel getContentPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            AndroidLogcatView.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    public final void dispose() {
        if (this.myDevice != null) {
            AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogConsole";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditFiltersComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        ((Component)jPanel).setBackground(new Color(-1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static final class MyConfigureLogcatHeaderAction
    extends AnAction {
        private final AndroidLogcatView myView;

        MyConfigureLogcatHeaderAction(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyConfigureLogcatHeaderAction.$$$reportNull$$$0(0);
            }
            super(AndroidBundle.message("android.configure.logcat.header.text", new Object[0]), AndroidBundle.message("android.configure.logcat.header.description", new Object[0]), AllIcons.General.GearPlain);
            this.myView = view;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ConfigureLogcatFormatDialog dialog;
            if (e == null) {
                MyConfigureLogcatHeaderAction.$$$reportNull$$$0(1);
            }
            if ((dialog = new ConfigureLogcatFormatDialog(this.myView.myProject)).showAndGet()) {
                this.myView.myLogConsole.refresh();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView$MyConfigureLogcatHeaderAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MyRestartAction
    extends AnAction {
        private final AndroidLogcatView myView;

        MyRestartAction(@NotNull AndroidLogcatView view) {
            if (view == null) {
                MyRestartAction.$$$reportNull$$$0(0);
            }
            super(AndroidBundle.message("android.restart.logcat.action.text", new Object[0]), AndroidBundle.message("android.restart.logcat.action.description", new Object[0]), AllIcons.Actions.Restart);
            this.myView = view;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRestartAction.$$$reportNull$$$0(1);
            }
            this.myView.notifyDeviceUpdated(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatView$MyRestartAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

