/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.property.editors.AnimationEditorKt;
import com.android.tools.idea.uibuilder.property.editors.support.ValueWithDisplayString;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddActionDialog
extends DialogWrapper {
    JComboBox<NlComponent> myFromComboBox;
    JComboBox<NlComponent> myDestinationComboBox;
    JComboBox<ValueWithDisplayString> myEnterComboBox;
    JComboBox<ValueWithDisplayString> myExitComboBox;
    JComboBox<ValueWithDisplayString> myPopToComboBox;
    JCheckBox myInclusiveCheckBox;
    JCheckBox mySingleTopCheckBox;
    JCheckBox myDocumentCheckBox;
    JCheckBox myClearTaskCheckBox;
    JPanel myContentPanel;

    protected AddActionDialog(@NotNull Defaults defaultsType, @Nullable NlComponent existingAction, @NotNull NlComponent parent, @Nullable ResourceResolver resourceResolver) {
        if (defaultsType == null) {
            AddActionDialog.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            AddActionDialog.$$$reportNull$$$0(1);
        }
        super(false);
        this.$$$setupUI$$$();
        NlModel model = parent.getModel();
        this.setUpComponents(model, resourceResolver);
        this.myFromComboBox.addItem(parent);
        if (existingAction != null) {
            this.setupFromExisting(existingAction);
        } else {
            this.setDefaults(defaultsType, parent);
        }
        this.init();
        if (existingAction == null) {
            this.myOKAction.putValue("Name", "Add");
            this.setTitle("Add Action");
        } else {
            this.myOKAction.putValue("Name", "Update");
            this.setTitle("Update Action");
        }
    }

    private void setDefaults(@NotNull Defaults type, @NotNull NlComponent parent) {
        if (type == null) {
            AddActionDialog.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            AddActionDialog.$$$reportNull$$$0(3);
        }
        this.myDestinationComboBox.addItem(null);
        NavComponentHelperKt.getVisibleDestinations(parent).forEach(c -> this.myDestinationComboBox.addItem((NlComponent)c));
        if (type == Defaults.GLOBAL) {
            this.myFromComboBox.addItem(parent.getParent());
            this.myFromComboBox.setSelectedIndex(this.myFromComboBox.getItemCount() - 1);
            this.myDestinationComboBox.setSelectedItem(parent);
        } else if (type == Defaults.RETURN_TO_SOURCE) {
            AddActionDialog.selectItem(this.myPopToComboBox, "id", "http://schemas.android.com/apk/res/android", parent);
            this.myInclusiveCheckBox.setSelected(true);
            this.myDestinationComboBox.setSelectedItem(null);
        }
    }

    private void setupFromExisting(@NotNull NlComponent action) {
        String destination;
        if (action == null) {
            AddActionDialog.$$$reportNull$$$0(4);
        }
        this.myFromComboBox.addItem(action.getParent());
        if (!action.getParent().isRoot()) {
            this.myFromComboBox.addItem(action.getParent());
        }
        if ((destination = NavComponentHelperKt.getActionDestinationId(action)) != null) {
            this.myDestinationComboBox.addItem(NavComponentHelperKt.findVisibleDestination(action.getParent(), destination));
            this.myDestinationComboBox.setSelectedIndex(0);
        }
        this.myDestinationComboBox.setEnabled(false);
        AddActionDialog.selectItem(this.myPopToComboBox, "popUpTo", "http://schemas.android.com/apk/res-auto", action);
        this.myInclusiveCheckBox.setSelected(NavComponentHelperKt.getInclusive(action));
        AddActionDialog.selectItem(this.myEnterComboBox, "enterAnim", "http://schemas.android.com/apk/res-auto", action);
        AddActionDialog.selectItem(this.myExitComboBox, "exitAnim", "http://schemas.android.com/apk/res-auto", action);
        this.mySingleTopCheckBox.setSelected(NavComponentHelperKt.getSingleTop(action));
        this.myDocumentCheckBox.setSelected(NavComponentHelperKt.getDocument(action));
        this.myClearTaskCheckBox.setSelected(NavComponentHelperKt.getClearTask(action));
    }

    private static void selectItem(@NotNull JComboBox<ValueWithDisplayString> comboBox, @NotNull String attrName, @Nullable String namespace, @NotNull NlComponent component2) {
        String value;
        if (comboBox == null) {
            AddActionDialog.$$$reportNull$$$0(5);
        }
        if (attrName == null) {
            AddActionDialog.$$$reportNull$$$0(6);
        }
        if (component2 == null) {
            AddActionDialog.$$$reportNull$$$0(7);
        }
        if ((value = component2.getAttribute(namespace, attrName)) != null) {
            if (value.startsWith("@+")) {
                value = "@" + value.substring(2);
            }
            for (int i = 0; i < comboBox.getItemCount(); ++i) {
                if (!value.equals(comboBox.getItemAt(i).getValue())) continue;
                comboBox.setSelectedIndex(i);
                return;
            }
        }
    }

    private void setUpComponents(@NotNull NlModel model, final @Nullable ResourceResolver resourceResolver) {
        if (model == null) {
            AddActionDialog.$$$reportNull$$$0(8);
        }
        ListCellRendererWrapper<NlComponent> componentRenderer = new ListCellRendererWrapper<NlComponent>(){

            public void customize(JList list, NlComponent value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.setText("None");
                } else {
                    this.setText(NavComponentHelperKt.getUiName(value, resourceResolver));
                }
            }
        };
        this.myFromComboBox.setRenderer((ListCellRenderer<NlComponent>)componentRenderer);
        this.myFromComboBox.setEnabled(false);
        this.myDestinationComboBox.setRenderer((ListCellRenderer<NlComponent>)componentRenderer);
        LocalResourceManager resourceManager = LocalResourceManager.getInstance(model.getModule());
        this.myDestinationComboBox.addItemListener(event -> {
            this.myEnterComboBox.removeAllItems();
            this.myExitComboBox.removeAllItems();
            this.myEnterComboBox.addItem(new ValueWithDisplayString("None", null));
            this.myExitComboBox.addItem(new ValueWithDisplayString("None", null));
            AnimationEditorKt.getAnimatorsPopupContent(resourceManager, NavComponentHelperKt.getDestinationType((NlComponent)event.getItem()) == NavigationSchema.DestinationType.FRAGMENT).forEach(item -> {
                this.myEnterComboBox.addItem((ValueWithDisplayString)item);
                this.myExitComboBox.addItem((ValueWithDisplayString)item);
            });
        });
        this.myEnterComboBox.addItem(new ValueWithDisplayString("None", null));
        this.myExitComboBox.addItem(new ValueWithDisplayString("None", null));
        this.myPopToComboBox.addItem(new ValueWithDisplayString("None", null));
        model.flattenComponents().filter(c -> NavComponentHelperKt.isDestination(c)).forEach(c -> this.myPopToComboBox.addItem(new ValueWithDisplayString(NavComponentHelperKt.getUiName(c, resourceResolver), "@id/" + c.getId())));
    }

    @NotNull
    public NlComponent getSource() {
        NlComponent nlComponent = (NlComponent)this.myFromComboBox.getSelectedItem();
        if (nlComponent == null) {
            AddActionDialog.$$$reportNull$$$0(9);
        }
        return nlComponent;
    }

    @Nullable
    public NlComponent getDestination() {
        return (NlComponent)this.myDestinationComboBox.getSelectedItem();
    }

    @Nullable
    public String getEnterTransition() {
        return ((ValueWithDisplayString)this.myEnterComboBox.getSelectedItem()).getValue();
    }

    @Nullable
    public String getExitTransition() {
        return ((ValueWithDisplayString)this.myExitComboBox.getSelectedItem()).getValue();
    }

    @Nullable
    public String getPopTo() {
        return ((ValueWithDisplayString)this.myPopToComboBox.getSelectedItem()).getValue();
    }

    public boolean isInclusive() {
        return this.myInclusiveCheckBox.isSelected();
    }

    public boolean isSingleTop() {
        return this.mySingleTopCheckBox.isSelected();
    }

    public boolean isDocument() {
        return this.myDocumentCheckBox.isSelected();
    }

    public boolean isClearTask() {
        return this.myClearTaskCheckBox.isSelected();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myDestinationComboBox.getSelectedItem() == null && ((ValueWithDisplayString)this.myPopToComboBox.getSelectedItem()).getValue() == null) {
            return new ValidationInfo("Destination must be set!", this.myDestinationComboBox);
        }
        return super.doValidate();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            AddActionDialog.$$$reportNull$$$0(10);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultsType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/property/inspector/AddActionDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/property/inspector/AddActionDialog";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDefaults";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupFromExisting";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setUpComponents";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(16, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Direction");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("From");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Destination");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Transition");
        jPanel.add((Component)titledSeparator2, new GridConstraints(4, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Enter");
        jPanel.add((Component)jBLabel3, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myFromComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(1, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 1, null, new Dimension(30, -1), null));
        JComboBox jComboBox2 = new JComboBox();
        this.myDestinationComboBox = jComboBox2;
        jPanel.add(jComboBox2, new GridConstraints(2, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.myEnterComboBox = jComboBox3;
        jPanel.add(jComboBox3, new GridConstraints(5, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Exit");
        jPanel.add((Component)jBLabel4, new GridConstraints(6, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox4 = new JComboBox();
        this.myExitComboBox = jComboBox4;
        jPanel.add(jComboBox4, new GridConstraints(6, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(7, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator3 = new TitledSeparator();
        titledSeparator3.setText("Pop Behavior");
        jPanel.add((Component)titledSeparator3, new GridConstraints(8, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("Pop To");
        jPanel.add((Component)jBLabel5, new GridConstraints(9, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox5 = new JComboBox();
        this.myPopToComboBox = jComboBox5;
        jPanel.add(jComboBox5, new GridConstraints(9, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("Inclusive");
        jPanel.add((Component)jBLabel6, new GridConstraints(10, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInclusiveCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setSelected(false);
        jCheckBox4.setText("");
        jPanel.add((Component)jCheckBox4, new GridConstraints(10, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(11, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator4 = new TitledSeparator();
        titledSeparator4.setText("Launch Options");
        jPanel.add((Component)titledSeparator4, new GridConstraints(12, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Single Top");
        jPanel.add((Component)jBLabel7, new GridConstraints(13, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Document");
        jPanel.add((Component)jBLabel8, new GridConstraints(14, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySingleTopCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("");
        jPanel.add((Component)jCheckBox3, new GridConstraints(13, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDocumentCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("");
        jPanel.add((Component)jCheckBox2, new GridConstraints(14, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClearTaskCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(15, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("Clear Task");
        jPanel.add((Component)jBLabel9, new GridConstraints(15, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, new Dimension(200, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    public static enum Defaults {
        NORMAL,
        RETURN_TO_SOURCE,
        GLOBAL;

    }
}

