/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.decorator;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawTruncatedText;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.ThumbnailManager;
import com.android.tools.idea.naveditor.scene.draw.DrawFilledRectangle;
import com.android.tools.idea.naveditor.scene.draw.DrawNavScreen;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0004\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/naveditor/scene/decorator/NavScreenDecorator;", "Lcom/android/tools/idea/common/scene/decorator/SceneDecorator;", "()V", "addBackground", "", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "addFrame", "buildImage", "Lcom/android/tools/idea/rendering/ImagePool$Image;", "buildList", "time", "", "buildListChildren", "drawImage", "rectangle", "Ljava/awt/Rectangle;", "intellij.android.designer"})
public abstract class NavScreenDecorator
extends SceneDecorator {
    @Override
    protected void addFrame(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkParameterIsNotNull((Object)component2, (String)"component");
    }

    @Override
    protected void addBackground(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkParameterIsNotNull((Object)component2, (String)"component");
    }

    @Override
    public void buildList(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkParameterIsNotNull((Object)component2, (String)"component");
        DisplayList displayList = new DisplayList();
        super.buildList(displayList, time, sceneContext, component2);
        list.add(NavDrawHelperKt.createDrawCommand(displayList, component2));
    }

    @Override
    protected void buildListChildren(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkParameterIsNotNull((Object)component2, (String)"component");
        for (SceneComponent child : component2.getChildren()) {
            child.buildDisplayList(time, list, sceneContext);
        }
    }

    protected final void drawImage(@NotNull DisplayList list, @NotNull SceneContext sceneContext, @NotNull SceneComponent component2, @NotNull Rectangle rectangle) {
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        Intrinsics.checkParameterIsNotNull((Object)component2, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        ImagePool.Image image = this.buildImage(sceneContext, component2);
        if (image == null) {
            ColorSet colorSet = sceneContext.getColorSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)colorSet, (String)"sceneContext.colorSet");
            Color color = colorSet.getComponentBackground();
            Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"sceneContext.colorSet.componentBackground");
            list.add(new DrawFilledRectangle(rectangle, color, 0));
            ColorSet colorSet2 = sceneContext.getColorSet();
            Intrinsics.checkExpressionValueIsNotNull((Object)colorSet2, (String)"sceneContext.colorSet");
            Color color2 = colorSet2.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"sceneContext.colorSet.text");
            list.add(new DrawTruncatedText(3, "Preview Unavailable", rectangle, color2, NavDrawHelperKt.scaledFont(sceneContext, 0), true));
        } else {
            list.add(new DrawNavScreen(rectangle.x, rectangle.y, rectangle.width, rectangle.height, image));
        }
    }

    private final ImagePool.Image buildImage(SceneContext sceneContext, SceneComponent component2) {
        ImagePool.Image image;
        DesignSurface surface;
        DesignSurface designSurface = sceneContext.getSurface();
        if (designSurface == null) {
            return null;
        }
        DesignSurface designSurface2 = surface = designSurface;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)designSurface2), (String)"surface");
        Configuration configuration = designSurface2.getConfiguration();
        NlModel nlModel = surface.getModel();
        if (nlModel == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)nlModel, (String)"surface.model!!");
        AndroidFacet facet = nlModel.getFacet();
        String string = component2.getNlComponent().getAttribute("http://schemas.android.com/tools", "layout");
        if (string == null) {
            return null;
        }
        String layout = string;
        Object object = configuration;
        if (object == null || (object = ((Configuration)object).getResourceResolver()) == null || (object = object.findResValue(layout, false)) == null || (object = object.getValue()) == null) {
            return null;
        }
        Object fileName = object;
        File file = new File((String)fileName);
        if (!file.exists()) {
            return null;
        }
        ThumbnailManager manager = ThumbnailManager.getInstance(facet);
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(surface.getProject(), virtualFile2);
        if (!(psiFile instanceof XmlFile)) {
            psiFile = null;
        }
        XmlFile xmlFile = (XmlFile)psiFile;
        if (xmlFile == null) {
            return null;
        }
        XmlFile psiFile2 = xmlFile;
        CompletableFuture<ImagePool.Image> completableFuture = manager.getThumbnail(psiFile2, surface, configuration);
        if (completableFuture == null) {
            return null;
        }
        CompletableFuture<ImagePool.Image> thumbnail2 = completableFuture;
        try {
            image = thumbnail2.get();
        }
        catch (InterruptedException ignore) {
            image = null;
        }
        catch (ExecutionException ignore) {
            image = null;
        }
        return image;
    }
}

