/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.layout;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.naveditor.scene.layout.DummyAlgorithm;
import com.android.tools.idea.naveditor.scene.layout.NavSceneLayoutAlgorithm;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManualLayoutAlgorithm
implements NavSceneLayoutAlgorithm {
    private NavSceneLayoutAlgorithm myFallback;
    private NavigationSchema mySchema;
    private Module myModule;
    private Storage myStorage;

    public ManualLayoutAlgorithm(@NotNull Module module) {
        if (module == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(0);
        }
        this.myModule = module;
    }

    ManualLayoutAlgorithm(@NotNull NavSceneLayoutAlgorithm fallback, @NotNull NavigationSchema schema, @NotNull LayoutPositions state) {
        if (fallback == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(1);
        }
        if (schema == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(2);
        }
        if (state == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(3);
        }
        this.myFallback = fallback;
        this.mySchema = schema;
        this.myStorage = new Storage();
        this.myStorage.myState = state;
    }

    @NotNull
    private NavigationSchema getSchema() {
        if (this.mySchema == null) {
            AndroidFacet instance = AndroidFacet.getInstance(this.myModule);
            assert (instance != null);
            this.mySchema = NavigationSchema.get(instance);
        }
        NavigationSchema navigationSchema = this.mySchema;
        if (navigationSchema == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(4);
        }
        return navigationSchema;
    }

    private NavSceneLayoutAlgorithm getFallback() {
        if (this.myFallback == null) {
            this.myFallback = new DummyAlgorithm(this.getSchema());
        }
        return this.myFallback;
    }

    @Override
    public void layout(@NotNull SceneComponent component2) {
        Point location;
        NavigationSchema.DestinationType type;
        if (component2 == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(5);
        }
        if ((type = this.getSchema().getDestinationType(component2.getNlComponent().getTagName())) == NavigationSchema.DestinationType.NAVIGATION && component2.getParent() == null) {
            return;
        }
        Deque<String> stack = ManualLayoutAlgorithm.getParentStack(component2);
        LayoutPositions positions = this.getStorage().getState();
        String name = ManualLayoutAlgorithm.getFileName(component2);
        if (name == null) {
            return;
        }
        for (positions = positions.get(name); !stack.isEmpty() && positions != null; positions = positions.get(stack.pop())) {
        }
        if (positions != null && (location = positions.myPosition) != null) {
            component2.setPosition(location.x, location.y);
            return;
        }
        this.getFallback().layout(component2);
        this.save(component2);
    }

    @NotNull
    private static Deque<String> getParentStack(@NotNull SceneComponent component2) {
        if (component2 == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(6);
        }
        LinkedList<String> stack = new LinkedList<String>();
        for (NlComponent current = component2.getNlComponent(); current != null && !current.isRoot(); current = current.getParent()) {
            String id = current.getId();
            if (id == null) {
                NlModel model = current.getModel();
                Document doc = FileDocumentManager.getInstance().getDocument(model.getVirtualFile());
                int line = -1;
                if (doc != null) {
                    line = doc.getLineNumber(current.getTag().getTextRange().getStartOffset()) + 1;
                }
                Logger.getInstance(ManualLayoutAlgorithm.class).warn("Element with null id encountered" + (line != -1 ? " on line " + line : ""));
            }
            stack.push(id);
        }
        LinkedList<String> linkedList = stack;
        if (linkedList == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(7);
        }
        return linkedList;
    }

    public void save(@NotNull SceneComponent component2) {
        if (component2 == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(8);
        }
        LayoutPositions positions = this.getStorage().getState();
        Deque<String> stack = ManualLayoutAlgorithm.getParentStack(component2);
        stack.push(ManualLayoutAlgorithm.getFileName(component2));
        while (!stack.isEmpty()) {
            String element = stack.pop();
            if (element == null) {
                return;
            }
            LayoutPositions newPositions = positions.get(element);
            if (newPositions == null) {
                newPositions = new LayoutPositions();
                positions.put(element, newPositions);
            }
            positions = newPositions;
        }
        positions.myPosition = new Point(component2.getDrawX(), component2.getDrawY());
    }

    @NotNull
    private static String getFileName(@NotNull SceneComponent component2) {
        if (component2 == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(9);
        }
        String string = component2.getNlComponent().getModel().getVirtualFile().getName();
        if (string == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private Storage getStorage() {
        if (this.myStorage == null) {
            this.myStorage = (Storage)this.myModule.getProject().getComponent(Storage.class);
        }
        Storage storage = this.myStorage;
        if (storage == null) {
            ManualLayoutAlgorithm.$$$reportNull$$$0(11);
        }
        return storage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentStack";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParentStack";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @State(name="navEditor-manualLayoutAlgorithm", storages={@com.intellij.openapi.components.Storage(file="navEditor.xml")})
    private static class Storage
    implements PersistentStateComponent<LayoutPositions> {
        private LayoutPositions myState;

        private Storage() {
        }

        @NotNull
        public LayoutPositions getState() {
            if (this.myState == null) {
                this.myState = new LayoutPositions();
            }
            LayoutPositions layoutPositions = this.myState;
            if (layoutPositions == null) {
                Storage.$$$reportNull$$$0(0);
            }
            return layoutPositions;
        }

        public void loadState(@NotNull LayoutPositions state) {
            if (state == null) {
                Storage.$$$reportNull$$$0(1);
            }
            this.myState = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Storage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Storage";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class LayoutPositions {
        public Map<String, LayoutPositions> myPositions;
        public Point myPosition;

        LayoutPositions() {
        }

        @Nullable
        public LayoutPositions get(@Nullable String id) {
            return this.myPositions == null ? null : this.myPositions.get(id);
        }

        public void put(@NotNull String id, @NotNull LayoutPositions sub) {
            if (id == null) {
                LayoutPositions.$$$reportNull$$$0(0);
            }
            if (sub == null) {
                LayoutPositions.$$$reportNull$$$0(1);
            }
            if (this.myPositions == null) {
                this.myPositions = new HashMap<String, LayoutPositions>();
            }
            this.myPositions.put(id, sub);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sub";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions";
            objectArray[2] = "put";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Point {
        public int x;
        public int y;

        Point() {
        }

        Point(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

