/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.LerpValue;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawCircle;
import com.android.tools.idea.common.scene.draw.DrawFilledCircle;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.draw.DrawActionHandleDrag;
import com.android.tools.idea.naveditor.scene.targets.NavBaseTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.psi.PsiFile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.util.List;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionHandleTarget
extends NavBaseTarget {
    private static final int INNER_RADIUS_SMALL = 5;
    private static final int INNER_RADIUS_LARGE = 8;
    private static final int OUTER_RADIUS_SMALL = 7;
    private static final int OUTER_RADIUS_LARGE = 11;
    private static final int HORIZONTAL_OFFSET = 3;
    private static final int DURATION = 200;
    private static final int STROKE_WIDTH = 2;
    private static final BasicStroke STROKE = new BasicStroke(2.0f);
    private HandleState myHandleState;
    private boolean myIsDragging;

    public ActionHandleTarget(@NotNull SceneComponent component2) {
        if (component2 == null) {
            ActionHandleTarget.$$$reportNull$$$0(0);
        }
        super(component2);
        this.myIsDragging = false;
        this.myHandleState = this.calculateState();
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            ActionHandleTarget.$$$reportNull$$$0(1);
        }
        this.layoutCircle(r + 3, t + (b - t) / 2, this.myHandleState.myOuterRadius);
        return false;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myComponent.getScene().getDesignSurface().getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)this.getComponent().getNlComponent()));
        this.myIsDragging = true;
        this.myComponent.getScene().needsRebuildList();
        this.getComponent().setDragging(true);
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        this.myIsDragging = false;
        this.getComponent().setDragging(false);
    }

    public void createAction(@NotNull SceneComponent destination) {
        NlComponent destinationNlComponent;
        NavigationSchema schema;
        if (destination == null) {
            ActionHandleTarget.$$$reportNull$$$0(2);
        }
        if ((schema = NavigationSchema.get((destinationNlComponent = destination.getNlComponent()).getModel().getFacet())).getDestinationType(destinationNlComponent.getTagName()) == null) {
            return;
        }
        final NlComponent myNlComponent = this.getComponent().getNlComponent();
        NlModel myModel = myNlComponent.getModel();
        new WriteCommandAction(myModel.getProject(), "Create Action", new PsiFile[]{myModel.getFile()}){

            protected void run(@NotNull Result result) {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                NlComponent action = NavComponentHelperKt.createAction(myNlComponent, destinationNlComponent.getId());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/naveditor/scene/targets/ActionHandleTarget$1", "run"));
            }
        }.execute();
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            ActionHandleTarget.$$$reportNull$$$0(3);
        }
        if (sceneContext == null) {
            ActionHandleTarget.$$$reportNull$$$0(4);
        }
        if (this.myIsDragging) {
            list.add(new DrawActionHandleDrag(this.getSwingCenterX(sceneContext), this.getSwingCenterY(sceneContext), sceneContext.getSwingDimension(this.myHandleState.myOuterRadius)));
            return;
        }
        HandleState newState = this.calculateState();
        if (newState == HandleState.INVISIBLE && this.myHandleState == HandleState.INVISIBLE) {
            return;
        }
        Point center = new Point(this.getSwingCenterX(sceneContext), this.getSwingCenterY(sceneContext));
        int initialRadius = sceneContext.getSwingDimension(this.myHandleState.myOuterRadius);
        int finalRadius = sceneContext.getSwingDimension(newState.myOuterRadius);
        int duration = Math.abs(200 * (finalRadius - initialRadius) / 11);
        ColorSet colorSet = sceneContext.getColorSet();
        list.add(new DrawFilledCircle(6, center, colorSet.getBackground(), new LerpValue(initialRadius, finalRadius, duration)));
        initialRadius = sceneContext.getSwingDimension(this.myHandleState.myInnerRadius);
        finalRadius = sceneContext.getSwingDimension(newState.myInnerRadius);
        Color color = this.getComponent().isSelected() ? colorSet.getSelectedFrames() : colorSet.getSubduedFrames();
        list.add(new DrawCircle(7, center, color, STROKE, new LerpValue(initialRadius, finalRadius, duration)));
        this.myHandleState = newState;
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        if (transform2 == null) {
            ActionHandleTarget.$$$reportNull$$$0(5);
        }
        if (picker == null) {
            ActionHandleTarget.$$$reportNull$$$0(6);
        }
        picker.addCircle(this, 0, this.getSwingCenterX(transform2), this.getSwingCenterY(transform2), transform2.getSwingDimension(11));
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    private HandleState calculateState() {
        if (this.mIsOver) {
            return HandleState.LARGE;
        }
        if (this.getComponent().getDrawState() == SceneComponent.DrawState.HOVER) {
            return HandleState.SMALL;
        }
        if (this.getComponent().isSelected() && this.myComponent.getScene().getSelection().size() == 1) {
            return HandleState.SMALL;
        }
        return HandleState.INVISIBLE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/naveditor/scene/targets/ActionHandleTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addHit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum HandleState {
        INVISIBLE(0, 0),
        SMALL(5, 7),
        LARGE(8, 11);

        private final int myInnerRadius;
        private final int myOuterRadius;

        private HandleState(int innerRadius, int outerRadius) {
            this.myInnerRadius = innerRadius;
            this.myOuterRadius = outerRadius;
        }
    }
}

