/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.targets;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.ArrowDirection;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawArrow;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavColorSet;
import com.android.tools.idea.naveditor.scene.draw.DrawAction;
import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionTarget
extends BaseTarget {
    private Rectangle mySourceRect;
    private Rectangle myDestRect;
    private final NlComponent myNlComponent;
    private final SceneComponent myDestination;
    private boolean myHighlighted;
    private static final int SELF_ACTION_LENGTH_1 = 28;
    private static final int SELF_ACTION_LENGTH_2 = 26;
    private static final int SELF_ACTION_LENGTH_3 = 60;
    private static final int SELF_ACTION_LENGTH_4 = 8;
    private static final int ACTION_HORIZONTAL_PADDING = 8;
    private static final int ACTION_VERTICAL_PADDING = 8;

    public ActionTarget(@NotNull SceneComponent component2, @NotNull SceneComponent destination, @NotNull NlComponent actionComponent) {
        if (component2 == null) {
            ActionTarget.$$$reportNull$$$0(0);
        }
        if (destination == null) {
            ActionTarget.$$$reportNull$$$0(1);
        }
        if (actionComponent == null) {
            ActionTarget.$$$reportNull$$$0(2);
        }
        this.myHighlighted = false;
        this.setComponent(component2);
        this.myNlComponent = actionComponent;
        this.myDestination = destination;
    }

    public String getId() {
        return this.myNlComponent.getId();
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    public void setHighlighted(boolean highlighted) {
        this.myHighlighted = highlighted;
    }

    public boolean isHighlighted() {
        return this.myHighlighted;
    }

    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        this.myComponent.getScene().getDesignSurface().getSelectionModel().setSelection((List<NlComponent>)ImmutableList.of((Object)this.myNlComponent));
    }

    @Override
    public int getPreferenceLevel() {
        return 0;
    }

    @Override
    public boolean layout(@NotNull SceneContext context, int l, int t, int r, int b) {
        if (context == null) {
            ActionTarget.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        ArrowDirection direction;
        if (list == null) {
            ActionTarget.$$$reportNull$$$0(4);
        }
        if (sceneContext == null) {
            ActionTarget.$$$reportNull$$$0(5);
        }
        Rectangle sourceRect = Coordinates.getSwingRect(sceneContext, this.getComponent().fillRect(null));
        String sourceId = this.getComponent().getId();
        if (sourceId == null) {
            return;
        }
        String targetId = NavComponentHelperKt.getEffectiveDestinationId(this.myNlComponent);
        if (targetId == null) {
            return;
        }
        this.myDestRect = Coordinates.getSwingRect(sceneContext, this.myDestination.fillRect(null));
        this.mySourceRect = sourceRect;
        ConnectionType connectionType = ConnectionType.NORMAL;
        if (sourceId.equals(targetId)) {
            connectionType = ConnectionType.SELF;
        } else if (NavComponentHelperKt.getActionType(this.myNlComponent) == ActionType.EXIT) {
            connectionType = ConnectionType.EXIT;
        }
        boolean selected = this.getComponent().getScene().getSelection().contains(this.myNlComponent);
        DrawAction.buildDisplayList(list, connectionType, sourceRect, this.myDestRect, selected ? DrawAction.DrawMode.SELECTED : (this.mIsOver || this.myHighlighted ? DrawAction.DrawMode.HOVER : DrawAction.DrawMode.NORMAL));
        Rectangle rectangle = new Rectangle();
        if (sourceId.equals(targetId)) {
            rectangle.x = this.myDestRect.x + this.myDestRect.width + sceneContext.getSwingDimension(-38);
            rectangle.y = ActionTarget.getConnectionY(ConnectionDirection.BOTTOM, this.myDestRect) + sceneContext.getSwingDimension(8);
            rectangle.width = sceneContext.getSwingDimension(12);
            rectangle.height = sceneContext.getSwingDimension(10);
            direction = ArrowDirection.UP;
        } else {
            rectangle.x = ActionTarget.getConnectionX(ConnectionDirection.LEFT, this.myDestRect) + ActionTarget.getDestinationDx(ConnectionDirection.LEFT, sceneContext);
            rectangle.y = ActionTarget.getConnectionY(ConnectionDirection.LEFT, this.myDestRect) - sceneContext.getSwingDimension(12) / 2;
            rectangle.width = sceneContext.getSwingDimension(10);
            rectangle.height = sceneContext.getSwingDimension(12);
            direction = ArrowDirection.RIGHT;
        }
        NavColorSet colorSet = (NavColorSet)sceneContext.getColorSet();
        Color color = selected ? colorSet.getSelectedActions() : (this.mIsOver || this.myHighlighted ? colorSet.getHighlightedActions() : colorSet.getActions());
        list.add(new DrawArrow(2, direction, rectangle, color));
    }

    @Override
    public void addHit(@NotNull SceneContext transform2, @NotNull ScenePicker picker) {
        if (transform2 == null) {
            ActionTarget.$$$reportNull$$$0(6);
        }
        if (picker == null) {
            ActionTarget.$$$reportNull$$$0(7);
        }
        if (this.mySourceRect == null || this.myDestRect == null) {
            return;
        }
        String sourceId = this.getComponent().getId();
        if (sourceId == null) {
            return;
        }
        String targetId = NavComponentHelperKt.getEffectiveDestinationId(this.myNlComponent);
        if (targetId == null) {
            return;
        }
        if (sourceId.equals(targetId)) {
            SelfActionPoints points = ActionTarget.getSelfActionPoints(this.mySourceRect, transform2);
            for (int i = 1; i < points.x.length; ++i) {
                picker.addLine(this, 5, points.x[i - 1], points.y[i - 1], points.x[i], points.y[i]);
            }
            return;
        }
        CurvePoints points = ActionTarget.getCurvePoints(this.mySourceRect, this.myDestRect, transform2);
        picker.addCurveTo(this, 5, points.p1.x, points.p1.y, points.p2.x, points.p2.y, points.p3.x, points.p3.y, points.p4.x, points.p4.y);
    }

    @NotNull
    public static CurvePoints getCurvePoints(@NotNull Rectangle source, @NotNull Rectangle dest, SceneContext sceneContext) {
        if (source == null) {
            ActionTarget.$$$reportNull$$$0(8);
        }
        if (dest == null) {
            ActionTarget.$$$reportNull$$$0(9);
        }
        ConnectionDirection sourceDirection = ConnectionDirection.RIGHT;
        ConnectionDirection destDirection = ConnectionDirection.LEFT;
        int startx = ActionTarget.getConnectionX(sourceDirection, source);
        int starty = ActionTarget.getConnectionY(sourceDirection, source);
        int endx = ActionTarget.getConnectionX(destDirection, dest);
        int endy = ActionTarget.getConnectionY(destDirection, dest);
        int dx = ActionTarget.getDestinationDx(destDirection, sceneContext);
        int dy = ActionTarget.getDestinationDy(destDirection, sceneContext);
        int scale_source = sceneContext.getSwingDimension(100);
        int scale_dest = sceneContext.getSwingDimension(100);
        CurvePoints result = new CurvePoints();
        result.dir = destDirection;
        result.p1 = new Point(startx, starty);
        result.p2 = new Point(startx + scale_source * sourceDirection.getDeltaX(), starty + scale_source * sourceDirection.getDeltaY());
        result.p3 = new Point(endx + dx + scale_dest * destDirection.getDeltaX(), endy + dy + scale_dest * destDirection.getDeltaY());
        result.p4 = new Point(endx + dx, endy + dy);
        CurvePoints curvePoints = result;
        if (curvePoints == null) {
            ActionTarget.$$$reportNull$$$0(10);
        }
        return curvePoints;
    }

    @NotNull
    public static SelfActionPoints getSelfActionPoints(@NotNull Rectangle rect, @NotNull SceneContext sceneContext) {
        if (rect == null) {
            ActionTarget.$$$reportNull$$$0(11);
        }
        if (sceneContext == null) {
            ActionTarget.$$$reportNull$$$0(12);
        }
        ConnectionDirection sourceDirection = ConnectionDirection.RIGHT;
        ConnectionDirection destDirection = ConnectionDirection.BOTTOM;
        SelfActionPoints selfActionPoints = new SelfActionPoints();
        selfActionPoints.dir = destDirection;
        selfActionPoints.x[0] = ActionTarget.getConnectionX(sourceDirection, rect);
        selfActionPoints.x[1] = selfActionPoints.x[0] + sceneContext.getSwingDimension(28);
        selfActionPoints.x[2] = selfActionPoints.x[1];
        selfActionPoints.x[3] = selfActionPoints.x[2] - sceneContext.getSwingDimension(60) - 1;
        selfActionPoints.x[4] = selfActionPoints.x[3];
        selfActionPoints.y[0] = ActionTarget.getConnectionY(sourceDirection, rect);
        selfActionPoints.y[1] = selfActionPoints.y[0];
        selfActionPoints.y[2] = selfActionPoints.y[1] + rect.height / 2 + sceneContext.getSwingDimension(26);
        selfActionPoints.y[3] = selfActionPoints.y[2];
        selfActionPoints.y[4] = selfActionPoints.y[3] - sceneContext.getSwingDimension(8);
        SelfActionPoints selfActionPoints2 = selfActionPoints;
        if (selfActionPoints2 == null) {
            ActionTarget.$$$reportNull$$$0(13);
        }
        return selfActionPoints2;
    }

    private static int getConnectionX(@NotNull ConnectionDirection side, @NotNull Rectangle rect) {
        if (side == null) {
            ActionTarget.$$$reportNull$$$0(14);
        }
        if (rect == null) {
            ActionTarget.$$$reportNull$$$0(15);
        }
        return rect.x + side.getDeltaX() + (1 + side.getDeltaX()) * rect.width / 2;
    }

    private static int getConnectionY(@NotNull ConnectionDirection side, @NotNull Rectangle rect) {
        if (side == null) {
            ActionTarget.$$$reportNull$$$0(16);
        }
        if (rect == null) {
            ActionTarget.$$$reportNull$$$0(17);
        }
        return rect.y + side.getDeltaY() + (1 + side.getDeltaY()) * rect.height / 2;
    }

    public static int getDestinationDx(@NotNull ConnectionDirection side, SceneContext sceneContext) {
        if (side == null) {
            ActionTarget.$$$reportNull$$$0(18);
        }
        return side.getDeltaX() * sceneContext.getSwingDimension(18);
    }

    public static int getDestinationDy(@NotNull ConnectionDirection side, SceneContext sceneContext) {
        if (side == null) {
            ActionTarget.$$$reportNull$$$0(19);
        }
        return side.getDeltaY() * sceneContext.getSwingDimension(18);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/scene/targets/ActionTarget";
                break;
            }
            case 11: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/scene/targets/ActionTarget";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurvePoints";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfActionPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addHit";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCurvePoints";
                break;
            }
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelfActionPoints";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionX";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConnectionY";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationDx";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDestinationDy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ConnectionDirection {
        LEFT(-1, 0),
        RIGHT(1, 0),
        TOP(0, -1),
        BOTTOM(0, 1);

        private ConnectionDirection myOpposite;
        private final int myDeltaX;
        private final int myDeltaY;

        private ConnectionDirection(int deltaX, int deltaY) {
            this.myDeltaX = deltaX;
            this.myDeltaY = deltaY;
        }

        public int getDeltaX() {
            return this.myDeltaX;
        }

        public int getDeltaY() {
            return this.myDeltaY;
        }

        public ConnectionDirection getOpposite() {
            return this.myOpposite;
        }

        static {
            ConnectionDirection.LEFT.myOpposite = RIGHT;
            ConnectionDirection.RIGHT.myOpposite = LEFT;
            ConnectionDirection.TOP.myOpposite = BOTTOM;
            ConnectionDirection.BOTTOM.myOpposite = TOP;
        }
    }

    public static enum ConnectionType {
        NORMAL,
        SELF,
        EXIT;

    }

    public static class SelfActionPoints {
        public final int[] x = new int[5];
        public final int[] y = new int[5];
        public ConnectionDirection dir;
    }

    public static class CurvePoints {
        public Point p1;
        public Point p2;
        public Point p3;
        public Point p4;
        public ConnectionDirection dir;
    }
}

