/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.structure;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.google.common.collect.ImmutableMap;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.annotations.NotNull;

public class DestinationList
extends JPanel
implements ToolContent<DesignSurface> {
    static final String ROOT_NAME = "Root";
    final DefaultListModel<NlComponent> myListModel = new DefaultListModel();
    private NavigationSchema mySchema;
    private ResourceResolver myResourceResolver;
    SelectionModel mySelectionModel;
    public final JBList<NlComponent> myList;
    private boolean mySelectionUpdating;
    private SelectionListener mySelectionModelListener;
    private ModelListener myModelListener;
    private NlModel myModel;
    private ListSelectionListener myListSelectionListener;
    private MouseListener myMouseListener;
    public JLabel myBackLabel;
    JPanel myBackPanel;
    private NavDesignSurface myDesignSurface;
    private static final Map<Icon, Icon> WHITE_ICONS = ImmutableMap.of((Object)StudioIcons.NavEditor.Tree.FRAGMENT, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.FRAGMENT), (Object)StudioIcons.NavEditor.Tree.INCLUDE_GRAPH, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.INCLUDE_GRAPH), (Object)StudioIcons.NavEditor.Tree.ACTIVITY, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.ACTIVITY), (Object)StudioIcons.NavEditor.Tree.NESTED_GRAPH, (Object)ColoredIconGenerator.INSTANCE.generateWhiteIcon(StudioIcons.NavEditor.Tree.NESTED_GRAPH));

    private DestinationList() {
        this.setLayout(new BorderLayout());
        this.myList = new JBList(this.myListModel);
        this.myList.setName("DestinationList");
        this.myList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<NlComponent>(){

            protected void customizeCellRenderer(@NotNull JList<? extends NlComponent> list, NlComponent component2, int index, boolean isSelected, boolean cellHasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(NavComponentHelperKt.getUiName(component2, DestinationList.this.myResourceResolver));
                if (NavComponentHelperKt.isStartDestination(component2)) {
                    this.append(" - Start", SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
                Icon icon = StudioIcons.NavEditor.Tree.FRAGMENT;
                if (component2.getTagName().equals("include")) {
                    icon = StudioIcons.NavEditor.Tree.INCLUDE_GRAPH;
                } else if (NavComponentHelperKt.getDestinationType(component2) == NavigationSchema.DestinationType.ACTIVITY) {
                    icon = StudioIcons.NavEditor.Tree.ACTIVITY;
                } else if (DestinationList.this.mySchema.getDestinationType(component2.getTagName()) == NavigationSchema.DestinationType.NAVIGATION) {
                    icon = StudioIcons.NavEditor.Tree.NESTED_GRAPH;
                }
                if (isSelected) {
                    icon = (Icon)WHITE_ICONS.get(icon);
                }
                this.setIcon(icon);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/naveditor/structure/DestinationList$1", "customizeCellRenderer"));
            }
        });
        InputMap inputMap = this.getInputMap(1);
        String deleteDestinationKey = "deleteDestination";
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteDestination");
        inputMap.put(KeyStroke.getKeyStroke(8, 0), "deleteDestination");
        this.getActionMap().put("deleteDestination", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final List toDelete = DestinationList.this.myList.getSelectedValuesList();
                if (!toDelete.isEmpty()) {
                    new WriteCommandAction(DestinationList.this.myDesignSurface.getProject(), "Delete Destination" + (toDelete.size() > 1 ? "s" : ""), new PsiFile[]{DestinationList.this.myDesignSurface.getModel().getFile()}){

                        protected void run(@NotNull Result result) {
                            if (result == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            DestinationList.this.myDesignSurface.getModel().delete(toDelete);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/naveditor/structure/DestinationList$2$1", "run"));
                        }
                    }.execute();
                }
            }
        });
        JScrollPane pane = ScrollPaneFactory.createScrollPane(this.myList, (int)20, (int)30);
        pane.setBorder(null);
        this.add((Component)pane, "Center");
    }

    public void dispose() {
        this.mySelectionModel.removeListener(this.mySelectionModelListener);
        this.myModel.removeListener(this.myModelListener);
        this.myList.removeListSelectionListener(this.myListSelectionListener);
        this.myList.removeMouseListener(this.myMouseListener);
    }

    public void setToolContext(final DesignSurface toolContext) {
        this.myDesignSurface = (NavDesignSurface)toolContext;
        if (this.mySelectionModel != null && this.mySelectionModelListener != null) {
            this.mySelectionModel.removeListener(this.mySelectionModelListener);
        }
        if (this.myListSelectionListener != null) {
            this.myList.removeListSelectionListener(this.myListSelectionListener);
        }
        if (this.myModel != null && this.myModelListener != null) {
            this.myModel.removeListener(this.myModelListener);
        }
        if (toolContext != null) {
            this.add((Component)this.createBackPanel(toolContext), "North");
            this.myModel = toolContext.getModel();
            this.mySelectionModel = toolContext.getSelectionModel();
            this.mySelectionModelListener = (model, selection) -> {
                if (this.mySelectionUpdating) {
                    return;
                }
                try {
                    this.mySelectionUpdating = true;
                    HashSet<NlComponent> components = new HashSet<NlComponent>((Collection<NlComponent>)this.mySelectionModel.getSelection());
                    ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
                    for (int i = 0; i < this.myListModel.size(); ++i) {
                        if (!components.contains(this.myListModel.get(i))) continue;
                        selectedIndices.add(i);
                    }
                    this.myList.setSelectedIndices(ArrayUtil.toIntArray(selectedIndices));
                    this.updateBackLabel();
                }
                finally {
                    this.mySelectionUpdating = false;
                }
            };
            this.mySelectionModel.addListener(this.mySelectionModelListener);
            this.myListSelectionListener = e -> {
                if (this.mySelectionUpdating || e.getValueIsAdjusting()) {
                    return;
                }
                try {
                    this.mySelectionUpdating = true;
                    this.mySelectionModel.setSelection(this.myList.getSelectedValuesList());
                    this.myDesignSurface.scrollToCenter(this.myList.getSelectedValuesList());
                }
                finally {
                    this.mySelectionUpdating = false;
                }
            };
            this.myList.addListSelectionListener(this.myListSelectionListener);
            this.myModelListener = new ModelListener(){

                @Override
                public void modelChanged(@NotNull NlModel model) {
                    if (model == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    DestinationList.this.updateComponentList(toolContext);
                }

                @Override
                public void modelActivated(@NotNull NlModel model) {
                    if (model == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    DestinationList.this.updateComponentList(toolContext);
                }

                @Override
                public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
                    if (model == null) {
                        3.$$$reportNull$$$0(2);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "model";
                    objectArray2[1] = "com/android/tools/idea/naveditor/structure/DestinationList$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modelChanged";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modelActivated";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "modelChangedOnLayout";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        DestinationList.this.myDesignSurface.notifyComponentActivate((NlComponent)DestinationList.this.myList.getSelectedValue());
                    }
                }
            };
            this.myList.addMouseListener(this.myMouseListener);
            this.myModel.addListener(this.myModelListener);
            Configuration configuration = toolContext.getConfiguration();
            assert (configuration != null);
            this.myResourceResolver = configuration.getResourceResolver();
            ColorSet colorSet = SceneContext.get(toolContext.getCurrentSceneView()).getColorSet();
            this.myList.setBackground(colorSet.getSubduedBackground());
        }
        this.updateComponentList(toolContext);
    }

    private NavigationSchema getSchema() {
        if (this.mySchema == null) {
            assert (this.myModel != null);
            this.mySchema = NavigationSchema.get(this.myModel.getFacet());
        }
        return this.mySchema;
    }

    private void updateBackLabel() {
        if (this.myModel.getComponents().contains((Object)this.myDesignSurface.getCurrentNavigation())) {
            this.myBackPanel.setVisible(false);
        } else {
            this.myBackPanel.setVisible(true);
            NlComponent parent = this.myDesignSurface.getCurrentNavigation().getParent();
            this.myBackLabel.setText(parent.getParent() == null ? ROOT_NAME : NavComponentHelperKt.getUiName(parent, this.myResourceResolver));
        }
    }

    @NotNull
    private JComponent createBackPanel(@NotNull DesignSurface context) {
        if (context == null) {
            DestinationList.$$$reportNull$$$0(0);
        }
        this.myBackPanel = new JPanel(new BorderLayout());
        this.myBackLabel = new JLabel("", StudioIcons.Common.BACK_ARROW, 2);
        ColorSet colorSet = SceneContext.get(context.getCurrentSceneView()).getColorSet();
        this.myBackPanel.setBackground(colorSet.getSubduedBackground());
        this.myBackPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, colorSet.getFrames()), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.myBackPanel.setVisible(false);
        this.myBackPanel.add((Component)this.myBackLabel, "West");
        this.myBackLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DestinationList.this.goBack();
            }
        });
        JPanel jPanel = this.myBackPanel;
        if (jPanel == null) {
            DestinationList.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    void goBack() {
        this.myDesignSurface.setCurrentNavigation(this.myDesignSurface.getCurrentNavigation().getParent());
        this.updateComponentList(this.myDesignSurface);
        this.updateBackLabel();
    }

    private void updateComponentList(DesignSurface toolContext) {
        ArrayList<NlComponent> newElements = new ArrayList<NlComponent>();
        if (toolContext != null) {
            NlComponent root = this.myDesignSurface.getCurrentNavigation();
            for (NlComponent child : root.getChildren()) {
                if (this.getSchema().getDestinationType(child.getTagName()) == null) continue;
                newElements.add(child);
            }
        }
        if (!newElements.equals(Collections.list(this.myListModel.elements()))) {
            this.myListModel.clear();
            newElements.forEach(this.myListModel::addElement);
        }
    }

    @NotNull
    public JComponent getComponent() {
        DestinationList destinationList = this;
        if (destinationList == null) {
            DestinationList.$$$reportNull$$$0(2);
        }
        return destinationList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/structure/DestinationList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/structure/DestinationList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createBackPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBackPanel";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DestinationListDefinition
    extends ToolWindowDefinition<DesignSurface> {
        public DestinationListDefinition() {
            super("Destinations", AllIcons.Toolwindows.ToolWindowHierarchy, "destinations", Side.LEFT, Split.TOP, AutoHide.DOCKED, () -> new DestinationList());
        }
    }
}

