/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.LerpValue;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneInteraction;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ZoomType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.JViewport;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavDesignSurface
extends DesignSurface {
    private static final int SCROLL_DURATION_MS = 300;
    private NavigationSchema mySchema;
    private NlComponent myCurrentNavigation;
    AtomicReference<Future<?>> myScheduleRef;

    public NavDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NavDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NavDesignSurface.$$$reportNull$$$0(1);
        }
        super(project, parentDisposable);
        this.myScheduleRef = new AtomicReference();
        this.setBackground((Color)JBColor.white);
    }

    @Override
    public void dispose() {
        Future<?> future = this.getScheduleRef().get();
        if (future != null) {
            future.cancel(false);
        }
        this.getScheduleRef().set(null);
        super.dispose();
    }

    @Override
    public float getSceneScalingFactor() {
        return 1.0f;
    }

    @NotNull
    public NavigationSchema getSchema() {
        if (this.mySchema == null) {
            NlModel model = this.getModel();
            assert (model != null);
            this.mySchema = NavigationSchema.get(model.getFacet());
        }
        NavigationSchema navigationSchema = this.mySchema;
        if (navigationSchema == null) {
            NavDesignSurface.$$$reportNull$$$0(2);
        }
        return navigationSchema;
    }

    @Override
    public void forceUserRequestedRefresh() {
    }

    @NotNull
    protected NavActionManager createActionManager() {
        NavActionManager navActionManager = new NavActionManager(this);
        if (navActionManager == null) {
            NavDesignSurface.$$$reportNull$$$0(3);
        }
        return navActionManager;
    }

    @Override
    @NotNull
    protected SceneManager createSceneManager(@NotNull NlModel model) {
        if (model == null) {
            NavDesignSurface.$$$reportNull$$$0(4);
        }
        NavSceneManager navSceneManager = new NavSceneManager(model, this);
        if (navSceneManager == null) {
            NavDesignSurface.$$$reportNull$$$0(5);
        }
        return navSceneManager;
    }

    @Override
    @Nullable
    public NavSceneManager getSceneManager() {
        return (NavSceneManager)super.getSceneManager();
    }

    @Override
    public CompletableFuture<?> goingToSetModel(NlModel model) {
        final AndroidFacet facet = model.getFacet();
        final CompletableFuture result = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        final Project project = model.getProject();
        application.executeOnPooledThread(() -> {
            if (NavDesignSurface.tryToCreateSchema(facet)) {
                result.complete(null);
            } else if (NavDesignSurface.requestAddDependency(facet)) {
                ListenableFuture<ProjectSystemSyncManager.SyncResult> syncResult = ProjectSystemUtil.getSyncManager(project).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, true);
                Futures.addCallback(syncResult, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(@Nullable Object unused) {
                        application.executeOnPooledThread(() -> {
                            if (!NavDesignSurface.tryToCreateSchema(facet)) {
                                NavDesignSurface.showFailToAddMessage(project);
                            }
                            result.complete(null);
                        });
                    }

                    public void onFailure(@Nullable Throwable t) {
                        NavDesignSurface.showFailToAddMessage(project);
                        result.complete(null);
                    }
                });
            } else {
                NavDesignSurface.showFailToAddMessage(project);
                result.complete(null);
            }
        });
        return result;
    }

    private static void showFailToAddMessage(@NotNull Project project) {
        if (project == null) {
            NavDesignSurface.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                NavDesignSurface.$$$reportNull$$$0(25);
            }
            Messages.showErrorDialog((Project)project, (String)"Failed to add navigation library dependency", (String)"Failed to Add Dependency");
        });
    }

    private static boolean requestAddDependency(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavDesignSurface.$$$reportNull$$$0(7);
        }
        AtomicBoolean didAdd = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (facet == null) {
                NavDesignSurface.$$$reportNull$$$0(24);
            }
            didAdd.set(DependencyManagementUtil.addDependencies(facet.getModule(), (List<? extends GoogleMavenArtifactId>)ImmutableList.of((Object)((Object)GoogleMavenArtifactId.NAVIGATION)), true, false, true).isEmpty());
        });
        return didAdd.get();
    }

    private static boolean tryToCreateSchema(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavDesignSurface.$$$reportNull$$$0(8);
        }
        return (Boolean)DumbService.getInstance((Project)facet.getModule().getProject()).runReadActionInSmartMode(() -> {
            if (facet == null) {
                NavDesignSurface.$$$reportNull$$$0(23);
            }
            try {
                NavigationSchema.createIfNecessary(facet);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        });
    }

    @Override
    protected void layoutContent() {
        this.requestRender();
    }

    @NotNull
    public NlComponent getCurrentNavigation() {
        if ((this.myCurrentNavigation == null || this.myCurrentNavigation.getModel() != this.getModel()) && this.getModel() != null) {
            this.myCurrentNavigation = (NlComponent)this.getModel().getComponents().get(0);
        }
        NlComponent nlComponent = this.myCurrentNavigation;
        if (nlComponent == null) {
            NavDesignSurface.$$$reportNull$$$0(9);
        }
        return nlComponent;
    }

    public void setCurrentNavigation(@NotNull NlComponent currentNavigation) {
        if (currentNavigation == null) {
            NavDesignSurface.$$$reportNull$$$0(10);
        }
        this.myCurrentNavigation = currentNavigation;
        this.getSceneManager().update();
        this.getSelectionModel().clear();
        this.getSceneManager().layout(false);
        this.zoomToFit();
        currentNavigation.getModel().notifyModified(NlModel.ChangeType.UPDATE_HIERARCHY);
        this.repaint();
    }

    @Override
    @Nullable
    public Dimension getScrolledAreaSize() {
        return this.getContentSize(null);
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        SceneView view = this.getCurrentSceneView();
        if (view == null) {
            Dimension dim = dimension == null ? new Dimension() : dimension;
            dim.setSize(0, 0);
            Dimension dimension2 = dim;
            if (dimension2 == null) {
                NavDesignSurface.$$$reportNull$$$0(11);
            }
            return dimension2;
        }
        Dimension dimension3 = view.getSize(dimension);
        if (dimension3 == null) {
            NavDesignSurface.$$$reportNull$$$0(12);
        }
        return dimension3;
    }

    @Override
    protected Dimension getDefaultOffset() {
        return new Dimension(0, 0);
    }

    @Override
    @NotNull
    protected Dimension getPreferredContentSize(int availableWidth, int availableHeight) {
        SceneView view = this.getCurrentSceneView();
        if (view == null) {
            Dimension dimension = new Dimension(0, 0);
            if (dimension == null) {
                NavDesignSurface.$$$reportNull$$$0(13);
            }
            return dimension;
        }
        SceneComponent root = view.getScene().getRoot();
        if (root == null) {
            Dimension dimension = new Dimension(0, 0);
            if (dimension == null) {
                NavDesignSurface.$$$reportNull$$$0(14);
            }
            return dimension;
        }
        Rectangle boundingBox = NavSceneManager.getBoundingBox(root);
        Dimension dimension = boundingBox.getSize();
        if (dimension == null) {
            NavDesignSurface.$$$reportNull$$$0(15);
        }
        return dimension;
    }

    @Override
    public boolean isLayoutDisabled() {
        return false;
    }

    @Override
    public int getContentOriginX() {
        return 0;
    }

    @Override
    public int getContentOriginY() {
        return 0;
    }

    @Override
    protected double getMinScale() {
        return 0.1;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2) {
        VirtualFile virtualFile;
        PsiFile file;
        PsiClass psiClass;
        String className;
        String id;
        if (component2 == null) {
            NavDesignSurface.$$$reportNull$$$0(16);
        }
        String tagName = component2.getTagName();
        if (this.getSchema().getDestinationType(tagName) == NavigationSchema.DestinationType.NAVIGATION) {
            if (!tagName.equals("include")) {
                this.setCurrentNavigation(component2);
                return;
            }
            id = component2.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
            if (id == null) {
                return;
            }
        } else {
            id = component2.getAttribute("http://schemas.android.com/tools", "layout");
        }
        if (id != null) {
            VirtualFile virtualFile2;
            File file2;
            String fileName;
            Configuration configuration = this.getConfiguration();
            ResourceResolver resolver = configuration != null ? configuration.getResourceResolver() : null;
            ResourceValue value = resolver != null ? resolver.findResValue(id, false) : null;
            String string = fileName = value != null ? value.getValue() : null;
            if (fileName != null && (file2 = new File(fileName)).exists() && (virtualFile2 = VfsUtil.findFileByIoFile((File)file2, (boolean)false)) != null) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile2, true);
                return;
            }
        }
        if ((className = component2.getAttribute("http://schemas.android.com/apk/res/android", "name")) != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject()))) != null && (file = psiClass.getContainingFile()) != null && (virtualFile = file.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile, true);
            return;
        }
        super.notifyComponentActivate(component2);
    }

    @Override
    @Nullable
    public Interaction doCreateInteractionOnClick(int mouseX, int mouseY, @NotNull SceneView view) {
        if (view == null) {
            NavDesignSurface.$$$reportNull$$$0(17);
        }
        return new SceneInteraction(view);
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(@NotNull SceneComponent draggedSceneComponent, @Nullable SceneComponent primary) {
        if (draggedSceneComponent == null) {
            NavDesignSurface.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Override
    public void zoom(@NotNull ZoomType type, int x, int y) {
        if (type == null) {
            NavDesignSurface.$$$reportNull$$$0(19);
        }
        super.zoom(type, x, y);
        if (type == ZoomType.FIT || type == ZoomType.FIT_INTO) {
            JViewport viewport = this.getScrollPane().getViewport();
            Rectangle bounds = viewport.getViewRect();
            Dimension size = viewport.getViewSize();
            viewport.setViewPosition(new Point((size.width - bounds.width) / 2, (size.height - bounds.height) / 2));
        }
    }

    @NotNull
    public Dimension getExtentSize() {
        Dimension dimension = this.getScrollPane().getViewport().getExtentSize();
        if (dimension == null) {
            NavDesignSurface.$$$reportNull$$$0(20);
        }
        return dimension;
    }

    public void scrollToCenter(@NotNull List<NlComponent> list) {
        if (list == null) {
            NavDesignSurface.$$$reportNull$$$0(21);
        }
        Scene scene = this.getScene();
        SceneView view = this.getCurrentSceneView();
        if (list.isEmpty() || scene == null || view == null) {
            return;
        }
        Rectangle selectionBounds = NavSceneManager.getBoundingBox(list.stream().map(nlComponent -> scene.getSceneComponent((NlComponent)nlComponent)).collect(Collectors.toList()));
        Dimension swingViewportSize = this.getScrollPane().getViewport().getExtentSize();
        int swingStartCenterXInViewport = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX()) - this.getScrollPosition().x;
        int swingStartCenterYInViewport = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY()) - this.getScrollPosition().y;
        LerpValue xLerp = new LerpValue(swingStartCenterXInViewport, swingViewportSize.width / 2, this.getScrollDurationMs());
        LerpValue yLerp = new LerpValue(swingStartCenterYInViewport, swingViewportSize.height / 2, this.getScrollDurationMs());
        LerpValue zoomLerp = new LerpValue((int)(view.getScale() * 100.0), (int)(this.getFitScale(selectionBounds.getSize(), true) * 100.0), this.getScrollDurationMs());
        if (this.getScheduleRef().get() != null) {
            this.getScheduleRef().get().cancel(false);
        }
        Runnable action = () -> UIUtil.invokeAndWaitIfNeeded(() -> {
            long time = System.currentTimeMillis();
            int xSwingValue = xLerp.getValue(time);
            int ySwingValue = yLerp.getValue(time);
            int targetSwingX = Coordinates.getSwingX(view, (int)selectionBounds.getCenterX());
            int targetSwingY = Coordinates.getSwingY(view, (int)selectionBounds.getCenterY());
            this.setScrollPosition(targetSwingX - xSwingValue, targetSwingY - ySwingValue);
            this.setScale((double)zoomLerp.getValue(time) / 100.0, targetSwingX, targetSwingY);
            if (xSwingValue == xLerp.getEnd() && ySwingValue == yLerp.getEnd()) {
                this.getScheduleRef().get().cancel(false);
                this.getScheduleRef().set(null);
            }
        });
        this.getScheduleRef().set(AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(action, 0L, 10L, TimeUnit.MILLISECONDS));
    }

    @NotNull
    AtomicReference<Future<?>> getScheduleRef() {
        AtomicReference<Future<?>> atomicReference = this.myScheduleRef;
        if (atomicReference == null) {
            NavDesignSurface.$$$reportNull$$$0(22);
        }
        return atomicReference;
    }

    int getScrollDurationMs() {
        return 300;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/surface/NavDesignSurface";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: 
            case 8: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentNavigation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "draggedSceneComponent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/surface/NavDesignSurface";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSceneManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNavigation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSize";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtentSize";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getScheduleRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showFailToAddMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "requestAddDependency";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "tryToCreateSchema";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentNavigation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doCreateInteractionOnClick";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createInteractionOnDrag";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCenter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$tryToCreateSchema$3";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$requestAddDependency$2";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showFailToAddMessage$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

