/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator;

import com.android.tools.idea.navigator.AndroidTreeUpdater;
import com.android.tools.idea.navigator.nodes.FolderGroupNode;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectTreeBuilder
extends ProjectTreeBuilder {
    private Map<VirtualFile, AbstractTreeNode> myFileToNodeMap;

    public AndroidProjectTreeBuilder(@NotNull Project project, @NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @NotNull ProjectAbstractTreeStructureBase treeStructure, @Nullable Comparator<NodeDescriptor> comparator) {
        if (project == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(1);
        }
        if (treeModel == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(2);
        }
        if (treeStructure == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(3);
        }
        super(project, tree, treeModel, comparator, treeStructure);
        this.myFileToNodeMap = new HashMap<VirtualFile, AbstractTreeNode>();
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    AndroidProjectTreeBuilder.this.removeMapping(vFileEvent.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/navigator/AndroidProjectTreeBuilder$1", "after"));
            }
        });
    }

    @Nullable
    protected AbstractTreeUpdater createUpdater() {
        if (this.isDisposed()) {
            return null;
        }
        AbstractTreeStructure treeStructure = this.getTreeStructure();
        assert (treeStructure != null);
        return new AndroidTreeUpdater(treeStructure, this);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(4);
        }
        return project;
    }

    @Nullable
    protected Object findNodeByElement(@NotNull Object element) {
        Object parentNode;
        Object node;
        if (element == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(5);
        }
        if ((node = super.findNodeByElement(element)) != null) {
            return node;
        }
        VirtualFile virtualFile = null;
        if (element instanceof PsiDirectory) {
            virtualFile = ((PsiDirectory)element).getVirtualFile();
        } else if (element instanceof PsiFile) {
            virtualFile = ((PsiFile)element).getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        AbstractTreeNode treeNode = this.getNodeForFile(virtualFile);
        if (treeNode == null) {
            return null;
        }
        AbstractTreeNode parent = treeNode.getParent();
        Object object = parentNode = parent == null ? null : this.findNodeByElement(parent);
        if (!(parentNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Enumeration<TreeNode> children = ((DefaultMutableTreeNode)parentNode).children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (!(child.getUserObject() instanceof FolderGroupNode)) continue;
            for (PsiDirectory folder : ((FolderGroupNode)child.getUserObject()).getFolders()) {
                if (!folder.getVirtualFile().equals(virtualFile)) continue;
                return child;
            }
        }
        return null;
    }

    public void createMapping(@NotNull VirtualFile file, @NotNull AbstractTreeNode node) {
        if (file == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(6);
        }
        if (node == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(7);
        }
        this.myFileToNodeMap.put(file, node);
    }

    private void removeMapping(@Nullable VirtualFile file) {
        this.myFileToNodeMap.remove(file);
    }

    @Nullable
    private AbstractTreeNode getNodeForFile(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidProjectTreeBuilder.$$$reportNull$$$0(8);
        }
        return this.myFileToNodeMap.get(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/AndroidProjectTreeBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/AndroidProjectTreeBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findNodeByElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createMapping";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodeForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

