/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidViewProjectNode
extends ProjectViewNode<Project> {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidViewProjectNode(@NotNull Project project, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidViewProjectNode.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            AndroidViewProjectNode.$$$reportNull$$$0(1);
        }
        if (projectViewPane == null) {
            AndroidViewProjectNode.$$$reportNull$$$0(2);
        }
        super(project, (Object)project, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList children;
        assert (this.myProject != null);
        ViewSettings settings = this.getSettings();
        List<Module> modules = Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules());
        ArrayList arrayList = children = new ArrayList(modules.size());
        if (arrayList == null) {
            AndroidViewProjectNode.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        assert (this.myProject != null);
        return String.format("%1$s", this.myProject.getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidViewProjectNode.$$$reportNull$$$0(4);
        }
        presentation.setIcon(PlatformIcons.PROJECT_ICON);
        Project project = this.getProject();
        assert (project != null);
        presentation.setPresentableText(project.getName());
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidViewProjectNode.$$$reportNull$$$0(5);
        }
        assert (this.myProject != null);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        VirtualFile projectRootFolder = this.myProject.getBaseDir();
        return index.isInContent(file) || index.isInLibraryClasses(file) || index.isInLibrarySource(file) || projectRootFolder != null && VfsUtilCore.isAncestor((VirtualFile)projectRootFolder, (VirtualFile)file, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/AndroidViewProjectNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/AndroidViewProjectNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

