/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.LauncherIconGenerator;
import com.android.tools.idea.npw.assetstudio.VectorDrawableTransformer;
import com.android.tools.idea.rendering.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.LayoutPsiPullParser;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.xml.XmlFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DrawableRenderer
implements Disposable {
    @NotNull
    private final ListenableFuture<RenderTask> myRenderTaskFuture;
    @NotNull
    private final Object myRenderLock;
    @NotNull
    private final MyLayoutPullParserFactory myParserFactory;
    @NotNull
    private final AtomicInteger myCounter;

    DrawableRenderer(@NotNull AndroidFacet facet) {
        if (facet == null) {
            DrawableRenderer.$$$reportNull$$$0(0);
        }
        this.myRenderLock = new Object();
        this.myCounter = new AtomicInteger();
        Module module = facet.getModule();
        RenderLogger logger = new RenderLogger(LauncherIconGenerator.class.getSimpleName(), module);
        this.myParserFactory = new MyLayoutPullParserFactory(module.getProject(), logger);
        this.myRenderTaskFuture = FutureUtils.executeOnPooledThread(() -> {
            if (facet == null) {
                DrawableRenderer.$$$reportNull$$$0(6);
            }
            try {
                Configuration configuration = ThemeEditorUtils.getConfigurationForModule(module);
                RenderService service = RenderService.getInstance(facet);
                RenderTask renderTask = service.createTask(null, configuration, logger, null, this.myParserFactory);
                assert (renderTask != null);
                renderTask.getLayoutlibCallback().setLogger(logger);
                if (logger.hasProblems()) {
                    DrawableRenderer.getLog().error(RenderProblem.format(logger.getMessages()));
                }
                return renderTask;
            }
            catch (Error | RuntimeException e) {
                DrawableRenderer.getLog().error(e);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public ListenableFuture<BufferedImage> renderDrawable(@NotNull String xmlDrawableText, @NotNull Dimension size) {
        if (xmlDrawableText == null) {
            DrawableRenderer.$$$reportNull$$$0(1);
        }
        if (size == null) {
            DrawableRenderer.$$$reportNull$$$0(2);
        }
        String xmlText = VectorDrawableTransformer.resizeAndCenter(xmlDrawableText, size, 1.0, null);
        ResourceUrl url = ResourceUrl.create(null, (ResourceType)ResourceType.DRAWABLE, (String)"ic_image_preview");
        String resourceName = String.format("preview_%x.xml", this.myCounter.getAndIncrement());
        ResourceValue value = new ResourceValue(url, resourceName);
        RenderTask renderTask = this.getRenderTask();
        if (renderTask == null) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)AssetStudioUtils.createDummyImage());
            if (listenableFuture != null) return listenableFuture;
            DrawableRenderer.$$$reportNull$$$0(3);
            return listenableFuture;
        }
        Object object = this.myRenderLock;
        // MONITORENTER : object
        this.myParserFactory.addFileContent(new File(resourceName), xmlText);
        renderTask.setOverrideRenderSize(size.width, size.height);
        renderTask.setMaxRenderSize(size.width, size.height);
        ListenableFuture<BufferedImage> listenableFuture = renderTask.renderDrawable(value);
        // MONITOREXIT : object
        if (listenableFuture != null) return listenableFuture;
        DrawableRenderer.$$$reportNull$$$0(4);
        return listenableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        RenderTask renderTask = this.getRenderTask();
        if (renderTask != null) {
            Object object = this.myRenderLock;
            synchronized (object) {
                renderTask.dispose();
            }
        }
    }

    @Nullable
    private RenderTask getRenderTask() {
        try {
            return (RenderTask)this.myRenderTaskFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(DrawableRenderer.class);
        if (logger == null) {
            DrawableRenderer.$$$reportNull$$$0(5);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlDrawableText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/DrawableRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/DrawableRenderer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDrawable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderDrawable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLayoutPullParserFactory
    implements ILayoutPullParserFactory {
        @NotNull
        private final ConcurrentMap<File, String> myFileContent;
        @NotNull
        private final Project myProject;
        @NotNull
        private final RenderLogger myLogger;

        MyLayoutPullParserFactory(@NotNull Project project, @NotNull RenderLogger logger) {
            if (project == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(0);
            }
            if (logger == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(1);
            }
            this.myFileContent = new ConcurrentHashMap<File, String>();
            this.myProject = project;
            this.myLogger = logger;
        }

        @Override
        @Nullable
        public ILayoutPullParser create(@NotNull File file, @NotNull LayoutlibCallback layoutlibCallback) {
            String content;
            if (file == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(2);
            }
            if (layoutlibCallback == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(3);
            }
            if ((content = (String)this.myFileContent.remove(file)) == null) {
                return null;
            }
            XmlFile xmlFile = (XmlFile)MyLayoutPullParserFactory.createEphemeralPsiFile(this.myProject, file.getName(), StdFileTypes.XML, content);
            return LayoutPsiPullParser.create(xmlFile, this.myLogger);
        }

        void addFileContent(@NotNull File file, @NotNull String content) {
            if (file == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(4);
            }
            if (content == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(5);
            }
            this.myFileContent.put(file, content);
        }

        @NotNull
        private static PsiFile createEphemeralPsiFile(@NotNull Project project, @NotNull String filename, @NotNull LanguageFileType fileType, @NotNull String contents) {
            LightVirtualFile virtualFile;
            PsiManager psiManager;
            SingleRootFileViewProvider viewProvider;
            PsiFile psiFile;
            if (project == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(6);
            }
            if (filename == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(7);
            }
            if (fileType == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(8);
            }
            if (contents == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(9);
            }
            if ((psiFile = (viewProvider = new SingleRootFileViewProvider(psiManager = PsiManager.getInstance((Project)project), (VirtualFile)(virtualFile = new LightVirtualFile(filename, (FileType)fileType, (CharSequence)contents)))).getPsi(fileType.getLanguage())) == null) {
                throw new IllegalArgumentException("Unsupported language: " + fileType.getLanguage().getDisplayName());
            }
            PsiFile psiFile2 = psiFile;
            if (psiFile2 == null) {
                MyLayoutPullParserFactory.$$$reportNull$$$0(10);
            }
            return psiFile2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logger";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layoutlibCallback";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filename";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contents";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/DrawableRenderer$MyLayoutPullParserFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/DrawableRenderer$MyLayoutPullParserFactory";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEphemeralPsiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addFileContent";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createEphemeralPsiFile";
                    break;
                }
                case 10: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

