/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedImageIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.icon.CategoryIconMap;
import com.android.tools.idea.npw.assetstudio.icon.IconGeneratorResult;
import com.android.tools.idea.observable.core.OptionalProperty;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.AndroidModuleTemplate;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IconGenerator
implements Disposable {
    private static final Map<Density, Pattern> DENSITY_PATTERNS;
    protected static final BufferedImage PLACEHOLDER_IMAGE;
    private final OptionalProperty<BaseAsset> mySourceAsset;
    private final StringProperty myOutputName;
    protected final int myMinSdkVersion;
    @NotNull
    private final GraphicGeneratorContext myContext;

    public IconGenerator(int minSdkVersion) {
        this(minSdkVersion, new GraphicGeneratorContext(40));
    }

    public IconGenerator(int minSdkVersion, @NotNull GraphicGeneratorContext context) {
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(0);
        }
        this.mySourceAsset = new OptionalValueProperty<BaseAsset>();
        this.myOutputName = new StringValueProperty();
        this.myMinSdkVersion = minSdkVersion;
        this.myContext = context;
        Disposer.register((Disposable)this, (Disposable)context);
    }

    public void dispose() {
    }

    @NotNull
    public GraphicGeneratorContext getGraphicGeneratorContext() {
        GraphicGeneratorContext graphicGeneratorContext = this.myContext;
        if (graphicGeneratorContext == null) {
            IconGenerator.$$$reportNull$$$0(1);
        }
        return graphicGeneratorContext;
    }

    @NotNull
    public final OptionalProperty<BaseAsset> sourceAsset() {
        OptionalProperty<BaseAsset> optionalProperty = this.mySourceAsset;
        if (optionalProperty == null) {
            IconGenerator.$$$reportNull$$$0(2);
        }
        return optionalProperty;
    }

    @NotNull
    public final StringProperty outputName() {
        StringProperty stringProperty = this.myOutputName;
        if (stringProperty == null) {
            IconGenerator.$$$reportNull$$$0(3);
        }
        return stringProperty;
    }

    @NotNull
    public IconGeneratorResult generateIcons(Options options) {
        IconGeneratorResult iconGeneratorResult = new IconGeneratorResult(this.generateIcons(this.myContext, options, (String)this.myOutputName.get()), options);
        if (iconGeneratorResult == null) {
            IconGenerator.$$$reportNull$$$0(4);
        }
        return iconGeneratorResult;
    }

    @NotNull
    private CategoryIconMap generateIntoMemory() {
        if (!((Optional)this.mySourceAsset.get()).isPresent()) {
            throw new IllegalStateException("Can't generate icons without a source asset set first");
        }
        Options options = this.createOptions(false);
        CategoryIconMap categoryIconMap = this.generateIntoMemory(options);
        if (categoryIconMap == null) {
            IconGenerator.$$$reportNull$$$0(5);
        }
        return categoryIconMap;
    }

    @NotNull
    private CategoryIconMap generateIntoMemory(Options options) {
        HashMap<String, Map<String, BufferedImage>> categoryMap = new HashMap<String, Map<String, BufferedImage>>();
        this.generate(null, categoryMap, this.myContext, options, (String)this.myOutputName.get());
        CategoryIconMap categoryIconMap = new CategoryIconMap(categoryMap);
        if (categoryIconMap == null) {
            IconGenerator.$$$reportNull$$$0(6);
        }
        return categoryIconMap;
    }

    @NotNull
    public final Map<File, BufferedImage> generateIntoFileMap(@NotNull AndroidModuleTemplate paths) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(7);
        }
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        File resDirectory = paths.getResDirectory();
        if (resDirectory == null || resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        CategoryIconMap categoryIconMap = this.generateIntoMemory();
        Map<File, BufferedImage> map = categoryIconMap.toFileMap(resDirectory.getParentFile());
        if (map == null) {
            IconGenerator.$$$reportNull$$$0(8);
        }
        return map;
    }

    @NotNull
    public Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidModuleTemplate paths) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(9);
        }
        Options options = this.createOptions(false);
        Map<File, GeneratedIcon> map = this.generateIntoIconMap(paths, options);
        if (map == null) {
            IconGenerator.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    public final Map<File, GeneratedIcon> generateIconPlaceholders(@NotNull AndroidModuleTemplate paths) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(11);
        }
        Options options = this.createOptions(false);
        options.usePlaceholders = true;
        Map<File, GeneratedIcon> map = this.generateIntoIconMap(paths, options);
        if (map == null) {
            IconGenerator.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    private Map<File, GeneratedIcon> generateIntoIconMap(@NotNull AndroidModuleTemplate paths, Options options) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(13);
        }
        if (((String)this.myOutputName.get()).isEmpty()) {
            throw new IllegalStateException("Can't save icons to disk if a filename isn't set first");
        }
        File resDirectory = paths.getResDirectory();
        if (resDirectory == null || resDirectory.getParentFile() == null) {
            throw new IllegalArgumentException("Invalid paths used when trying to generate an icon");
        }
        IconGeneratorResult icons = this.generateIcons(options);
        HashMap<File, GeneratedIcon> outputMap = new HashMap<File, GeneratedIcon>();
        icons.getIcons().forEach(icon -> {
            if (icon.getOutputPath() != null && icon.getCategory() != IconCategory.PREVIEW) {
                File path = new File(resDirectory.getParentFile(), icon.getOutputPath().toString());
                outputMap.put(path, (GeneratedIcon)icon);
            }
        });
        HashMap<File, GeneratedIcon> hashMap = outputMap;
        if (hashMap == null) {
            IconGenerator.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    public void generateIconsToDisk(@NotNull AndroidModuleTemplate paths) {
        if (paths == null) {
            IconGenerator.$$$reportNull$$$0(15);
        }
        Map<File, GeneratedIcon> pathIconMap = this.generateIntoIconMap(paths);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (Map.Entry fileImageEntry : pathIconMap.entrySet()) {
                File file = (File)fileImageEntry.getKey();
                GeneratedIcon icon = (GeneratedIcon)fileImageEntry.getValue();
                if (icon instanceof GeneratedImageIcon) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"png")) {
                        this.writePngToDisk(file, ((GeneratedImageIcon)icon).getImage());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                if (icon instanceof GeneratedXmlResource) {
                    if (FileUtilRt.extensionEquals((String)file.getName(), (String)"xml")) {
                        this.writeTextToDisk(file, ((GeneratedXmlResource)icon).getXmlText());
                        continue;
                    }
                    IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
                    continue;
                }
                IconGenerator.getLog().error("Please report this error. Unable to create icon for invalid file: " + file.getAbsolutePath());
            }
        });
    }

    private void writePngToDisk(@NotNull File file, @NotNull BufferedImage image) {
        if (file == null) {
            IconGenerator.$$$reportNull$$$0(16);
        }
        if (image == null) {
            IconGenerator.$$$reportNull$$$0(17);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                ImageIO.write((RenderedImage)image, "PNG", outputStream);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    private void writeTextToDisk(@NotNull File file, @NotNull String text) {
        if (file == null) {
            IconGenerator.$$$reportNull$$$0(18);
        }
        if (text == null) {
            IconGenerator.$$$reportNull$$$0(19);
        }
        try {
            VirtualFile directory = VfsUtil.createDirectories((String)file.getParentFile().getAbsolutePath());
            VirtualFile virtualFile = directory.findChild(file.getName());
            if (virtualFile == null || !virtualFile.exists()) {
                virtualFile = directory.createChildData((Object)this, file.getName());
            }
            try (OutputStream outputStream = virtualFile.getOutputStream((Object)this);){
                byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
                outputStream.write(bytes);
            }
        }
        catch (IOException e) {
            IconGenerator.getLog().error((Throwable)e);
        }
    }

    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(20);
        }
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(21);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(22);
        }
        HashMap<String, Map<String, BufferedImage>> categoryMap = new HashMap<String, Map<String, BufferedImage>>();
        this.generate(null, categoryMap, context, options, name);
        ArrayList<GeneratedIcon> icons = new ArrayList<GeneratedIcon>();
        categoryMap.forEach((category, images) -> images.forEach((path, image) -> {
            Density density = IconGenerator.pathToDensity(path);
            if (density == null) {
                density = Density.NODPI;
            }
            GeneratedImageIcon icon = new GeneratedImageIcon((String)path, Paths.get(path, new String[0]), IconCategory.fromName(category), density, (BufferedImage)image);
            icons.add(icon);
        }));
        ArrayList<GeneratedIcon> arrayList = icons;
        if (arrayList == null) {
            IconGenerator.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    public abstract BufferedImage generate(@NotNull GraphicGeneratorContext var1, @NotNull Options var2);

    @NotNull
    public abstract Options createOptions(boolean var1);

    @NotNull
    protected String getIconPath(@NotNull Options options, @NotNull String iconName) {
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(24);
        }
        if (iconName == null) {
            IconGenerator.$$$reportNull$$$0(25);
        }
        String string = this.getIconFolder(options) + '/' + IconGenerator.getIconFileName(options, iconName);
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static String getIconFileName(@NotNull Options options, @NotNull String iconName) {
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(27);
        }
        if (iconName == null) {
            IconGenerator.$$$reportNull$$$0(28);
        }
        if (options.density == Density.ANYDPI) {
            String string = iconName + ".xml";
            if (string == null) {
                IconGenerator.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = iconName + ".png";
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    protected String getIconFolder(@NotNull Options options) {
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(31);
        }
        switch (options.iconFolderKind) {
            case DRAWABLE: {
                String string = IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, options.density, options.apiVersion);
                if (string == null) {
                    IconGenerator.$$$reportNull$$$0(32);
                }
                return string;
            }
            case MIPMAP: {
                String string = IconGenerator.getIconFolder(ResourceFolderType.MIPMAP, options.density, options.apiVersion);
                if (string == null) {
                    IconGenerator.$$$reportNull$$$0(33);
                }
                return string;
            }
            case DRAWABLE_NO_DPI: {
                String string = IconGenerator.getIconFolder(ResourceFolderType.DRAWABLE, Density.NODPI, options.apiVersion);
                if (string == null) {
                    IconGenerator.$$$reportNull$$$0(34);
                }
                return string;
            }
            case VALUES: {
                String string = IconGenerator.getIconFolder(ResourceFolderType.VALUES, Density.NODPI, options.apiVersion);
                if (string == null) {
                    IconGenerator.$$$reportNull$$$0(35);
                }
                return string;
            }
        }
        throw new IllegalArgumentException("Unexpected folder kind: " + (Object)((Object)options.iconFolderKind));
    }

    @NotNull
    private static String getIconFolder(@NotNull ResourceFolderType folderType, @NotNull Density density, int apiVersion) {
        if (folderType == null) {
            IconGenerator.$$$reportNull$$$0(36);
        }
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(37);
        }
        StringBuilder buf = new StringBuilder(50);
        buf.append("res");
        buf.append('/');
        buf.append(folderType.getName());
        if (density != Density.NODPI) {
            buf.append('-');
            buf.append(density.getResourceValue());
        }
        if (apiVersion > 1) {
            buf.append("-v");
            buf.append(apiVersion);
        }
        String string = buf.toString();
        if (string == null) {
            IconGenerator.$$$reportNull$$$0(38);
        }
        return string;
    }

    public void generate(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        if (categoryMap == null) {
            IconGenerator.$$$reportNull$$$0(39);
        }
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(40);
        }
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(41);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(42);
        }
        if (options.density == Density.ANYDPI) {
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
            return;
        }
        Density[] densityValues = Density.values();
        Arrays.sort(densityValues, Comparator.comparingInt(Density::getDpiValue));
        for (Density density : densityValues) {
            if (!density.isValidValueForDevice() || !this.includeDensity(density)) continue;
            options.density = density;
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
        }
    }

    private void generateImageAndUpdateMap(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull Options options, @NotNull String name) {
        if (categoryMap == null) {
            IconGenerator.$$$reportNull$$$0(43);
        }
        if (context == null) {
            IconGenerator.$$$reportNull$$$0(44);
        }
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(45);
        }
        if (name == null) {
            IconGenerator.$$$reportNull$$$0(46);
        }
        BufferedImage image = this.generate(context, options);
        String mapCategory = category;
        if (mapCategory == null) {
            mapCategory = options.density.getResourceValue();
        }
        Map imageMap = categoryMap.computeIfAbsent(mapCategory, k -> new LinkedHashMap());
        imageMap.put(this.getIconPath(options, name), image);
    }

    protected boolean includeDensity(@NotNull Density density) {
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(47);
        }
        return density.isRecommended() && density != Density.LOW && density != Density.XXXHIGH;
    }

    public static float getMdpiScaleFactor(@NotNull Density density) {
        if (density == null) {
            IconGenerator.$$$reportNull$$$0(48);
        }
        if (density == Density.ANYDPI) {
            density = Density.XXXHIGH;
        }
        if (density == Density.NODPI) {
            density = Density.MEDIUM;
        }
        return (float)density.getDpiValue() / (float)Density.MEDIUM.getDpiValue();
    }

    @Nullable
    public static Density pathToDensity(@NotNull String iconPath) {
        if (iconPath == null) {
            IconGenerator.$$$reportNull$$$0(49);
        }
        iconPath = FileUtils.toSystemIndependentPath((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    @Nullable
    public static BufferedImage getTrimmedAndPaddedImage(@NotNull Options options) {
        if (options == null) {
            IconGenerator.$$$reportNull$$$0(50);
        }
        if (options.sourceImageFuture == null) {
            return null;
        }
        try {
            BufferedImage image = (BufferedImage)options.sourceImageFuture.get();
            if (image != null) {
                if (options.isTrimmed) {
                    image = AssetStudioUtils.trim(image);
                }
                if (options.paddingPercent != 0) {
                    image = AssetStudioUtils.pad(image, options.paddingPercent);
                }
            }
            return image;
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(IconGenerator.class);
        if (logger == null) {
            IconGenerator.$$$reportNull$$$0(51);
        }
        return logger;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder.build();
        PLACEHOLDER_IMAGE = AssetStudioUtils.createDummyImage();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/IconGenerator";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: 
            case 24: 
            case 27: 
            case 31: 
            case 41: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 22: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 37: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "density";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/IconGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphicGeneratorContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sourceAsset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "outputName";
                break;
            }
            case 4: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoMemory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoFileMap";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIntoIconMap";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIconPlaceholders";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconPath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFileName";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFolder";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 51: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoFileMap";
                break;
            }
            case 9: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateIntoIconMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generateIconPlaceholders";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateIconsToDisk";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writePngToDisk";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writeTextToDisk";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateIcons";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIconPath";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getIconFileName";
                break;
            }
            case 31: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getIconFolder";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "generateImageAndUpdateMap";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "includeDensity";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getMdpiScaleFactor";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "pathToDensity";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedAndPaddedImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 23: 
            case 26: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Style {
        SIMPLE("fore1");

        public final String id;

        private Style(String id) {
            this.id = id;
        }
    }

    public static enum Shape {
        NONE("none"),
        CIRCLE("circle"),
        SQUARE("square"),
        VRECT("vrect"),
        HRECT("hrect"),
        SQUARE_DOG("square_dogear"),
        VRECT_DOG("vrect_dogear"),
        HRECT_DOG("hrect_dogear");

        public final String id;

        private Shape(String id) {
            this.id = id;
        }
    }

    public static enum IconFolderKind {
        DRAWABLE,
        DRAWABLE_NO_DPI,
        MIPMAP,
        VALUES;

    }

    public static class Options {
        public boolean usePlaceholders;
        @Nullable
        public ListenableFuture<BufferedImage> sourceImageFuture;
        public boolean isTrimmed;
        public int paddingPercent;
        @NotNull
        public IconFolderKind iconFolderKind = IconFolderKind.DRAWABLE;
        @NotNull
        public Density density = Density.XHIGH;
        public int apiVersion;
    }
}

