/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.ide.common.util.AssetUtil;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationIconGenerator
extends IconGenerator {
    public NotificationIconGenerator(int minSdkVersion) {
        super(minSdkVersion);
    }

    @Override
    @NotNull
    public NotificationOptions createOptions(boolean forPreview) {
        NotificationOptions options = new NotificationOptions();
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            options.sourceImageFuture = asset.toImage();
            options.isTrimmed = (Boolean)asset.trimmed().get();
            options.paddingPercent = (Integer)asset.paddingPercent().get();
        }
        NotificationOptions notificationOptions = options;
        if (notificationOptions == null) {
            NotificationIconGenerator.$$$reportNull$$$0(0);
        }
        return notificationOptions;
    }

    @Override
    @NotNull
    public BufferedImage generate(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        Rectangle targetRectMdpi;
        Rectangle iconSizeMdpi;
        if (context == null) {
            NotificationIconGenerator.$$$reportNull$$$0(1);
        }
        if (options == null) {
            NotificationIconGenerator.$$$reportNull$$$0(2);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                NotificationIconGenerator.$$$reportNull$$$0(3);
            }
            return bufferedImage;
        }
        BufferedImage sourceImage = NotificationIconGenerator.getTrimmedAndPaddedImage(options);
        if (sourceImage == null) {
            sourceImage = AssetStudioUtils.createDummyImage();
        }
        NotificationOptions notificationOptions = (NotificationOptions)options;
        if (notificationOptions.version == Version.OLDER) {
            iconSizeMdpi = new Rectangle(0, 0, 25, 25);
            targetRectMdpi = new Rectangle(4, 4, 17, 17);
        } else if (notificationOptions.version == Version.V11) {
            iconSizeMdpi = new Rectangle(0, 0, 24, 24);
            targetRectMdpi = new Rectangle(1, 1, 22, 22);
        } else {
            assert (notificationOptions.version == Version.V9);
            iconSizeMdpi = new Rectangle(0, 0, 16, 25);
            targetRectMdpi = new Rectangle(0, 5, 16, 16);
        }
        float scaleFactor = NotificationIconGenerator.getMdpiScaleFactor(options.density);
        Rectangle imageRect = AssetStudioUtils.scaleRectangle(iconSizeMdpi, scaleFactor);
        Rectangle targetRect = AssetStudioUtils.scaleRectangle(targetRectMdpi, scaleFactor);
        BufferedImage outImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g = (Graphics2D)outImage.getGraphics();
        BufferedImage tempImage = AssetUtil.newArgbBufferedImage((int)imageRect.width, (int)imageRect.height);
        Graphics2D g2 = (Graphics2D)tempImage.getGraphics();
        if (notificationOptions.version == Version.OLDER) {
            BufferedImage backImage = context.loadImageResource("/images/notification_stencil/" + notificationOptions.density.getResourceValue() + ".png");
            g.drawImage((Image)backImage, 0, 0, null);
            BufferedImage filled = AssetUtil.filledImage((BufferedImage)sourceImage, (Paint)Color.WHITE);
            AssetUtil.drawCenterInside((Graphics2D)g, (BufferedImage)filled, (Rectangle)targetRect);
        } else if (notificationOptions.version == Version.V11) {
            AssetUtil.drawCenterInside((Graphics2D)g2, (BufferedImage)sourceImage, (Rectangle)targetRect);
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)Color.WHITE)});
        } else {
            assert (notificationOptions.version == Version.V9);
            AssetUtil.drawCenterInside((Graphics2D)g2, (BufferedImage)sourceImage, (Rectangle)targetRect);
            AssetUtil.drawEffects((Graphics2D)g, (BufferedImage)tempImage, (int)0, (int)0, (AssetUtil.Effect[])new AssetUtil.Effect[]{new AssetUtil.FillEffect((Paint)new GradientPaint(0.0f, 0.0f, new Color(0x919191), 0.0f, imageRect.height, new Color(0x828282))), new AssetUtil.ShadowEffect(0.0, 1.0, 0.0, Color.WHITE, 0.1, true)});
        }
        g.dispose();
        g2.dispose();
        BufferedImage bufferedImage = outImage;
        if (bufferedImage == null) {
            NotificationIconGenerator.$$$reportNull$$$0(4);
        }
        return bufferedImage;
    }

    @Override
    public void generate(@Nullable String category, @NotNull Map<String, Map<String, BufferedImage>> categoryMap, @NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options baseOptions, @NotNull String name) {
        if (categoryMap == null) {
            NotificationIconGenerator.$$$reportNull$$$0(5);
        }
        if (context == null) {
            NotificationIconGenerator.$$$reportNull$$$0(6);
        }
        if (baseOptions == null) {
            NotificationIconGenerator.$$$reportNull$$$0(7);
        }
        if (name == null) {
            NotificationIconGenerator.$$$reportNull$$$0(8);
        }
        NotificationOptions options = (NotificationOptions)baseOptions;
        if (this.myMinSdkVersion < 9) {
            options.version = Version.OLDER;
            super.generate(options.version.getDisplayName(), categoryMap, context, options, name);
        }
        if (this.myMinSdkVersion < 11) {
            options.version = Version.V9;
            super.generate(options.version.getDisplayName(), categoryMap, context, options, name);
        }
        options.version = Version.V11;
        super.generate(this.myMinSdkVersion < 11 ? options.version.getDisplayName() : null, categoryMap, context, options, name);
    }

    @Override
    @NotNull
    protected String getIconFolder(@NotNull IconGenerator.Options options) {
        if (options == null) {
            NotificationIconGenerator.$$$reportNull$$$0(9);
        }
        String folder = super.getIconFolder(options);
        Version version = ((NotificationOptions)options).version;
        if (version == Version.V11 && this.myMinSdkVersion < 11) {
            String string = folder + "-v11";
            if (string == null) {
                NotificationIconGenerator.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (version == Version.V9 && this.myMinSdkVersion < 9) {
            String string = folder + "-v9";
            if (string == null) {
                NotificationIconGenerator.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = folder;
        if (string == null) {
            NotificationIconGenerator.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/NotificationIconGenerator";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseOptions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/NotificationIconGenerator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIconFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Version {
        V9("V9"),
        V11("V11"),
        OLDER("Other");

        private final String mDisplayName;

        private Version(String displayName) {
            this.mDisplayName = displayName;
        }

        @NotNull
        public String getDisplayName() {
            String string = this.mDisplayName;
            if (string == null) {
                Version.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/NotificationIconGenerator$Version", "getDisplayName"));
        }
    }

    public static class NotificationOptions
    extends IconGenerator.Options {
        public Version version = Version.V9;
    }
}

