/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio;

import com.android.resources.Density;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.GeneratedIcon;
import com.android.tools.idea.npw.assetstudio.GeneratedXmlResource;
import com.android.tools.idea.npw.assetstudio.GraphicGeneratorContext;
import com.android.tools.idea.npw.assetstudio.IconCategory;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.VectorAsset;
import java.awt.image.BufferedImage;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VectorIconGenerator
extends IconGenerator {
    public VectorIconGenerator(int minSdkVersion) {
        super(minSdkVersion);
    }

    @Override
    @NotNull
    public VectorIconOptions createOptions(boolean forPreview) {
        VectorIconOptions options = new VectorIconOptions();
        BaseAsset asset = this.sourceAsset().getValueOrNull();
        if (asset != null) {
            options.sourceImageFuture = asset.toImage();
            options.isTrimmed = (Boolean)asset.trimmed().get();
            options.paddingPercent = (Integer)asset.paddingPercent().get();
        }
        options.density = Density.ANYDPI;
        VectorIconOptions vectorIconOptions = options;
        if (vectorIconOptions == null) {
            VectorIconGenerator.$$$reportNull$$$0(0);
        }
        return vectorIconOptions;
    }

    @Override
    @NotNull
    public BufferedImage generate(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options) {
        if (context == null) {
            VectorIconGenerator.$$$reportNull$$$0(1);
        }
        if (options == null) {
            VectorIconGenerator.$$$reportNull$$$0(2);
        }
        if (options.usePlaceholders) {
            BufferedImage bufferedImage = PLACEHOLDER_IMAGE;
            if (bufferedImage == null) {
                VectorIconGenerator.$$$reportNull$$$0(3);
            }
            return bufferedImage;
        }
        BufferedImage image = VectorIconGenerator.getTrimmedAndPaddedImage(options);
        if (image == null) {
            image = AssetStudioUtils.createDummyImage();
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            VectorIconGenerator.$$$reportNull$$$0(4);
        }
        return bufferedImage;
    }

    @Override
    @NotNull
    public Collection<GeneratedIcon> generateIcons(@NotNull GraphicGeneratorContext context, @NotNull IconGenerator.Options options, @NotNull String name) {
        VectorAsset vectorAsset;
        VectorAsset.ParseResult result;
        if (context == null) {
            VectorIconGenerator.$$$reportNull$$$0(5);
        }
        if (options == null) {
            VectorIconGenerator.$$$reportNull$$$0(6);
        }
        if (name == null) {
            VectorIconGenerator.$$$reportNull$$$0(7);
        }
        if (!(result = (vectorAsset = (VectorAsset)this.sourceAsset().getValue()).parse()).isValid()) {
            Set<GeneratedIcon> set = Collections.emptySet();
            if (set == null) {
                VectorIconGenerator.$$$reportNull$$$0(8);
            }
            return set;
        }
        String xmlContent = result.getXmlContent();
        GeneratedXmlResource icon = new GeneratedXmlResource(name, Paths.get(this.getIconPath(options, name), new String[0]), IconCategory.XML_RESOURCE, xmlContent);
        Set<GeneratedIcon> set = Collections.singleton(icon);
        if (set == null) {
            VectorIconGenerator.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/VectorIconGenerator";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptions";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/VectorIconGenerator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateIcons";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateIcons";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VectorIconOptions
    extends IconGenerator.Options {
        public VectorIconOptions() {
            this.iconFolderKind = IconGenerator.IconFolderKind.DRAWABLE_NO_DPI;
        }
    }
}

