/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.idea.concurrent.FutureUtils;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObjectValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.OptionalValueProperty;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.GuardedBy;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageAsset
extends BaseAsset {
    @NotNull
    private final OptionalValueProperty<File> myImagePath;
    @NotNull
    private final ObservableBool myIsResizable;
    @NotNull
    private final BoolValueProperty myXmlDrawableIsResizable = new BoolValueProperty();
    @NotNull
    private final ObjectValueProperty<Validator.Result> myValidityState = new ObjectValueProperty<Validator.Result>(Validator.Result.OK);
    @NotNull
    private String myRole = "an image file";
    @NotNull
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    @Nullable
    private File myImageFile;
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<String> myXmlDrawableFuture;
    @GuardedBy(value="myLock")
    @Nullable
    private ListenableFuture<BufferedImage> myImageFuture;

    public ImageAsset() {
        this.myImagePath = new OptionalValueProperty();
        this.myImagePath.addListener(v -> {
            this.myXmlDrawableIsResizable.set(false);
            Object object = this.myLock;
            synchronized (object) {
                this.myImageFile = (File)this.myImagePath.getValueOrNull();
                this.myXmlDrawableFuture = null;
                this.myImageFuture = null;
            }
        });
        this.myIsResizable = new BooleanExpression(new ObservableValue[]{this.myImagePath, this.myXmlDrawableIsResizable}){

            @Override
            @NotNull
            public Boolean get() {
                FileType fileType = ImageAsset.getFileType((File)ImageAsset.this.myImagePath.getValueOrNull());
                if (fileType == null) {
                    Boolean bl = false;
                    if (bl == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return bl;
                }
                if (fileType == FileType.RASTER_IMAGE_CANDIDATE) {
                    Boolean bl = true;
                    if (bl == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return bl;
                }
                ImageAsset.this.getXmlDrawable();
                Boolean bl = ImageAsset.this.myXmlDrawableIsResizable.get();
                if (bl == null) {
                    1.$$$reportNull$$$0(2);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/assetstudio/assets/ImageAsset$1", "get"));
            }
        };
    }

    public void setRole(@NotNull String role) {
        if (role == null) {
            ImageAsset.$$$reportNull$$$0(0);
        }
        this.myRole = role;
    }

    @NotNull
    public OptionalValueProperty<File> imagePath() {
        OptionalValueProperty<File> optionalValueProperty = this.myImagePath;
        if (optionalValueProperty == null) {
            ImageAsset.$$$reportNull$$$0(1);
        }
        return optionalValueProperty;
    }

    @Override
    @NotNull
    public ObservableBool isResizable() {
        ObservableBool observableBool = this.myIsResizable;
        if (observableBool == null) {
            ImageAsset.$$$reportNull$$$0(2);
        }
        return observableBool;
    }

    @NotNull
    public ObjectValueProperty<Validator.Result> getValidityState() {
        ObjectValueProperty<Validator.Result> objectValueProperty = this.myValidityState;
        if (objectValueProperty == null) {
            ImageAsset.$$$reportNull$$$0(3);
        }
        return objectValueProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myImageFuture == null) {
                File file = this.myImageFile;
                if (file == null || ImageAsset.isVectorGraphics(FileType.fromFile(file))) {
                    return null;
                }
                this.myImageFuture = FutureUtils.executeOnPooledThread(() -> this.loadImage(file));
            }
            return this.myImageFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ListenableFuture<String> getXmlDrawable() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myXmlDrawableFuture == null) {
                if (this.myImageFile == null) {
                    return null;
                }
                FileType fileType = FileType.fromFile(this.myImageFile);
                if (!ImageAsset.isVectorGraphics(fileType)) {
                    return null;
                }
                File file = this.myImageFile;
                this.myXmlDrawableFuture = FutureUtils.executeOnPooledThread(() -> this.loadXmlDrawable(file));
            }
            return this.myXmlDrawableFuture;
        }
    }

    @Nullable
    private String loadXmlDrawable(@NotNull File file) {
        if (file == null) {
            ImageAsset.$$$reportNull$$$0(4);
        }
        String xmlText = null;
        Validator.Result validityState = this.checkFileExistence(file);
        if (validityState.getSeverity() == Validator.Severity.OK) {
            FileType fileType = FileType.fromFile(file);
            try {
                switch (fileType) {
                    case XML_DRAWABLE: {
                        xmlText = Files.toString((File)file, (Charset)StandardCharsets.UTF_8);
                        break;
                    }
                    case SVG: {
                        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        String message = Svg2Vector.parseSvgToXml((File)file, (OutputStream)outStream);
                        xmlText = outStream.toString(StandardCharsets.UTF_8.name());
                        if (xmlText.isEmpty()) {
                            xmlText = null;
                        }
                        if (message.isEmpty()) break;
                        validityState = new Validator.Result(xmlText == null ? Validator.Severity.ERROR : Validator.Severity.WARNING, message);
                        break;
                    }
                    case LAYERED_IMAGE: {
                        xmlText = new LayeredImageConverter().toVectorDrawableXml(file);
                        break;
                    }
                }
            }
            catch (IOException e) {
                validityState = Validator.Result.fromThrowable((Throwable)e);
            }
        }
        if (xmlText == null && validityState.getSeverity() == Validator.Severity.OK) {
            validityState = Validator.Result.fromNullableMessage((String)"The specified asset could not be parsed. Please choose another asset.");
        }
        boolean resizable = xmlText != null && "vector".equals(XmlUtils.getRootTagName(xmlText));
        this.updateValidityStateAndResizability(file, validityState, resizable);
        return xmlText;
    }

    @Nullable
    private BufferedImage loadImage(@NotNull File file) {
        FileType fileType;
        if (file == null) {
            ImageAsset.$$$reportNull$$$0(5);
        }
        BufferedImage image = null;
        Validator.Result validityState = this.checkFileExistence(file);
        if (validityState.getSeverity() == Validator.Severity.OK && (fileType = FileType.fromFile(file)) == FileType.RASTER_IMAGE_CANDIDATE) {
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                validityState = Validator.Result.fromThrowable((Throwable)e);
            }
        }
        this.updateValidityStateAndResizability(file, validityState, image != null);
        return image;
    }

    @NotNull
    private Validator.Result checkFileExistence(@NotNull File file) {
        if (file == null) {
            ImageAsset.$$$reportNull$$$0(6);
        }
        if (!file.exists()) {
            Validator.Result result = Validator.Result.fromNullableMessage((String)("File " + file.getName() + " does not exist"));
            if (result == null) {
                ImageAsset.$$$reportNull$$$0(7);
            }
            return result;
        }
        if (file.isDirectory()) {
            Validator.Result result = new Validator.Result(Validator.Severity.WARNING, "Please select " + this.myRole);
            if (result == null) {
                ImageAsset.$$$reportNull$$$0(8);
            }
            return result;
        }
        Validator.Result result = Validator.Result.OK;
        if (result == null) {
            ImageAsset.$$$reportNull$$$0(9);
        }
        return result;
    }

    private void updateValidityStateAndResizability(@NotNull File file, @NotNull Validator.Result validityState, boolean resizable) {
        if (file == null) {
            ImageAsset.$$$reportNull$$$0(10);
        }
        if (validityState == null) {
            ImageAsset.$$$reportNull$$$0(11);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (file == null) {
                ImageAsset.$$$reportNull$$$0(12);
            }
            if (validityState == null) {
                ImageAsset.$$$reportNull$$$0(13);
            }
            if (FileUtil.filesEqual((File)file, (File)((File)this.myImagePath.getValueOrNull()))) {
                this.myValidityState.set(validityState);
                this.myXmlDrawableIsResizable.set(resizable);
            }
        });
    }

    private static boolean isVectorGraphics(@Nullable FileType fileType) {
        return fileType == FileType.XML_DRAWABLE || fileType == FileType.SVG || fileType == FileType.LAYERED_IMAGE;
    }

    @Nullable
    private static FileType getFileType(@Nullable File file) {
        return file == null ? null : FileType.fromFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "role";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/ImageAsset";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/ImageAsset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "imagePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "isResizable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidityState";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFileExistence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRole";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadXmlDrawable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadImage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFileExistence";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateValidityStateAndResizability";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateValidityStateAndResizability$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum FileType {
        XML_DRAWABLE,
        SVG,
        LAYERED_IMAGE,
        RASTER_IMAGE_CANDIDATE;


        @NotNull
        static FileType fromFile(@NotNull File file) {
            String path;
            if (file == null) {
                FileType.$$$reportNull$$$0(0);
            }
            if (SdkUtils.endsWithIgnoreCase((String)(path = file.getPath()), (String)".xml")) {
                FileType fileType = XML_DRAWABLE;
                if (fileType == null) {
                    FileType.$$$reportNull$$$0(1);
                }
                return fileType;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".svg")) {
                FileType fileType = SVG;
                if (fileType == null) {
                    FileType.$$$reportNull$$$0(2);
                }
                return fileType;
            }
            if (SdkUtils.endsWithIgnoreCase((String)path, (String)".psd")) {
                FileType fileType = LAYERED_IMAGE;
                if (fileType == null) {
                    FileType.$$$reportNull$$$0(3);
                }
                return fileType;
            }
            FileType fileType = RASTER_IMAGE_CANDIDATE;
            if (fileType == null) {
                FileType.$$$reportNull$$$0(4);
            }
            return fileType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/ImageAsset$FileType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/ImageAsset$FileType";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fromFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fromFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

