/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.tools.idea.npw.assetstudio.TextRenderUtil;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextAsset
extends BaseAsset {
    public static final String DEFAULT_TEXT = "Aa";
    private static final String PREFERRED_FONT = "Roboto";
    private static final int FONT_SIZE = 144;
    private final StringProperty myText = new StringValueProperty("Aa");
    private final StringProperty myFontFamily = new StringValueProperty();
    private final List<String> myAllFontFamilies = ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());

    public TextAsset() {
        this.selectFontFamily(PREFERRED_FONT);
    }

    private void selectFontFamily(@NotNull String fontFamily) {
        if (fontFamily == null) {
            TextAsset.$$$reportNull$$$0(0);
        }
        if (this.myAllFontFamilies.contains(fontFamily)) {
            this.myFontFamily.set(fontFamily);
        } else if (!this.myAllFontFamilies.isEmpty()) {
            this.myFontFamily.set(this.myAllFontFamilies.get(0));
        }
    }

    @NotNull
    public static List<String> getAllFontFamilies() {
        ImmutableList immutableList = ImmutableList.copyOf((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        if (immutableList == null) {
            TextAsset.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @NotNull
    public StringProperty text() {
        StringProperty stringProperty = this.myText;
        if (stringProperty == null) {
            TextAsset.$$$reportNull$$$0(2);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty fontFamily() {
        StringProperty stringProperty = this.myFontFamily;
        if (stringProperty == null) {
            TextAsset.$$$reportNull$$$0(3);
        }
        return stringProperty;
    }

    @NotNull
    public String defaultFontFamily() {
        if (this.myAllFontFamilies.contains(PREFERRED_FONT)) {
            if (PREFERRED_FONT == null) {
                TextAsset.$$$reportNull$$$0(4);
            }
            return PREFERRED_FONT;
        }
        String string = this.myAllFontFamilies.isEmpty() ? "" : this.myAllFontFamilies.get(0);
        if (string == null) {
            TextAsset.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @Nullable
    public ListenableFuture<BufferedImage> toImage() {
        TextRenderUtil.Options options = new TextRenderUtil.Options();
        options.font = Font.decode(this.myFontFamily + " " + 144);
        options.foregroundColor = ((Color)this.color().get()).getRGB();
        return Futures.immediateFuture((Object)TextRenderUtil.renderTextImage((String)this.myText.get(), 1, options));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamily";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/TextAsset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/TextAsset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFontFamilies";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "text";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fontFamily";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultFontFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectFontFamily";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

