/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.adtui.TabularLayout;
import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.npw.assetstudio.wizard.PersistentState;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.core.ObjectProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.intellij.openapi.components.PersistentStateComponent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public final class TextAssetEditor
extends JPanel
implements AssetComponent<TextAsset>,
PersistentStateComponent<PersistentState> {
    private static final String TEXT_PROPERTY = "text";
    private static final String FONT_FAMILY_PROPERTY = "fontFamily";
    private final TextAsset myTextAsset = new TextAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myListeners = new ArrayList<ActionListener>(1);

    public TextAssetEditor() {
        super((LayoutManager)new TabularLayout("50px,180px"));
        JTextField textField2 = new JTextField();
        List<String> fontFamilies = TextAsset.getAllFontFamilies();
        JComboBox<String> fontCombo = new JComboBox<String>(fontFamilies.toArray(new String[fontFamilies.size()]));
        this.add((Component)textField2, new TabularLayout.Constraint(0, 0));
        this.add(fontCombo, new TabularLayout.Constraint(0, 1));
        this.myBindings.bindTwoWay(new TextProperty(textField2), this.myTextAsset.text());
        SelectedItemProperty selectedFont = new SelectedItemProperty(fontCombo);
        this.myBindings.bindTwoWay(ObjectProperty.wrap(selectedFont), this.myTextAsset.fontFamily());
        InvalidationListener onTextChanged = sender -> {
            ActionEvent e = new ActionEvent(this, 1001, null);
            for (ActionListener listener : this.myListeners) {
                listener.actionPerformed(e);
            }
        };
        this.myTextAsset.text().addListener(onTextChanged);
        this.myTextAsset.fontFamily().addListener(onTextChanged);
    }

    @Override
    @NotNull
    public TextAsset getAsset() {
        TextAsset textAsset = this.myTextAsset;
        if (textAsset == null) {
            TextAssetEditor.$$$reportNull$$$0(0);
        }
        return textAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener listener) {
        if (listener == null) {
            TextAssetEditor.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.clear();
    }

    @NotNull
    public PersistentState getState() {
        PersistentState state = new PersistentState();
        state.set(TEXT_PROPERTY, (String)this.myTextAsset.text().get(), "Aa");
        state.set(FONT_FAMILY_PROPERTY, (String)this.myTextAsset.fontFamily().get(), this.myTextAsset.defaultFontFamily());
        PersistentState persistentState = state;
        if (persistentState == null) {
            TextAssetEditor.$$$reportNull$$$0(2);
        }
        return persistentState;
    }

    public void loadState(@NotNull PersistentState state) {
        if (state == null) {
            TextAssetEditor.$$$reportNull$$$0(3);
        }
        this.myTextAsset.text().set(state.get(TEXT_PROPERTY, "Aa"));
        this.myTextAsset.fontFamily().set(state.get(FONT_FAMILY_PROPERTY, this.myTextAsset.defaultFontFamily()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/ui/TextAssetEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsset";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/ui/TextAssetEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addAssetListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

