/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.adtui.ASGallery;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidPackageUtils;
import com.android.tools.idea.npw.template.ConfigureTemplateParametersStep;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringProperty;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.projectsystem.NamedModuleTemplate;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseActivityTypeStep
extends SkippableWizardStep<NewModuleModel> {
    private final RenderTemplateModel myRenderModel;
    @NotNull
    private List<TemplateRenderer> myTemplateRenderers;
    @NotNull
    private List<NamedModuleTemplate> myModuleTemplates;
    @NotNull
    private ASGallery<TemplateRenderer> myActivityGallery;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    private final StringProperty myInvalidParameterMessage;
    private final ListenerManager myListeners;
    @Nullable
    private AndroidFacet myFacet;

    public ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor, @NotNull List<NamedModuleTemplate> moduleTemplates) {
        if (moduleModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(0);
        }
        if (renderModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(1);
        }
        if (formFactor == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(2);
        }
        if (moduleTemplates == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(3);
        }
        this(moduleModel, renderModel, formFactor);
        this.init(formFactor, moduleTemplates, null);
    }

    public ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor, @NotNull AndroidFacet facet, @NotNull VirtualFile targetDirectory) {
        if (moduleModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(4);
        }
        if (renderModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(5);
        }
        if (formFactor == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(6);
        }
        if (facet == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(7);
        }
        if (targetDirectory == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(8);
        }
        this(moduleModel, renderModel, formFactor);
        List<NamedModuleTemplate> moduleTemplates = AndroidPackageUtils.getModuleTemplates(facet, targetDirectory);
        this.init(formFactor, moduleTemplates, facet);
    }

    private ChooseActivityTypeStep(@NotNull NewModuleModel moduleModel, @NotNull RenderTemplateModel renderModel, @NotNull FormFactor formFactor) {
        if (moduleModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(9);
        }
        if (renderModel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(10);
        }
        if (formFactor == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(11);
        }
        super(moduleModel, AndroidBundle.message("android.wizard.activity.add", formFactor.id), formFactor.getIcon());
        this.myInvalidParameterMessage = new StringValueProperty();
        this.myListeners = new ListenerManager();
        this.myRenderModel = renderModel;
    }

    private void init(@NotNull FormFactor formFactor, @NotNull List<NamedModuleTemplate> moduleTemplates, @Nullable AndroidFacet facet) {
        if (formFactor == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(12);
        }
        if (moduleTemplates == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(13);
        }
        this.myModuleTemplates = moduleTemplates;
        this.myFacet = facet;
        List<TemplateHandle> templateHandles = TemplateManager.getInstance().getTemplateList(formFactor);
        this.myTemplateRenderers = Lists.newArrayListWithExpectedSize((int)(templateHandles.size() + 1));
        if (this.isNewModule()) {
            this.myTemplateRenderers.add(new TemplateRenderer(null));
        }
        for (TemplateHandle templateHandle : templateHandles) {
            this.myTemplateRenderers.add(new TemplateRenderer(templateHandle));
        }
        this.myActivityGallery = ChooseActivityTypeStep.createGallery(this.getTitle());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)new JBScrollPane(this.myActivityGallery));
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myValidatorPanel);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        ValidatorPanel validatorPanel = this.myValidatorPanel;
        if (validatorPanel == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(14);
        }
        return validatorPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myActivityGallery;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        String title = AndroidBundle.message("android.wizard.config.activity.title", new Object[0]);
        ArrayList arrayList = Lists.newArrayList((Object[])new ConfigureTemplateParametersStep[]{new ConfigureTemplateParametersStep(this.myRenderModel, title, this.myModuleTemplates, this.myFacet)});
        if (arrayList == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Override
    public void dispose() {
        this.myListeners.releaseAll();
    }

    private static ASGallery<TemplateRenderer> createGallery(String title) {
        ASGallery<TemplateRenderer> gallery = new ASGallery<TemplateRenderer>((ListModel)JBList.createDefaultListModel((Object[])new Object[0]), TemplateRenderer::getImage, TemplateRenderer::getTitle, WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE, null){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension cellSize = this.computeCellSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                int widthInsets = this.getInsets().left + this.getInsets().right;
                return new Dimension(cellSize.width * 5 + widthInsets, (int)((double)cellSize.height * 2.2) + heightInsets);
            }
        };
        gallery.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        gallery.getAccessibleContext().setAccessibleDescription(title);
        return gallery;
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(16);
        }
        this.myValidatorPanel.registerMessageSource((ObservableValue)this.myInvalidParameterMessage);
        this.myActivityGallery.setDefaultAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myActivityGallery.addListSelectionListener(listSelectionEvent -> {
            TemplateRenderer selectedTemplate;
            if (wizard == null) {
                ChooseActivityTypeStep.$$$reportNull$$$0(20);
            }
            if ((selectedTemplate = (TemplateRenderer)this.myActivityGallery.getSelectedElement()) != null) {
                this.myRenderModel.setTemplateHandle(selectedTemplate.getTemplate());
                wizard.updateNavigationProperties();
            }
            this.validateTemplate();
        });
        this.myListeners.receiveAndFire(((NewModuleModel)this.getModel()).enableCppSupport().or(((NewModuleModel)this.getModel()).instantApp()), src -> {
            TemplateRenderer[] listItems = this.createGalleryList(this.myTemplateRenderers);
            this.myActivityGallery.setModel((ListModel)JBList.createDefaultListModel((Object[])listItems));
            this.myActivityGallery.setSelectedIndex(ChooseActivityTypeStep.getDefaultSelectedTemplateIndex(listItems, this.isNewModule()));
        });
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(17);
        }
        return observableBool;
    }

    @Override
    protected void onEntering() {
        this.validateTemplate();
    }

    @Override
    protected void onProceeding() {
        NewModuleModel moduleModel = (NewModuleModel)this.getModel();
        Project project = moduleModel.getProject().getValueOrNull();
        if (this.myRenderModel.getTemplateHandle() == null) {
            moduleModel.setDefaultRenderTemplateValues(this.myRenderModel, project);
        } else {
            moduleModel.getRenderTemplateValues().setValue(this.myRenderModel.getTemplateValues());
        }
        new TemplateValueInjector(moduleModel.getTemplateValues()).setProjectDefaults(project, (String)moduleModel.applicationName().get(), (Boolean)this.myRenderModel.instantApp().get());
    }

    private static int getDefaultSelectedTemplateIndex(@NotNull TemplateRenderer[] templateRenderers, boolean isNewModule) {
        int i;
        if (templateRenderers == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(18);
        }
        for (i = 0; i < templateRenderers.length; ++i) {
            if (!templateRenderers[i].getTitle().equals("Empty Activity")) continue;
            return i;
        }
        for (i = 0; i < templateRenderers.length; ++i) {
            if (templateRenderers[i].getTemplate() == null) continue;
            return i;
        }
        assert (false);
        return 0;
    }

    private boolean isNewModule() {
        return this.myFacet == null;
    }

    private TemplateRenderer[] createGalleryList(@NotNull List<TemplateRenderer> templateRenderers) {
        if (templateRenderers == null) {
            ChooseActivityTypeStep.$$$reportNull$$$0(19);
        }
        Predicate<TemplateRenderer> predicate = (Boolean)((NewModuleModel)this.getModel()).enableCppSupport().get() != false ? TemplateRenderer::isCppTemplate : ((Boolean)((NewModuleModel)this.getModel()).instantApp().get() != false ? TemplateRenderer::isIappTemplate : templateRenderer -> true);
        List<TemplateRenderer> filteredTemplates = templateRenderers.stream().filter(predicate).collect(Collectors.toList());
        if (filteredTemplates.size() > 1) {
            return filteredTemplates.toArray(new TemplateRenderer[filteredTemplates.size()]);
        }
        return templateRenderers.toArray(new TemplateRenderer[templateRenderers.size()]);
    }

    private void validateTemplate() {
        TemplateHandle template = this.myRenderModel.getTemplateHandle();
        TemplateMetadata templateData = template == null ? null : template.getMetadata();
        AndroidVersionsInfo.VersionItem androidSdkInfo = this.myRenderModel.androidSdkInfo().getValueOrNull();
        this.myInvalidParameterMessage.set(ChooseActivityTypeStep.validateTemplate(templateData, androidSdkInfo, this.isNewModule()));
    }

    private static String validateTemplate(@Nullable TemplateMetadata template, @Nullable AndroidVersionsInfo.VersionItem androidSdkInfo, boolean isNewModule) {
        if (template == null) {
            return isNewModule ? "" : AndroidBundle.message("android.wizard.activity.not.found", new Object[0]);
        }
        if (androidSdkInfo != null) {
            if (androidSdkInfo.getMinApiLevel() < template.getMinSdk()) {
                return AndroidBundle.message("android.wizard.activity.invalid.min.sdk", template.getMinSdk());
            }
            if (androidSdkInfo.getBuildApiLevel() < template.getMinBuildApi()) {
                return AndroidBundle.message("android.wizard.activity.invalid.min.build", template.getMinBuildApi());
            }
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderModel";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTemplates";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/template/ChooseActivityTypeStep";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRenderers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/template/ChooseActivityTypeStep";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSelectedTemplateIndex";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createGalleryList";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$onWizardStarting$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TemplateRenderer {
        @Nullable
        private final TemplateHandle myTemplate;

        TemplateRenderer(@Nullable TemplateHandle template) {
            this.myTemplate = template;
        }

        @Nullable
        TemplateHandle getTemplate() {
            return this.myTemplate;
        }

        @NotNull
        String getTitle() {
            String string = this.myTemplate == null ? AndroidBundle.message("android.wizard.gallery.item.add.no.activity", new Object[0]) : this.myTemplate.getMetadata().getTitle();
            if (string == null) {
                TemplateRenderer.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return this.getTitle();
        }

        boolean isCppTemplate() {
            if (this.myTemplate == null) {
                return true;
            }
            String title = this.myTemplate.getMetadata().getTitle();
            return "Empty Activity".equals(title) || "Basic Activity".equals(title);
        }

        boolean isIappTemplate() {
            return !"Settings Activity".equals(this.getTitle());
        }

        @Nullable
        Image getImage() {
            String thumb;
            String string = thumb = this.myTemplate == null ? null : this.myTemplate.getMetadata().getThumbnailPath();
            if (thumb != null && !thumb.isEmpty()) {
                try {
                    File file = new File(this.myTemplate.getRootPath(), thumb.replace('/', File.separatorChar));
                    return file.isFile() ? ImageIO.read(file) : null;
                }
                catch (IOException e) {
                    Logger.getInstance(ChooseActivityTypeStep.class).warn((Throwable)e);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/template/ChooseActivityTypeStep$TemplateRenderer", "getTitle"));
        }
    }
}

