/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.SaveFileListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    private JPanel myContentPane;
    private TextFieldWithBrowseButton myPathTextFieldWithButton;

    public ExportDialog(@NotNull Project project, @NotNull String dialogTitle, @NotNull String fileExtension) {
        if (project == null) {
            ExportDialog.$$$reportNull$$$0(0);
        }
        if (dialogTitle == null) {
            ExportDialog.$$$reportNull$$$0(1);
        }
        if (fileExtension == null) {
            ExportDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setTitle(dialogTitle);
        this.myPathTextFieldWithButton.addActionListener((ActionListener)new SaveFileListener(this.myContentPane, this.myPathTextFieldWithButton, dialogTitle, fileExtension){

            @Override
            @Nullable
            protected String getDefaultLocation() {
                return ExportDialog.this.myProject.getBasePath();
            }
        });
        this.myPathTextFieldWithButton.setTextFieldPreferredWidth(60);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String path = this.myPathTextFieldWithButton.getText().trim();
        JTextField textField2 = this.myPathTextFieldWithButton.getTextField();
        if (path.isEmpty()) {
            return new ValidationInfo("Destination should not be empty", (JComponent)textField2);
        }
        File f = new File(path);
        if (!f.isAbsolute()) {
            return new ValidationInfo("Destination path must be absolute.", (JComponent)textField2);
        }
        if (f.getParentFile() == null || !f.getParentFile().isDirectory()) {
            return new ValidationInfo("Invalid path", (JComponent)textField2);
        }
        return null;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "ExportDialogDimensions";
    }

    @NotNull
    File getFile() {
        File file = new File(this.myPathTextFieldWithButton.getText().trim());
        if (file == null) {
            ExportDialog.$$$reportNull$$$0(3);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtension";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/ExportDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/ExportDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Save As:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPathTextFieldWithButton = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

