/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.idea.profilers.IntellijAutoCompleteTextField;
import com.android.tools.idea.profilers.IntellijContextMenuInstaller;
import com.android.tools.idea.profilers.IntellijDataViewer;
import com.android.tools.idea.profilers.IntellijExportDialog;
import com.android.tools.idea.profilers.ResizableImage;
import com.android.tools.idea.profilers.stacktrace.IntelliJStackTraceView;
import com.android.tools.profilers.AutoCompleteTextField;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.ExportDialog;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.stacktrace.DataViewer;
import com.android.tools.profilers.stacktrace.LoadingPanel;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijProfilerComponents
implements IdeProfilerComponents {
    private static final Map<String, FileType> FILE_TYPE_MAP = new ImmutableMap.Builder().put((Object)".csv", (Object)FileTypeManager.getInstance().getStdFileType("CSV")).put((Object)".html", (Object)StdFileTypes.HTML).put((Object)".json", (Object)FileTypeManager.getInstance().getStdFileType("JSON")).put((Object)".xml", (Object)StdFileTypes.XML).build();
    private static final ImmutableSet<String> IMAGE_EXTENSIONS = ImmutableSet.of((Object)".bmp", (Object)".gif", (Object)".jpeg", (Object)".jpg", (Object)".png", (Object)".webp", (Object[])new String[0]);
    @NotNull
    private final Project myProject;

    public IntellijProfilerComponents(@NotNull Project project) {
        if (project == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public LoadingPanel createLoadingPanel(final int delayMs) {
        LoadingPanel loadingPanel = new LoadingPanel(){
            private final JBLoadingPanel myLoadingPanel;
            {
                this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)IntellijProfilerComponents.this.myProject, delayMs);
            }

            @NotNull
            public JComponent getComponent() {
                JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
                if (jBLoadingPanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return jBLoadingPanel;
            }

            public void setChildComponent(@Nullable Component comp) {
                this.myLoadingPanel.getContentPanel().removeAll();
                if (comp != null) {
                    this.myLoadingPanel.add(comp);
                }
            }

            public void setLoadingText(@NotNull String loadingText) {
                if (loadingText == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.myLoadingPanel.setLoadingText(loadingText);
            }

            public void startLoading() {
                this.myLoadingPanel.startLoading();
            }

            public void stopLoading() {
                this.myLoadingPanel.stopLoading();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/android/tools/idea/profilers/IntellijProfilerComponents$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "loadingText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComponent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/android/tools/idea/profilers/IntellijProfilerComponents$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setLoadingText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (loadingPanel == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(1);
        }
        return loadingPanel;
    }

    @NotNull
    public StackTraceView createStackView(@NotNull StackTraceModel model) {
        if (model == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(2);
        }
        IntelliJStackTraceView stackTraceView = new IntelliJStackTraceView(this.myProject, model);
        stackTraceView.installNavigationContextMenu(this.createContextMenuInstaller());
        IntelliJStackTraceView intelliJStackTraceView = stackTraceView;
        if (intelliJStackTraceView == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(3);
        }
        return intelliJStackTraceView;
    }

    @NotNull
    public ContextMenuInstaller createContextMenuInstaller() {
        IntellijContextMenuInstaller intellijContextMenuInstaller = new IntellijContextMenuInstaller();
        if (intellijContextMenuInstaller == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(4);
        }
        return intellijContextMenuInstaller;
    }

    @NotNull
    public ExportDialog createExportDialog() {
        IntellijExportDialog intellijExportDialog = new IntellijExportDialog(this.myProject);
        if (intellijExportDialog == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(5);
        }
        return intellijExportDialog;
    }

    @NotNull
    public DataViewer createFileViewer(@NotNull File file) {
        String fileName;
        int dot;
        String extension;
        if (file == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(6);
        }
        String string = extension = (dot = (fileName = file.getName()).lastIndexOf(46)) >= 0 && dot < fileName.length() ? fileName.substring(dot) : "";
        if (IMAGE_EXTENSIONS.contains((Object)extension)) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (image != null) {
                IntellijDataViewer intellijDataViewer = IntellijDataViewer.createImageViewer(image);
                if (intellijDataViewer == null) {
                    IntellijProfilerComponents.$$$reportNull$$$0(7);
                }
                return intellijDataViewer;
            }
            IntellijDataViewer intellijDataViewer = IntellijDataViewer.createInvalidViewer();
            if (intellijDataViewer == null) {
                IntellijProfilerComponents.$$$reportNull$$$0(8);
            }
            return intellijDataViewer;
        }
        String content = null;
        if (file.exists()) {
            try {
                content = new String(Files.readAllBytes(file.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (content == null) {
            IntellijDataViewer intellijDataViewer = IntellijDataViewer.createInvalidViewer();
            if (intellijDataViewer == null) {
                IntellijProfilerComponents.$$$reportNull$$$0(9);
            }
            return intellijDataViewer;
        }
        IntellijDataViewer intellijDataViewer = IntellijDataViewer.createEditorViewer(content, FILE_TYPE_MAP.getOrDefault(extension, null));
        if (intellijDataViewer == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(10);
        }
        return intellijDataViewer;
    }

    @NotNull
    public JComponent createResizableImageComponent(@NotNull BufferedImage image) {
        if (image == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(11);
        }
        ResizableImage resizableImage = new ResizableImage(image);
        if (resizableImage == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(12);
        }
        return resizableImage;
    }

    @NotNull
    public AutoCompleteTextField createAutoCompleteTextField(@NotNull String placeholder, @NotNull String value, @NotNull Collection<String> variants) {
        if (placeholder == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(13);
        }
        if (value == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(14);
        }
        if (variants == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(15);
        }
        IntellijAutoCompleteTextField intellijAutoCompleteTextField = new IntellijAutoCompleteTextField(this.myProject, placeholder, value, variants);
        if (intellijAutoCompleteTextField == null) {
            IntellijProfilerComponents.$$$reportNull$$$0(16);
        }
        return intellijAutoCompleteTextField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/IntellijProfilerComponents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/IntellijProfilerComponents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createLoadingPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextMenuInstaller";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createExportDialog";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileViewer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createResizableImageComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createAutoCompleteTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createStackView";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFileViewer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createResizableImageComponent";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createAutoCompleteTextField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

