/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers;

import com.android.tools.profiler.proto.MemoryProfiler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class LegacyAllocationConverter {
    @NotNull
    private List<Allocation> myAllocations = new ArrayList<Allocation>();
    @NotNull
    private Map<String, ClassName> myAllocatedClasses = new HashMap<String, ClassName>();
    @NotNull
    private Map<List<StackTraceElement>, CallStack> myAllocationStacks = new HashMap<List<StackTraceElement>, CallStack>();

    public int addClassName(@NotNull String className) {
        int id;
        if (className == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(0);
        }
        if (!this.myAllocatedClasses.containsKey(className)) {
            id = this.myAllocatedClasses.size();
            this.myAllocatedClasses.put(className, new ClassName(className, id));
        } else {
            id = this.myAllocatedClasses.get(className).myClassId;
        }
        return id;
    }

    @NotNull
    public CallStack addCallStack(@NotNull List<StackTraceElement> stackTraceElements) {
        CallStack result;
        if (stackTraceElements == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(1);
        }
        if (!this.myAllocationStacks.containsKey(stackTraceElements)) {
            result = new CallStack(stackTraceElements);
            this.myAllocationStacks.put(stackTraceElements, result);
        } else {
            result = this.myAllocationStacks.get(stackTraceElements);
        }
        CallStack callStack = result;
        if (callStack == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(2);
        }
        return callStack;
    }

    public void prepare() {
        this.myAllocations.clear();
    }

    public void addAllocation(@NotNull Allocation allocationInfo) {
        if (allocationInfo == null) {
            LegacyAllocationConverter.$$$reportNull$$$0(3);
        }
        this.myAllocations.add(allocationInfo);
    }

    public List<MemoryProfiler.LegacyAllocationEvent> getAllocationEvents(long startTime, long endTime) {
        return this.myAllocations.stream().map(allocation -> allocation.bindAllocationEventInfos(startTime, endTime)).collect(Collectors.toList());
    }

    public List<MemoryProfiler.AllocationStack> getAllocationStacks() {
        return this.myAllocationStacks.values().stream().map(CallStack::getAllocationStack).collect(Collectors.toList());
    }

    public List<MemoryProfiler.AllocatedClass> getClassNames() {
        return this.myAllocatedClasses.values().stream().map(ClassName::getAllocatedClass).collect(Collectors.toList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTraceElements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/LegacyAllocationConverter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/LegacyAllocationConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addCallStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addClassName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addCallStack";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAllocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Allocation {
        private final int myClassId;
        private final int mySize;
        private final int myThreadId;
        private final int myCallStackId;

        public Allocation(int classId, int size, int threadId, @NotNull int callStackId) {
            this.myClassId = classId;
            this.mySize = size;
            this.myThreadId = threadId;
            this.myCallStackId = callStackId;
        }

        @NotNull
        public MemoryProfiler.LegacyAllocationEvent bindAllocationEventInfos(long startTime, long endTime) {
            MemoryProfiler.LegacyAllocationEvent legacyAllocationEvent = MemoryProfiler.LegacyAllocationEvent.newBuilder().setClassId(this.myClassId).setSize(this.mySize).setThreadId(this.myThreadId).setCaptureTime(startTime).setTimestamp(endTime).setStackId(this.myCallStackId).build();
            if (legacyAllocationEvent == null) {
                Allocation.$$$reportNull$$$0(0);
            }
            return legacyAllocationEvent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/profilers/LegacyAllocationConverter$Allocation", "bindAllocationEventInfos"));
        }
    }

    public static class ClassName {
        private final String myClassName;
        private final int myClassId;

        public ClassName(@NotNull String className, int classId) {
            if (className == null) {
                ClassName.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
            this.myClassId = classId;
        }

        @NotNull
        public MemoryProfiler.AllocatedClass getAllocatedClass() {
            MemoryProfiler.AllocatedClass allocatedClass = MemoryProfiler.AllocatedClass.newBuilder().setClassName(this.myClassName).setClassId(this.myClassId).build();
            if (allocatedClass == null) {
                ClassName.$$$reportNull$$$0(1);
            }
            return allocatedClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/profilers/LegacyAllocationConverter$ClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/profilers/LegacyAllocationConverter$ClassName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllocatedClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CallStack {
        @NotNull
        private final List<StackTraceElement> myCallStackFrames;

        public CallStack(@NotNull List<StackTraceElement> frames) {
            if (frames == null) {
                CallStack.$$$reportNull$$$0(0);
            }
            this.myCallStackFrames = frames;
        }

        public int hashCode() {
            return this.myCallStackFrames.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CallStack)) {
                return false;
            }
            return this.myCallStackFrames.equals(((CallStack)obj).myCallStackFrames);
        }

        @NotNull
        public MemoryProfiler.AllocationStack getAllocationStack() {
            MemoryProfiler.AllocationStack.Builder builder = MemoryProfiler.AllocationStack.newBuilder().setStackId(this.hashCode());
            MemoryProfiler.AllocationStack.StackFrameWrapper.Builder frameBuilder = MemoryProfiler.AllocationStack.StackFrameWrapper.newBuilder();
            for (StackTraceElement frame : this.myCallStackFrames) {
                frameBuilder.addFrames(MemoryProfiler.AllocationStack.StackFrame.newBuilder().setClassName(frame.getClassName()).setMethodName(frame.getMethodName()).setFileName(frame.getFileName()).setLineNumber(frame.getLineNumber()).build());
            }
            builder.setFullStack(frameBuilder);
            MemoryProfiler.AllocationStack allocationStack = builder.build();
            if (allocationStack == null) {
                CallStack.$$$reportNull$$$0(1);
            }
            return allocationStack;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/profilers/LegacyAllocationConverter$CallStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/profilers/LegacyAllocationConverter$CallStack";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllocationStack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

