/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profilers.stacktrace;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.idea.profilers.stacktrace.CodeElement;
import com.android.tools.idea.profilers.stacktrace.IntelliJCodeElement;
import com.android.tools.idea.profilers.stacktrace.StackElement;
import com.android.tools.idea.profilers.stacktrace.ThreadElement;
import com.android.tools.profilers.ContextMenuInstaller;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.stacktrace.CodeLocation;
import com.android.tools.profilers.stacktrace.StackTraceModel;
import com.android.tools.profilers.stacktrace.StackTraceView;
import com.android.tools.profilers.stacktrace.ThreadId;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class IntelliJStackTraceView
extends AspectObserver
implements StackTraceView {
    @NotNull
    private final Project myProject;
    @NotNull
    private final StackTraceModel myModel;
    @NotNull
    private final BiFunction<Project, CodeLocation, CodeElement> myGenerator;
    @NotNull
    private final JBScrollPane myScrollPane;
    @NotNull
    private final DefaultListModel<StackElement> myListModel;
    @NotNull
    private final JBList myListView;

    public IntelliJStackTraceView(@NotNull Project project, @NotNull StackTraceModel model) {
        if (project == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(0);
        }
        if (model == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(1);
        }
        this(project, model, IntelliJCodeElement::new);
    }

    @VisibleForTesting
    IntelliJStackTraceView(@NotNull Project project, @NotNull StackTraceModel model, @NotNull BiFunction<Project, CodeLocation, CodeElement> stackNavigationGenerator) {
        if (project == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(2);
        }
        if (model == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(3);
        }
        if (stackNavigationGenerator == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myModel = model;
        this.myGenerator = stackNavigationGenerator;
        this.myListModel = new DefaultListModel();
        this.myListView = new JBList(this.myListModel);
        this.myListView.setSelectionMode(0);
        this.myListView.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        this.myListView.setCellRenderer((ListCellRenderer)((Object)new StackElementRenderer()));
        this.myScrollPane = new JBScrollPane((Component)this.myListView);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        this.myListView.addListSelectionListener(e -> {
            if (this.myListView.getSelectedValue() == null) {
                this.myModel.clearSelection();
            }
        });
        final Supplier<Boolean> navigationHandler = () -> {
            int index = this.myListView.getSelectedIndex();
            if (index >= 0 && index < this.myListView.getItemsCount()) {
                this.myModel.setSelectedIndex(index);
                return true;
            }
            return false;
        };
        this.myListView.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = KeyEvent.getExtendedKeyCodeForChar(e.getKeyChar());
                if (keyCode == 10 && ((Boolean)navigationHandler.get()).booleanValue()) {
                    e.consume();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                return (Boolean)navigationHandler.get();
            }
        }.installOn((Component)this.myListView);
        this.myListView.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row;
                if (SwingUtilities.isRightMouseButton(e) && (row = IntelliJStackTraceView.this.myListView.locationToIndex(e.getPoint())) != -1) {
                    IntelliJStackTraceView.this.myListView.setSelectedIndex(row);
                }
            }
        });
        this.myModel.addDependency((AspectObserver)this).onChange((Enum)StackTraceModel.Aspect.STACK_FRAMES, () -> {
            List stackFrames = this.myModel.getCodeLocations();
            this.myListModel.removeAllElements();
            this.myListView.clearSelection();
            stackFrames.forEach(stackFrame -> this.myListModel.addElement(this.myGenerator.apply(this.myProject, (CodeLocation)stackFrame)));
            ThreadId threadId = this.myModel.getThreadId();
            if (!threadId.equals((Object)ThreadId.INVALID_THREAD_ID)) {
                this.myListModel.addElement(new ThreadElement(threadId));
            }
        }).onChange((Enum)StackTraceModel.Aspect.SELECTED_LOCATION, () -> {
            int index = this.myModel.getSelectedIndex();
            if (this.myModel.getSelectedType() == StackTraceModel.Type.INVALID) {
                if (this.myListView.getSelectedIndex() != -1) {
                    this.myListView.clearSelection();
                }
            } else if (index >= 0 && index < this.myListView.getItemsCount()) {
                if (this.myListView.getSelectedIndex() != index) {
                    this.myListView.setSelectedIndex(index);
                }
            } else {
                throw new IndexOutOfBoundsException("View has " + this.myListView.getItemsCount() + " elements while aspect is changing to index " + index);
            }
        });
    }

    public void installNavigationContextMenu(@NotNull ContextMenuInstaller contextMenuInstaller) {
        if (contextMenuInstaller == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(5);
        }
        contextMenuInstaller.installNavigationContextMenu((JComponent)this.myListView, this.myModel.getCodeNavigator(), () -> {
            int index = this.myListView.getSelectedIndex();
            if (index >= 0 && index < this.myListView.getItemsCount()) {
                return (CodeLocation)this.myModel.getCodeLocations().get(index);
            }
            return null;
        });
    }

    @NotNull
    public StackTraceModel getModel() {
        StackTraceModel stackTraceModel = this.myModel;
        if (stackTraceModel == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(6);
        }
        return stackTraceModel;
    }

    @NotNull
    public JComponent getComponent() {
        JBScrollPane jBScrollPane = this.myScrollPane;
        if (jBScrollPane == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(7);
        }
        return jBScrollPane;
    }

    @VisibleForTesting
    @NotNull
    JBList getListView() {
        JBList jBList = this.myListView;
        if (jBList == null) {
            IntelliJStackTraceView.$$$reportNull$$$0(8);
        }
        return jBList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackNavigationGenerator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextMenuInstaller";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/profilers/stacktrace/IntelliJStackTraceView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/profilers/stacktrace/IntelliJStackTraceView";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getListView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "installNavigationContextMenu";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StackElementRenderer
    extends ColoredListCellRenderer<StackElement> {
        private StackElementRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, StackElement value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                StackElementRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                return;
            }
            this.setIpad(ProfilerLayout.LIST_ROW_INSETS);
            if (value instanceof CodeElement) {
                this.renderStackNavigation((CodeElement)value, selected);
            } else if (value instanceof ThreadElement) {
                this.renderThreadElement((ThreadElement)value, selected);
            } else {
                this.append(value.toString(), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        private void renderStackNavigation(@NotNull CodeElement codeElement, boolean selected) {
            if (codeElement == null) {
                StackElementRenderer.$$$reportNull$$$0(1);
            }
            this.setIcon(PlatformIcons.METHOD_ICON);
            SimpleTextAttributes textAttribute = selected || codeElement.isInUserCode() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
            CodeLocation location = codeElement.getCodeLocation();
            StringBuilder methodBuilder = new StringBuilder(codeElement.getMethodName());
            if (location.getLineNumber() != -1) {
                methodBuilder.append(":");
                methodBuilder.append(location.getLineNumber() + 1);
            }
            methodBuilder.append(", ");
            methodBuilder.append(codeElement.getSimpleClassName());
            String methodName = methodBuilder.toString();
            this.append(methodName, textAttribute, methodName);
            String packageName = " (" + codeElement.getPackageName() + ")";
            this.append(packageName, selected ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES, packageName);
        }

        private void renderThreadElement(@NotNull ThreadElement threadElement, boolean selected) {
            if (threadElement == null) {
                StackElementRenderer.$$$reportNull$$$0(2);
            }
            this.setIcon(AllIcons.Debugger.ThreadSuspended);
            String text = threadElement.getThreadId().toString();
            this.append(text, selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES, text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "threadElement";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/profilers/stacktrace/IntelliJStackTraceView$StackElementRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderStackNavigation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderThreadElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

