/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.DataBindingResourceType;
import com.android.ide.common.res2.ResourceItem;
import com.android.resources.ResourceType;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.MergedDataBindingInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.PsiResourceFile;
import com.android.tools.idea.res.PsiResourceItem;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LayoutDataBindingInfo
implements DataBindingInfo {
    private final Map<DataBindingResourceType, List<PsiDataBindingResourceItem>> myItems = Maps.newEnumMap(DataBindingResourceType.class);
    private String myClassName;
    private String myNonConfigurationClassName;
    private String myPackageName;
    private final PsiResourceFile myPsiResourceFile;
    private PsiClass myPsiClass;
    private long myLayoutModificationCount;
    private long myBindingModificationCount;
    private boolean myClassNameSpecifiedByUser;
    private final AndroidFacet myFacet;
    private String myConfigurationName;
    private MergedDataBindingInfo myMergedInfo;

    LayoutDataBindingInfo(AndroidFacet facet, PsiResourceFile psiResourceFile, String className, String packageName, boolean classNameSpecifiedByUser) {
        this.myFacet = facet;
        this.myNonConfigurationClassName = className;
        this.myClassName = className;
        this.myPackageName = packageName;
        this.myClassNameSpecifiedByUser = classNameSpecifiedByUser;
        this.myPsiResourceFile = psiResourceFile;
        PsiDirectory parent = this.myPsiResourceFile.getPsiFile().getParent();
        this.myConfigurationName = parent != null ? parent.getName() : "";
    }

    @Override
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    void update(String className, String packageName, boolean classNameSpecifiedByUser, long modificationCount) {
        if (StringUtil.equals((CharSequence)this.myNonConfigurationClassName, (CharSequence)className) && StringUtil.equals((CharSequence)this.myPackageName, (CharSequence)packageName) && classNameSpecifiedByUser == this.myClassNameSpecifiedByUser) {
            return;
        }
        this.myNonConfigurationClassName = className;
        this.myPackageName = packageName;
        this.myLayoutModificationCount = modificationCount;
    }

    protected boolean addItem(PsiDataBindingResourceItem item) {
        boolean newItem;
        ArrayList items = this.myItems.get(item.getType());
        if (items == null) {
            items = Lists.newArrayList();
            this.myItems.put(item.getType(), items);
        }
        boolean bl = newItem = !items.contains((Object)item);
        if (newItem) {
            items.add(item);
        }
        return newItem;
    }

    public void replaceItems(Iterable<PsiDataBindingResourceItem> items, long modificationCount) {
        boolean changed;
        boolean bl = changed = this.myItems == null;
        if (this.myItems == null) {
            changed = true;
        } else {
            ArrayList removed = Lists.newArrayList();
            for (Map.Entry<DataBindingResourceType, List<PsiDataBindingResourceItem>> entry : this.myItems.entrySet()) {
                for (PsiDataBindingResourceItem item : entry.getValue()) {
                    if (Iterables.contains(items, (Object)((Object)item))) continue;
                    removed.add(item);
                }
                changed |= !removed.isEmpty();
                for (PsiDataBindingResourceItem item : removed) {
                    entry.getValue().remove((Object)item);
                }
            }
            for (PsiDataBindingResourceItem item : items) {
                changed = this.addItem(item) | changed;
            }
        }
        if (changed) {
            this.myLayoutModificationCount = modificationCount;
        }
    }

    public void setMergedInfo(MergedDataBindingInfo mergedInfo) {
        if (this.myMergedInfo == mergedInfo) {
            return;
        }
        ++this.myBindingModificationCount;
        this.myMergedInfo = mergedInfo;
        this.myClassName = mergedInfo != null ? LayoutDataBindingInfo.calculateConfigurationName(this.myConfigurationName, this.myNonConfigurationClassName) : this.myNonConfigurationClassName;
    }

    private static String calculateConfigurationName(String configurationName, String nonConfigurationClassName) {
        if (StringUtil.isEmpty((String)configurationName)) {
            return nonConfigurationClassName + "Impl";
        }
        if (configurationName.startsWith("layout-")) {
            return nonConfigurationClassName + DataBindingUtil.convertToJavaClassName(configurationName.substring("layout-".length())) + "Impl";
        }
        if (configurationName.startsWith("layout")) {
            return nonConfigurationClassName + "Impl";
        }
        return nonConfigurationClassName + DataBindingUtil.convertToJavaClassName(configurationName) + "Impl";
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public String getPackageName() {
        return this.myPackageName;
    }

    @Override
    public Project getProject() {
        return this.myPsiResourceFile.getPsiFile().getProject();
    }

    @Override
    public String getQualifiedName() {
        return this.myPackageName + "." + this.myClassName;
    }

    String getNonConfigurationClassName() {
        return this.myNonConfigurationClassName;
    }

    String getFileName() {
        return this.myPsiResourceFile.getName();
    }

    @Override
    public PsiElement getNavigationElement() {
        return this.myPsiResourceFile.getPsiFile();
    }

    @Override
    public PsiFile getPsiFile() {
        return this.myPsiResourceFile.getPsiFile();
    }

    @Override
    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @Override
    public void setPsiClass(PsiClass psiClass) {
        this.myPsiClass = psiClass;
    }

    @Override
    @NotNull
    public List<PsiDataBindingResourceItem> getItems(DataBindingResourceType type) {
        List<PsiDataBindingResourceItem> items = this.myItems.get(type);
        List<PsiDataBindingResourceItem> list = items != null ? items : Collections.emptyList();
        if (list == null) {
            LayoutDataBindingInfo.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public List<DataBindingInfo.ViewWithId> getViewsWithIds() {
        Collection resourceItems = this.myPsiResourceFile.getItems();
        ArrayList result = Lists.newArrayList();
        for (ResourceItem item : resourceItems) {
            String name;
            PsiResourceItem psiResourceItem;
            if (!ResourceType.ID.equals((Object)item.getType()) || !(item instanceof PsiResourceItem) || (psiResourceItem = (PsiResourceItem)item).getTag() == null || StringUtil.isEmpty((String)(name = item.getName()))) continue;
            result.add(new DataBindingInfo.ViewWithId(DataBindingUtil.convertToJavaFieldName(name.trim()), psiResourceItem.getTag()));
        }
        return result;
    }

    @Override
    @Nullable
    public Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPsiResourceFile.getPsiFile());
    }

    @Override
    public long getModificationCount() {
        return this.myLayoutModificationCount + this.myBindingModificationCount;
    }

    @Override
    public boolean isMerged() {
        return false;
    }

    @Override
    @Nullable
    public DataBindingInfo getMergedInfo() {
        return this.myMergedInfo;
    }

    public String getConfigurationName() {
        return this.myConfigurationName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/res/LayoutDataBindingInfo", "getItems"));
    }
}

