/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.SampleDataResourceValue;
import com.android.ide.common.res2.SourcelessResourceItem;
import com.android.ide.common.resources.sampledata.SampleDataCsvParser;
import com.android.ide.common.resources.sampledata.SampleDataHolder;
import com.android.ide.common.resources.sampledata.SampleDataJsonParser;
import com.android.resources.ResourceType;
import com.android.tools.idea.sampledata.datasource.HardcodedContent;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.w3c.dom.Node;

public class SampleDataResourceItem
extends SourcelessResourceItem {
    private static final Logger LOG = Logger.getInstance(SampleDataResourceItem.class);
    private static final Splitter NAMESPACE_SPLITTER = Splitter.on((char)':').trimResults().omitEmptyStrings().limit(2);
    private static final Cache<String, SampleDataHolder> sSampleDataCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).softValues().weigher((key, value) -> value.getFileSizeMb()).maximumWeight(50L).build();
    private final Function<OutputStream, Exception> myDataSource;
    private final SmartPsiElementPointer<PsiElement> mySourceElement;
    private final Supplier<Long> myDataSourceModificationStamp;

    private SampleDataResourceItem(String name, String namespace, Function<OutputStream, Exception> dataSource, Supplier<Long> dataSourceModificationStamp, SmartPsiElementPointer<PsiElement> sourceElement) {
        super(name, namespace, ResourceType.SAMPLE_DATA, null, null);
        this.myDataSource = dataSource;
        this.myDataSourceModificationStamp = dataSourceModificationStamp;
        this.mySourceElement = sourceElement;
    }

    private SampleDataResourceItem(String name, Function<OutputStream, Exception> dataSource, Supplier<Long> dataSourceModificationStamp, SmartPsiElementPointer<PsiElement> sourceElement) {
        this(name, null, dataSource, dataSourceModificationStamp, sourceElement);
    }

    public static SampleDataResourceItem getFromStaticDataSource(String name, Function<OutputStream, Exception> source) {
        List sampleDataResource = NAMESPACE_SPLITTER.splitToList((CharSequence)name);
        return new SampleDataResourceItem(name, sampleDataResource.size() == 2 ? (String)sampleDataResource.get(0) : null, source, () -> 1L, null);
    }

    private static SampleDataResourceItem getFromPlainFile(SmartPsiElementPointer<PsiElement> filePointer) {
        VirtualFile vFile = filePointer.getVirtualFile();
        String fileName = vFile.getName();
        return new SampleDataResourceItem(fileName, output -> {
            PsiElement sourceElement = filePointer.getElement();
            if (sourceElement == null) {
                LOG.warn("File pointer was invalidated and the repository was not refreshed");
                return null;
            }
            try {
                output.write(sourceElement.getText().getBytes(Charsets.UTF_8));
            }
            catch (IOException e) {
                LOG.warn("Unable to load content from plain file " + fileName, (Throwable)e);
                return e;
            }
            return null;
        }, () -> vFile.getModificationStamp() + 1L, filePointer);
    }

    private static SampleDataResourceItem getFromDirectory(SmartPsiElementPointer<PsiElement> directoryPointer) {
        VirtualFile directory = directoryPointer.getVirtualFile();
        return new SampleDataResourceItem(directory.getName(), output -> {
            PrintStream printStream = new PrintStream((OutputStream)output);
            Arrays.stream(directory.getChildren()).filter(child -> !child.isDirectory()).sorted(Comparator.comparing(VirtualFile::getName)).forEach(file -> printStream.println(file.getPath()));
            return null;
        }, () -> directory.getModificationStamp() + 1L, directoryPointer);
    }

    private static SampleDataResourceItem getFromJsonFile(SmartPsiElementPointer<PsiElement> jsonPointer, String contentPath) {
        VirtualFile vFile = jsonPointer.getVirtualFile();
        String fileName = vFile.getName();
        return new SampleDataResourceItem(fileName + contentPath, output -> {
            if (contentPath.isEmpty()) {
                return null;
            }
            PsiElement source = jsonPointer.getElement();
            if (source == null) {
                LOG.warn("JSON file pointer was invalidated and the repository was not refreshed");
                return null;
            }
            try {
                InputStreamReader input = new InputStreamReader(new ByteArrayInputStream(source.getText().getBytes(Charsets.UTF_8)));
                SampleDataJsonParser parser = SampleDataJsonParser.parse((Reader)input);
                if (parser != null) {
                    output.write(parser.getContentFromPath(contentPath));
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to load content from json file " + fileName, (Throwable)e);
                return e;
            }
            return null;
        }, () -> vFile.getModificationStamp() + 1L, jsonPointer);
    }

    public static List<SampleDataResourceItem> getFromPsiFileSystemItem(PsiFileSystemItem sampleDataSource) throws IOException {
        String extension = sampleDataSource.getVirtualFile().getExtension();
        if (extension == null) {
            extension = "";
        }
        SmartPsiElementPointer psiPointer = SmartPointerManager.getInstance((Project)sampleDataSource.getProject()).createSmartPsiElementPointer((PsiElement)sampleDataSource);
        switch (extension) {
            case "json": {
                SampleDataJsonParser parser = null;
                try (FileReader reader = new FileReader(VfsUtilCore.virtualToIoFile((VirtualFile)psiPointer.getVirtualFile()));){
                    parser = SampleDataJsonParser.parse((Reader)reader);
                }
                if (parser == null) {
                    return Collections.emptyList();
                }
                Set possiblePaths = parser.getPossiblePaths();
                ImmutableList.Builder items = ImmutableList.builder();
                for (String path : possiblePaths) {
                    items.add((Object)SampleDataResourceItem.getFromJsonFile((SmartPsiElementPointer<PsiElement>)psiPointer, path));
                }
                return items.build();
            }
            case "csv": {
                SampleDataCsvParser parser = null;
                VirtualFile vFile = sampleDataSource.getVirtualFile();
                try (FileReader reader = new FileReader(VfsUtilCore.virtualToIoFile((VirtualFile)vFile));){
                    parser = SampleDataCsvParser.parse((Reader)reader);
                }
                Set possiblePaths = parser.getPossiblePaths();
                ImmutableList.Builder items = ImmutableList.builder();
                for (String path : possiblePaths) {
                    items.add((Object)new SampleDataResourceItem(sampleDataSource.getName() + path, new HardcodedContent(Joiner.on((char)'\n').join((Iterable)parser.getPossiblePaths())), () -> vFile.getModificationStamp() + 1L, (SmartPsiElementPointer<PsiElement>)psiPointer));
                }
                return items.build();
            }
        }
        return ImmutableList.of((Object)((Object)(sampleDataSource instanceof PsiDirectory ? SampleDataResourceItem.getFromDirectory((SmartPsiElementPointer<PsiElement>)psiPointer) : SampleDataResourceItem.getFromPlainFile((SmartPsiElementPointer<PsiElement>)psiPointer))));
    }

    public Node getValue() {
        throw new UnsupportedOperationException("SampleDataResourceItem does not support getValue");
    }

    private byte[] getContent(Runnable onCachedOutOfDate) {
        SampleDataHolder value = (SampleDataHolder)sSampleDataCache.getIfPresent((Object)this.getName());
        if (value == null || value.getLastModification() == 0L || value.getLastModification() != this.myDataSourceModificationStamp.get().longValue()) {
            long lastModificationStamp = this.myDataSourceModificationStamp.get();
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                Exception e = this.myDataSource.apply(output);
                if (e == null) {
                    byte[] content = output.toByteArray();
                    value = new SampleDataHolder(this.getName(), lastModificationStamp, content.length / 1000000, content);
                    sSampleDataCache.put((Object)this.getName(), (Object)value);
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            if (onCachedOutOfDate != null) {
                onCachedOutOfDate.run();
            }
        }
        return value != null ? value.getContents() : null;
    }

    public String getValueText() {
        byte[] content = this.getContent(null);
        return content != null ? new String(content, Charsets.UTF_8) : null;
    }

    public String getQualifiers() {
        return "";
    }

    public ResourceValue getResourceValue(boolean isFrameworks) {
        byte[] content = this.getContent(() -> ((SampleDataResourceItem)this).wasTouched());
        if (this.mResourceValue == null) {
            this.mResourceValue = new SampleDataResourceValue(this.getResourceUrl(isFrameworks), content);
        }
        return this.mResourceValue;
    }

    public PsiElement getPsiElement() {
        return this.mySourceElement != null ? this.mySourceElement.getElement() : null;
    }
}

