/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.resourceExplorer;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.resourceExplorer.ResourceExplorerEditor;
import com.android.tools.idea.resourceExplorer.ResourceExplorerFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/resourceExplorer/ResourceExplorerEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.android"})
public final class ResourceExplorerEditorProvider
implements FileEditorProvider {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object t = StudioFlags.RESOURCE_MANAGER_ENABLED.get();
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"StudioFlags.RESOURCE_MANAGER_ENABLED.get()");
        return (Boolean)t != false && file instanceof ResourceExplorerFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file instanceof ResourceExplorerFile) {
            AndroidFacet androidFacet = ((ResourceExplorerFile)file).getFacet();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"file.facet");
            return new ResourceExplorerEditor(androidFacet);
        }
        Logger.getInstance(this.getClass()).error("Resource Explorer can only accept instances of ResourceExplorerFile.\nFallback to a simple text editor");
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(project, file);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor, (String)"TextEditorProvider.getIn\u2026eateEditor(project, file)");
        return fileEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        return "Resource Explorer";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

