/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.run.AndroidLaunchTasksProviderFactory;
import com.android.tools.idea.run.AndroidRunConfigContext;
import com.android.tools.idea.run.AndroidRunState;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.GradleApplicationIdProvider;
import com.android.tools.idea.run.LaunchCompatibilityCheckerImpl;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.NonGradleApplicationIdProvider;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.ValidationUtil;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerState;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProviderFactory;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements PreferGradleMake {
    private static final Logger LOG = Logger.getInstance(AndroidRunConfigurationBase.class);
    private static final String GRADLE_SYNC_FAILED_ERR_MSG = "Gradle project sync failed. Please fix your project and try again.";
    private static final String PROFILERS_ELEMENT_NAME = "Profilers";
    private static final DialogWrapper.DoNotAskOption ourKillLaunchOption = new MyDoNotPromptOption();
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = false;
    public boolean SKIP_NOOP_APK_INSTALLATIONS = true;
    public boolean FORCE_STOP_RUNNING_APP = true;
    private final ProfilerState myProfilerState;
    private final boolean myAndroidTests;
    private final DeployTargetContext myDeployTargetContext = new DeployTargetContext();
    private final AndroidDebuggerContext myAndroidDebuggerContext = new AndroidDebuggerContext("Java");

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory, boolean androidTests) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
        this.myProfilerState = new ProfilerState();
        this.myAndroidTests = androidTests;
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors = this.validate(null);
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        switch (topError.getSeverity()) {
            case FATAL: {
                throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
            }
            case WARNING: {
                throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
            }
        }
    }

    public List<ValidationError> validate(@Nullable Executor executor) {
        AndroidFacet facet;
        ArrayList errors = Lists.newArrayList();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors.add(ValidationError.fromException(e));
        }
        Module module = configurationModule.getModule();
        if (module == null) {
            return errors;
        }
        Project project = module.getProject();
        if (AndroidProjectInfo.getInstance(project).requiredAndroidModelMissing()) {
            errors.add(ValidationError.fatal(GRADLE_SYNC_FAILED_ERR_MSG));
        }
        if ((facet = AndroidFacet.getInstance(module)) == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module.getName())));
        }
        if (!facet.isAppProject() && facet.getProjectType() != 2) {
            if (facet.isLibraryProject() || facet.getProjectType() == 5) {
                Pair<Boolean, String> result = this.supportsRunningLibraryProjects(facet);
                if (!((Boolean)result.getFirst()).booleanValue()) {
                    errors.add(ValidationError.fatal((String)result.getSecond()));
                }
            } else {
                errors.add(ValidationError.fatal(AndroidBundle.message("run.error.apk.not.valid", new Object[0])));
            }
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform() == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        if (facet.getManifest() == null && facet.getProjectType() != 4) {
            errors.add(ValidationError.fatal(AndroidBundle.message("android.manifest.not.found.error", new Object[0])));
        }
        errors.addAll(this.getDeployTargetContext().getCurrentDeployTargetState().validate(facet));
        errors.addAll(this.getApkProvider(facet, this.getApplicationIdProvider(facet)).validate());
        errors.addAll(this.checkConfiguration(facet));
        Object androidDebuggerState = this.myAndroidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            errors.addAll(((AndroidDebuggerState)androidDebuggerState).validate(facet, executor));
        }
        errors.addAll(this.myProfilerState.validate());
        return errors;
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract List<ValidationError> checkConfiguration(@NotNull AndroidFacet var1);

    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        LaunchOptions.Builder builder = LaunchOptions.builder().setClearLogcatBeforeStart(this.CLEAR_LOGCAT).setSkipNoopApkInstallations(this.SKIP_NOOP_APK_INSTALLATIONS).setForceStopRunningApp(this.FORCE_STOP_RUNNING_APP);
        if (builder == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(0);
        }
        return builder;
    }

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance(module) == null) continue;
            result.add(module);
        }
        return result;
    }

    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        ArrayList targets = Lists.newArrayList();
        for (DeployTargetProvider target : this.getDeployTargetContext().getDeployTargetProviders()) {
            if (!target.isApplicable(this.myAndroidTests)) continue;
            targets.add(target);
        }
        ArrayList arrayList = targets;
        if (arrayList == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected void validateBeforeRun(@NotNull Executor executor) throws ExecutionException {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(2);
        }
        List<ValidationError> errors = this.validate(executor);
        ValidationUtil.promptAndQuickFixErrors(this.getProject(), errors);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        String error;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(3);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(4);
        }
        this.validateBeforeRun(executor);
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module != null) : "Enforced by fatal validation check in checkConfiguration.";
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : "Enforced by fatal validation check in checkConfiguration.";
        Project project = env.getProject();
        boolean forceColdswap = !InstantRunUtils.isInvokedViaHotswapAction(env);
        boolean instantRunEnabled = false;
        AndroidSessionInfo existingSessionInfo = AndroidSessionInfo.findOldSession(project, null, this.getUniqueID());
        boolean couldHaveHotswapped = false;
        DeviceFutures deviceFutures = null;
        boolean isDebugging = executor instanceof DefaultDebugExecutor;
        if (forceColdswap) {
            DeployTarget deployTarget = this.getDeployTarget(executor, env, isDebugging, facet);
            if (deployTarget == null) {
                return null;
            }
            DeployTargetState deployTargetState = this.getDeployTargetContext().getCurrentDeployTargetState();
            if (deployTarget.hasCustomRunProfileState(executor)) {
                return deployTarget.getRunProfileState(executor, env, deployTargetState);
            }
            deviceFutures = deployTarget.getDevices(deployTargetState, facet, this.getDeviceCount(isDebugging), isDebugging, this.getUniqueID());
            if (deviceFutures == null) {
                return null;
            }
        }
        if (deviceFutures == null || deviceFutures.get().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        if (isDebugging && (error = AndroidRunConfigurationBase.canDebug(deviceFutures, facet, module.getName())) != null) {
            throw new ExecutionException(error);
        }
        ProcessHandler processHandler = null;
        if (existingSessionInfo != null && existingSessionInfo.getExecutorId().equals(executor.getId())) {
            processHandler = existingSessionInfo.getProcessHandler();
        }
        env.putCopyableUserData(AndroidRunConfigContext.KEY, (Object)this.createAndroidRunConfigContext(executor, forceColdswap, existingSessionInfo, couldHaveHotswapped, deviceFutures));
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider(facet);
        LaunchTasksProviderFactory providerFactory = this.createLaunchTasksProviderFactory(env, facet, deviceFutures, applicationIdProvider, processHandler, isDebugging);
        return new AndroidRunState(env, this.getName(), module, applicationIdProvider, this.getConsoleProvider(), deviceFutures, providerFactory, processHandler);
    }

    @NotNull
    private LaunchTasksProviderFactory createLaunchTasksProviderFactory(@NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet, @NotNull DeviceFutures deviceFutures, @NotNull ApplicationIdProvider applicationIdProvider, @Nullable ProcessHandler processHandler, boolean isDebugging) {
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(5);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(6);
        }
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(7);
        }
        if (applicationIdProvider == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(8);
        }
        LaunchOptions launchOptions = this.getLaunchOptions().setDebug(isDebugging).build();
        AndroidLaunchTasksProviderFactory androidLaunchTasksProviderFactory = new AndroidLaunchTasksProviderFactory(this, env, facet, applicationIdProvider, this.getApkProvider(facet, applicationIdProvider), deviceFutures, launchOptions, processHandler);
        if (androidLaunchTasksProviderFactory == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(9);
        }
        return androidLaunchTasksProviderFactory;
    }

    @NotNull
    private AndroidRunConfigContext createAndroidRunConfigContext(@NotNull Executor executor, boolean forceColdswap, @Nullable AndroidSessionInfo existingSessionInfo, boolean couldHaveHotswapped, @NotNull DeviceFutures deviceFutures) {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(10);
        }
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(11);
        }
        AndroidRunConfigContext runConfigContext = new AndroidRunConfigContext();
        runConfigContext.setTargetDevices(deviceFutures);
        runConfigContext.setSameExecutorAsPreviousSession(this.isSameExecutorAsPreviousSession(executor, existingSessionInfo));
        runConfigContext.setForceColdSwap(forceColdswap, couldHaveHotswapped);
        AndroidRunConfigContext androidRunConfigContext = runConfigContext;
        if (androidRunConfigContext == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(12);
        }
        return androidRunConfigContext;
    }

    @Nullable
    PrepareSessionResult prepareInstantRunSession(@NotNull AndroidSessionInfo info, @NotNull Executor executor, @NotNull AndroidFacet facet, @NotNull Project project, @Nullable DeviceFutures chosenDeviceFutues, boolean forceColdswap) {
        if (info == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(13);
        }
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(14);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(15);
        }
        if (project == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(16);
        }
        DeviceFutures sessionDeviceFutures = AndroidRunConfigurationBase.getFastDeployDevices(executor, AndroidModuleModel.get(facet), info);
        boolean couldHaveHotswapped = false;
        if (sessionDeviceFutures == null && !forceColdswap) {
            if (!this.promptAndKillSession(executor, project, info)) {
                return null;
            }
        } else if (sessionDeviceFutures != null && sessionDeviceFutures.allMatch(chosenDeviceFutues)) {
            couldHaveHotswapped = true;
            AndroidRunConfigurationBase.killSession(info);
        }
        return new PrepareSessionResult(sessionDeviceFutures, couldHaveHotswapped);
    }

    private boolean promptInstallTargetPlatform(@NotNull Project project, @NotNull DeviceFutures deviceFutures) {
        if (project == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(17);
        }
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(18);
        }
        AndroidVersion version = deviceFutures.getDevices().get(0).getVersion();
        String message = AndroidBundle.message("instant.run.quickfix.missing.platform", SdkVersionInfo.getVersionWithCodename((AndroidVersion)version));
        int result = Messages.showYesNoDialog((Project)project, (String)message, (String)"Instant Run", (String)"Install and Continue", (String)"Proceed without Instant Run", (Icon)Messages.getQuestionIcon());
        if (result == 0) {
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)DetailsTypes.getPlatformPath((AndroidVersion)version)));
            if (dialog == null) {
                LOG.warn("Unable to get quick fix wizard to install missing platform required for instant run.");
            } else if (dialog.showAndGet()) {
                return true;
            }
        }
        return false;
    }

    private boolean isSameExecutorAsPreviousSession(@NotNull Executor executor, @Nullable AndroidSessionInfo info) {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(19);
        }
        return info != null && executor.getId().equals(info.getExecutorId());
    }

    private static void killSession(@NotNull AndroidSessionInfo info) {
        if (info == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(20);
        }
        info.getProcessHandler().destroyProcess();
    }

    @Nullable
    protected static DeviceFutures getFastDeployDevices(@NotNull Executor executor, @Nullable AndroidModuleModel model, @NotNull AndroidSessionInfo info) {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(21);
        }
        if (info == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(22);
        }
        return null;
    }

    private static String canDebug(@NotNull DeviceFutures deviceFutures, @NotNull AndroidFacet facet, @NotNull String moduleName) {
        if (deviceFutures == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(23);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(24);
        }
        if (moduleName == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(25);
        }
        for (ListenableFuture<IDevice> future : deviceFutures.get()) {
            IDevice device;
            if (!future.isDone() || LaunchUtils.canDebugAppOnDevice(facet, device = (IDevice)Futures.getUnchecked(future))) continue;
            return AndroidBundle.message("android.cannot.debug.noDebugPermissions", moduleName, device.getName());
        }
        return null;
    }

    @Nullable
    private DeployTarget getDeployTarget(@NotNull Executor executor, @NotNull ExecutionEnvironment env, boolean debug, @NotNull AndroidFacet facet) {
        DeployTarget deployTarget;
        DeployTargetProvider currentTargetProvider;
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(26);
        }
        if (env == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(27);
        }
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(28);
        }
        if ((currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider()).requiresRuntimePrompt()) {
            deployTarget = currentTargetProvider.showPrompt(executor, env, facet, this.getDeviceCount(debug), this.myAndroidTests, this.getDeployTargetContext().getDeployTargetStates(), this.getUniqueID(), LaunchCompatibilityCheckerImpl.create(facet));
            if (deployTarget == null) {
                return null;
            }
        } else {
            deployTarget = currentTargetProvider.getDeployTarget();
        }
        return deployTarget;
    }

    private boolean promptAndKillSession(@NotNull Executor executor, @NotNull Project project, @NotNull AndroidSessionInfo info) {
        if (executor == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(29);
        }
        if (project == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(30);
        }
        if (info == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(31);
        }
        String previousExecutorId = info.getExecutorId();
        String currentExecutorId = executor.getId();
        if (ourKillLaunchOption.isToBeShown()) {
            String noText;
            String msg;
            if (previousExecutorId.equals(currentExecutorId)) {
                msg = "Restart App?\nThe app is already running. Would you like to kill it and restart the session?";
                noText = "Cancel";
            } else {
                String previousExecutorActionName = info.getExecutorActionName();
                String currentExecutorActionName = executor.getActionName();
                msg = String.format("To switch from %1$s to %2$s, the app has to restart. Continue?", previousExecutorActionName, currentExecutorActionName);
                noText = "Cancel " + currentExecutorActionName;
            }
            String title = "Launching " + this.getName();
            String yesText = "Restart " + this.getName();
            if (1 == Messages.showYesNoDialog((Project)project, (String)msg, (String)title, (String)yesText, (String)noText, (Icon)AllIcons.General.QuestionDialog, (DialogWrapper.DoNotAskOption)ourKillLaunchOption)) {
                return false;
            }
        }
        LOG.info("Disconnecting existing session of the same launch configuration");
        AndroidRunConfigurationBase.killSession(info);
        return true;
    }

    @NotNull
    protected ApplicationIdProvider getApplicationIdProvider(@NotNull AndroidFacet facet) {
        if (facet == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(32);
        }
        if (facet.getAndroidModel() != null && facet.getAndroidModel() instanceof AndroidModuleModel) {
            GradleApplicationIdProvider gradleApplicationIdProvider = new GradleApplicationIdProvider();
            if (gradleApplicationIdProvider == null) {
                AndroidRunConfigurationBase.$$$reportNull$$$0(33);
            }
            return gradleApplicationIdProvider;
        }
        NonGradleApplicationIdProvider nonGradleApplicationIdProvider = new NonGradleApplicationIdProvider(facet);
        if (nonGradleApplicationIdProvider == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(34);
        }
        return nonGradleApplicationIdProvider;
    }

    @NotNull
    protected abstract ApkProvider getApkProvider(@NotNull AndroidFacet var1, @NotNull ApplicationIdProvider var2);

    @NotNull
    protected abstract ConsoleProvider getConsoleProvider();

    @Nullable
    protected abstract LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider var1, @NotNull AndroidFacet var2, boolean var3, @NotNull LaunchStatus var4);

    public boolean monitorRemoteProcess() {
        return true;
    }

    @NotNull
    public final DeviceCount getDeviceCount(boolean debug) {
        DeviceCount deviceCount = DeviceCount.fromBoolean(this.supportMultipleDevices() && !debug);
        if (deviceCount == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(35);
        }
        return deviceCount;
    }

    protected abstract boolean supportMultipleDevices();

    public boolean supportsInstantRun() {
        return false;
    }

    public int getUserIdFromAmParameters() {
        return 0;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(36);
        }
        super.readExternal(element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.myDeployTargetContext.readExternal(element);
        this.myAndroidDebuggerContext.readExternal(element);
        Element profilersElement = element.getChild(PROFILERS_ELEMENT_NAME);
        if (profilersElement != null) {
            this.myProfilerState.readExternal(profilersElement);
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(37);
        }
        super.writeExternal(element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        this.myDeployTargetContext.writeExternal(element);
        this.myAndroidDebuggerContext.writeExternal(element);
        Element profilersElement = new Element(PROFILERS_ELEMENT_NAME);
        element.addContent(profilersElement);
        this.myProfilerState.writeExternal(profilersElement);
    }

    @NotNull
    public DeployTargetContext getDeployTargetContext() {
        DeployTargetContext deployTargetContext = this.myDeployTargetContext;
        if (deployTargetContext == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(38);
        }
        return deployTargetContext;
    }

    @NotNull
    public AndroidDebuggerContext getAndroidDebuggerContext() {
        AndroidDebuggerContext androidDebuggerContext = this.myAndroidDebuggerContext;
        if (androidDebuggerContext == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(39);
        }
        return androidDebuggerContext;
    }

    @NotNull
    public ProfilerState getProfilerState() {
        ProfilerState profilerState = this.myProfilerState;
        if (profilerState == null) {
            AndroidRunConfigurationBase.$$$reportNull$$$0(40);
        }
        return profilerState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/AndroidRunConfigurationBase";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 14: 
            case 19: 
            case 21: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 5: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 15: 
            case 24: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 7: 
            case 11: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceFutures";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIdProvider";
                break;
            }
            case 13: 
            case 20: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: 
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchOptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableDeployTargetProviders";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/AndroidRunConfigurationBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLaunchTasksProviderFactory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndroidRunConfigContext";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationIdProvider";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceCount";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployTargetContext";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidDebuggerContext";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilerState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "validateBeforeRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLaunchTasksProviderFactory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAndroidRunConfigContext";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "prepareInstantRunSession";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "promptInstallTargetPlatform";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSameExecutorAsPreviousSession";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "killSession";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFastDeployDevices";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "canDebug";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getDeployTarget";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "promptAndKillSession";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getApplicationIdProvider";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class PrepareSessionResult {
        DeviceFutures futures;
        boolean couldHaveHotswapped;

        PrepareSessionResult(DeviceFutures futures, boolean couldHaveHotswapped) {
            this.futures = futures;
            this.couldHaveHotswapped = couldHaveHotswapped;
        }
    }

    private static class MyDoNotPromptOption
    implements DialogWrapper.DoNotAskOption {
        public static final String PROMPT_KEY = "android.show.prompt.kill.session";
        private boolean myShow = PropertiesComponent.getInstance().getBoolean("android.show.prompt.kill.session", false);

        private MyDoNotPromptOption() {
        }

        public boolean isToBeShown() {
            return !this.myShow;
        }

        public void setToBeShown(boolean toBeShown, int exitCode) {
            this.myShow = !toBeShown;
            PropertiesComponent.getInstance().setValue(PROMPT_KEY, this.myShow);
        }

        public boolean canBeHidden() {
            return true;
        }

        public boolean shouldSaveOptionsOnCancel() {
            return true;
        }

        @NotNull
        public String getDoNotShowMessage() {
            if ("Do not ask again" == null) {
                MyDoNotPromptOption.$$$reportNull$$$0(0);
            }
            return "Do not ask again";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/AndroidRunConfigurationBase$MyDoNotPromptOption", "getDoNotShowMessage"));
        }
    }
}

