/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceFutures {
    @NotNull
    private final List<AndroidDevice> myDevices;

    public DeviceFutures(@NotNull List<AndroidDevice> devices) {
        if (devices == null) {
            DeviceFutures.$$$reportNull$$$0(0);
        }
        this.myDevices = devices;
    }

    @NotNull
    public List<ListenableFuture<IDevice>> get() {
        ImmutableList.Builder futures = ImmutableList.builder();
        for (AndroidDevice device : this.myDevices) {
            futures.add(device.getLaunchedDevice());
        }
        ImmutableList immutableList = futures.build();
        if (immutableList == null) {
            DeviceFutures.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @Nullable
    public List<IDevice> getIfReady() {
        List<ListenableFuture<IDevice>> devices = this.get();
        for (ListenableFuture<IDevice> deviceFuture : devices) {
            if (deviceFuture.isDone() && !deviceFuture.isCancelled()) continue;
            return null;
        }
        try {
            return (List)Futures.getChecked((Future)Futures.allAsList(devices), ExecutionException.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    @NotNull
    public List<AndroidDevice> getDevices() {
        List<AndroidDevice> list = this.myDevices;
        if (list == null) {
            DeviceFutures.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static DeviceFutures forDevices(@NotNull Iterable<IDevice> devices) {
        if (devices == null) {
            DeviceFutures.$$$reportNull$$$0(3);
        }
        ImmutableList.Builder futures = ImmutableList.builder();
        for (IDevice device : devices) {
            futures.add((Object)new ConnectedAndroidDevice(device, null));
        }
        DeviceFutures deviceFutures = new DeviceFutures((List<AndroidDevice>)futures.build());
        if (deviceFutures == null) {
            DeviceFutures.$$$reportNull$$$0(4);
        }
        return deviceFutures;
    }

    public boolean allMatch(@Nullable DeviceFutures other) {
        if (other == null) {
            return false;
        }
        return this.getDevices().stream().allMatch((? super T device) -> other.getDevices().stream().anyMatch(selectedDevice -> selectedDevice.getSerial().equals(device.getSerial())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/DeviceFutures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/DeviceFutures";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevices";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forDevices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forDevices";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

