/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.FullApkInstaller;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DeployApkTask
implements LaunchTask {
    private static final Logger LOG = Logger.getInstance(DeployApkTask.class);
    private final Project myProject;
    private final Collection<ApkInfo> myApks;
    private final LaunchOptions myLaunchOptions;

    public DeployApkTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @NotNull Collection<ApkInfo> apks) {
        if (project == null) {
            DeployApkTask.$$$reportNull$$$0(0);
        }
        if (launchOptions == null) {
            DeployApkTask.$$$reportNull$$$0(1);
        }
        if (apks == null) {
            DeployApkTask.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myLaunchOptions = launchOptions;
        this.myApks = apks;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Installing APK" == null) {
            DeployApkTask.$$$reportNull$$$0(3);
        }
        return "Installing APK";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            DeployApkTask.$$$reportNull$$$0(4);
        }
        if (launchStatus == null) {
            DeployApkTask.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            DeployApkTask.$$$reportNull$$$0(6);
        }
        FullApkInstaller installer = new FullApkInstaller(this.myProject, this.myLaunchOptions, (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), printer);
        for (ApkInfo apk : this.myApks) {
            if (!apk.getFile().exists()) {
                String message = "The APK file " + apk.getFile().getPath() + " does not exist on disk.";
                printer.stderr(message);
                LOG.warn(message);
                return false;
            }
            String pkgName = apk.getApplicationId();
            if (installer.uploadAndInstallApk(device, pkgName, apk.getFile(), launchStatus)) continue;
            return false;
        }
        DeployApkTask.trackInstallation(device);
        return true;
    }

    private static void trackInstallation(@NotNull IDevice device) {
        if (device == null) {
            DeployApkTask.$$$reportNull$$$0(7);
        }
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.DEPLOYMENT_APK).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(device)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchOptions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "apks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/DeployApkTask";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/DeployApkTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "trackInstallation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

