/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import java.io.OutputStream;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalUnit;
import java.util.Random;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DateTimeGenerator
implements Function<OutputStream, Exception> {
    private final long myNow;
    private final DateTimeFormatter myFormat;
    private final TemporalUnit myIncrements;
    private final int myIncrementStep;

    public DateTimeGenerator(@NotNull DateTimeFormatter format, int incrementStep, @NotNull TemporalUnit increments) {
        if (format == null) {
            DateTimeGenerator.$$$reportNull$$$0(0);
        }
        if (increments == null) {
            DateTimeGenerator.$$$reportNull$$$0(1);
        }
        this.myNow = System.currentTimeMillis();
        this.myFormat = format;
        this.myIncrementStep = incrementStep;
        this.myIncrements = increments;
    }

    public DateTimeGenerator(@NotNull DateTimeFormatter format, @NotNull TemporalUnit increments) {
        if (format == null) {
            DateTimeGenerator.$$$reportNull$$$0(2);
        }
        if (increments == null) {
            DateTimeGenerator.$$$reportNull$$$0(3);
        }
        this(format, 1, increments);
    }

    @Override
    public Exception apply(OutputStream stream) {
        PrintStream printStream = new PrintStream(stream);
        Random random = new Random();
        long amount = random.nextInt(200) * this.myIncrementStep;
        LocalDateTime time = LocalDateTime.now().minus(amount, this.myIncrements);
        for (int i = 0; i < 500; ++i) {
            printStream.println(time.format(this.myFormat));
            time = time.plus(random.nextInt(10) * this.myIncrementStep, this.myIncrements);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "format";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "increments";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/sampledata/datasource/DateTimeGenerator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

