/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.SdkPaths;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectSdkDialog
extends DialogWrapper {
    private JPanel myPanel;
    private TextFieldWithBrowseButton myJdkTextFieldWithButton;
    private TextFieldWithBrowseButton mySdkTextFieldWithButton;
    private JBLabel mySelectSdkDescriptionLabel;
    private HyperlinkLabel mySdkHyperlinkLabel;
    private JBLabel mySelectSdkLabel;
    private JBLabel mySelectJdkDescriptionLabel;
    private HyperlinkLabel myJdkHyperlinkLabel;
    private JBLabel mySelectJdkLabel;
    private JBLabel mySpacer;
    private String myJdkHome = "";
    private String mySdkHome = "";

    public SelectSdkDialog(@Nullable String jdkPath, @Nullable String sdkPath) {
        super(false);
        String err;
        this.$$$setupUI$$$();
        this.init();
        this.setTitle("Select SDKs");
        if (jdkPath != null && (err = SelectSdkDialog.validateJdkPath(jdkPath)) != null) {
            jdkPath = null;
        }
        if (sdkPath != null && (err = SelectSdkDialog.validateAndroidSdkPath(sdkPath)) != null) {
            sdkPath = null;
        }
        this.mySelectJdkLabel.setLabelFor((Component)this.myJdkTextFieldWithButton.getTextField());
        this.mySelectSdkDescriptionLabel.setText("Please provide the path to the Android SDK.");
        this.mySdkHyperlinkLabel.setHyperlinkTarget("http://d.android.com/sdk");
        this.mySdkHyperlinkLabel.setHyperlinkText("If you do not have the Android SDK, you can obtain it from ", "d.android.com/sdk", ".");
        this.mySelectJdkDescriptionLabel.setText("Please provide the path to a Java Development Kit (JDK) installation.");
        this.myJdkHyperlinkLabel.setHyperlinkTarget("http://www.oracle.com/technetwork/java/javase/downloads/index.html");
        this.myJdkHyperlinkLabel.setHyperlinkText("If you do not have a JDK installed, you can obtain one ", "here", ".");
        if (jdkPath == null && sdkPath == null) {
            this.mySpacer.setVisible(true);
        } else if (jdkPath == null) {
            this.mySpacer.setVisible(false);
            this.mySelectSdkDescriptionLabel.setVisible(false);
            this.mySdkHyperlinkLabel.setVisible(false);
            this.mySelectSdkLabel.setVisible(false);
            this.mySdkTextFieldWithButton.setVisible(false);
        } else {
            this.mySpacer.setVisible(false);
            this.mySelectJdkDescriptionLabel.setVisible(false);
            this.myJdkHyperlinkLabel.setVisible(false);
            this.mySelectJdkLabel.setVisible(false);
            this.myJdkTextFieldWithButton.setVisible(false);
        }
        this.myJdkTextFieldWithButton.setTextFieldPreferredWidth(50);
        this.mySdkTextFieldWithButton.setTextFieldPreferredWidth(50);
        if (jdkPath != null) {
            this.myJdkTextFieldWithButton.setText(jdkPath);
        }
        if (sdkPath != null) {
            this.mySdkTextFieldWithButton.setText(sdkPath);
        }
        FileChooserDescriptor descriptor = JavaSdk.getInstance().getHomeChooserDescriptor();
        BrowseFolderListener listener = new BrowseFolderListener("Select JDK Home", (ComponentWithBrowseButton<JTextField>)this.myJdkTextFieldWithButton, descriptor, jdkPath);
        this.myJdkTextFieldWithButton.addActionListener((ActionListener)((Object)listener));
        descriptor = AndroidSdkType.getInstance().getHomeChooserDescriptor();
        listener = new BrowseFolderListener("Select Android SDK Home", (ComponentWithBrowseButton<JTextField>)this.mySdkTextFieldWithButton, descriptor, sdkPath);
        this.mySdkTextFieldWithButton.addActionListener((ActionListener)((Object)listener));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String jdkHome = this.myJdkTextFieldWithButton.getText().trim();
        String jdkError = SelectSdkDialog.validateJdkPath(jdkHome);
        if (jdkError != null) {
            return new ValidationInfo(jdkError, (JComponent)this.myJdkTextFieldWithButton.getTextField());
        }
        String androidHome = this.mySdkTextFieldWithButton.getText().trim();
        String sdkError = SelectSdkDialog.validateAndroidSdkPath(androidHome);
        if (sdkError != null) {
            return new ValidationInfo(sdkError, (JComponent)this.mySdkTextFieldWithButton.getTextField());
        }
        return null;
    }

    @Nullable
    private static String validateJdkPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path) || !JavaSdk.getInstance().isValidSdkHome(path)) {
            return "Invalid JDK path.";
        }
        return null;
    }

    @Nullable
    private static String validateAndroidSdkPath(@Nullable String path) {
        if (StringUtil.isEmpty((String)path)) {
            return "Android SDK path not specified.";
        }
        SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(FilePaths.toSystemDependentPath((String)path), false);
        if (!validationResult.success) {
            return String.format("Invalid Android SDK path:<br>%1$s", validationResult.message);
        }
        return null;
    }

    protected void doOKAction() {
        this.myJdkHome = this.myJdkTextFieldWithButton.getText();
        this.mySdkHome = this.mySdkTextFieldWithButton.getText();
        super.doOKAction();
    }

    @NotNull
    public String getJdkHome() {
        String string = this.myJdkHome;
        if (string == null) {
            SelectSdkDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getAndroidHome() {
        String string = this.mySdkHome;
        if (string == null) {
            SelectSdkDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/sdk/SelectSdkDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkHome";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidHome";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        HyperlinkLabel hyperlinkLabel;
        JBLabel jBLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel3;
        HyperlinkLabel hyperlinkLabel2;
        JBLabel jBLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBLabel jBLabel5;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySelectSdkLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Select Android SDK:");
        jPanel.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.mySdkTextFieldWithButton = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, new Dimension(300, -1), null, null));
        this.mySelectSdkDescriptionLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.mySdkHyperlinkLabel = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel2, new GridConstraints(1, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.mySelectJdkLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Select Java JDK:");
        jPanel.add((Component)jBLabel3, new GridConstraints(6, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myJdkTextFieldWithButton = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(6, 1, 1, 1, 0, 1, 6, 0, new Dimension(300, -1), null, null));
        this.mySelectJdkDescriptionLabel = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myJdkHyperlinkLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(5, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.mySpacer = jBLabel = new JBLabel();
        jBLabel.setText(" ");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class BrowseFolderListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> {
        private final String myDefaultPath;

        BrowseFolderListener(@Nullable String title, ComponentWithBrowseButton<JTextField> textField2, FileChooserDescriptor fileChooserDescriptor, @Nullable String defaultPath) {
            super(title, null, textField2, null, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
            this.myDefaultPath = defaultPath;
        }

        @Nullable
        protected VirtualFile getInitialFile() {
            String dir = super.getComponentText();
            if (!dir.isEmpty()) {
                return super.getInitialFile();
            }
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            return fileSystem.findFileByPath(FileUtil.toSystemIndependentName((String)(this.myDefaultPath == null ? PathManager.getHomePath() : this.myDefaultPath)));
        }
    }
}

