/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services.view;

import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.SelectedProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.structure.EditorPanel;
import com.android.tools.idea.structure.services.DeveloperService;
import com.android.tools.idea.structure.services.DeveloperServiceMetadata;
import com.android.tools.idea.structure.services.ServiceContext;
import com.android.utils.HtmlBuilder;
import com.google.common.base.Joiner;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public final class DeveloperServicePanel
extends EditorPanel {
    public static final String DELETE_SERVICE_TITLE = "Confirm Uninstall Service";
    public static final String DELETE_SERVICE_MESSAGE = "You are about to uninstall the %1$s service. This will remove the following dependencies:\n\n%2$s\n\nThis may cause compile errors that you'll have to fix manually. Continue?";
    private JPanel myRootPanel;
    private JLabel myHeaderLabel;
    private JPanel myDetailsPanel;
    private JLabel myIcon;
    private JPanel myLinksPanel;
    private JPanel mySummaryPanel;
    private JPanel myOverviewPanel;
    private JCheckBox myEnabledCheckbox;
    private JPanel myCheckboxBorder;
    @NotNull
    private DeveloperService myService;
    @NotNull
    private BindingsManager myBindings;

    public DeveloperServicePanel(@NotNull DeveloperService service) {
        if (service == null) {
            DeveloperServicePanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myBindings = new BindingsManager();
        this.myService = service;
        ServiceContext context = service.getContext();
        DeveloperServiceMetadata developerServiceMetadata = service.getMetadata();
        this.initializeHeaderPanel(developerServiceMetadata);
        this.myDetailsPanel.add(service.getPanel());
        this.initializeFooterPanel(developerServiceMetadata);
        final SelectedProperty enabledCheckboxSelected = new SelectedProperty(this.myEnabledCheckbox);
        this.myBindings.bind(new VisibleProperty(this.myDetailsPanel), enabledCheckboxSelected.and(BooleanExpressions.not(context.installed())));
        this.myBindings.bind(enabledCheckboxSelected, context.installed().or(context.modified()));
        this.myEnabledCheckbox.setName("enableService");
        enabledCheckboxSelected.addListener(new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                if (sender == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (enabledCheckboxSelected.get().booleanValue()) {
                    if (!DeveloperServicePanel.this.myService.getContext().installed().get().booleanValue()) {
                        DeveloperServicePanel.this.myService.getContext().beginEditing();
                    }
                } else if (DeveloperServicePanel.this.myService.getContext().installed().get().booleanValue()) {
                    String message = String.format(DeveloperServicePanel.DELETE_SERVICE_MESSAGE, DeveloperServicePanel.this.myService.getMetadata().getName(), Joiner.on((char)'\n').join(DeveloperServicePanel.this.myService.getMetadata().getDependencies()));
                    int answer = Messages.showYesNoDialog((Project)DeveloperServicePanel.this.myService.getModule().getProject(), (String)message, (String)DeveloperServicePanel.DELETE_SERVICE_TITLE, null);
                    if (answer == 0) {
                        DeveloperServicePanel.this.myService.uninstall();
                    } else {
                        enabledCheckboxSelected.set(true);
                    }
                } else {
                    DeveloperServicePanel.this.myService.getContext().cancelEditing();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/structure/services/view/DeveloperServicePanel$1", "onInvalidated"));
            }
        });
        this.add(this.myRootPanel);
    }

    private void initializeHeaderPanel(@NotNull DeveloperServiceMetadata developerServiceMetadata) {
        URI apiLink;
        if (developerServiceMetadata == null) {
            DeveloperServicePanel.$$$reportNull$$$0(1);
        }
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        htmlBuilder.openHtmlBody();
        htmlBuilder.addBold(developerServiceMetadata.getName()).newline();
        htmlBuilder.add(developerServiceMetadata.getDescription());
        htmlBuilder.closeHtmlBody();
        this.myHeaderLabel.setText(htmlBuilder.getHtml());
        this.myIcon.setIcon(IconUtil.toSize((Icon)developerServiceMetadata.getIcon(), (int)this.myIcon.getWidth(), (int)this.myIcon.getHeight()));
        URI learnMoreLink = developerServiceMetadata.getLearnMoreLink();
        if (learnMoreLink != null) {
            this.addToLinkPanel("Learn More", learnMoreLink);
        }
        if ((apiLink = developerServiceMetadata.getApiLink()) != null) {
            this.addToLinkPanel("API Documentation", apiLink);
        }
    }

    private void initializeFooterPanel(@NotNull DeveloperServiceMetadata developerServiceMetadata) {
        List<String> modifiedFiles;
        List<String> permissions;
        if (developerServiceMetadata == null) {
            DeveloperServicePanel.$$$reportNull$$$0(2);
        }
        boolean panelHasContent = false;
        JPanel verticalFlowPanel = new JPanel();
        verticalFlowPanel.setLayout(new BoxLayout(verticalFlowPanel, 3));
        verticalFlowPanel.add(Box.createRigidArea(new Dimension(0, JBUI.scale((int)30))));
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        htmlBuilder.openHtmlBody();
        htmlBuilder.add("Enabling this service will...");
        htmlBuilder.beginList();
        List<String> dependencies = developerServiceMetadata.getDependencies();
        if (!dependencies.isEmpty()) {
            htmlBuilder.listItem().add("Add dependencies: ").addItalic(Joiner.on((String)", ").join(dependencies));
            panelHasContent = true;
        }
        if (!(permissions = developerServiceMetadata.getPermissions()).isEmpty()) {
            htmlBuilder.listItem().add("Add permissions: ").addItalic(Joiner.on((String)", ").join(permissions));
            panelHasContent = true;
        }
        if (!(modifiedFiles = developerServiceMetadata.getModifiedFiles()).isEmpty()) {
            htmlBuilder.listItem().add("Create/modify files: ").addItalic(Joiner.on((String)", ").join(modifiedFiles));
            panelHasContent = true;
        }
        htmlBuilder.endList();
        htmlBuilder.closeHtmlBody();
        if (panelHasContent) {
            verticalFlowPanel.add(new JLabel(htmlBuilder.getHtml()));
            this.mySummaryPanel.add(verticalFlowPanel);
        }
    }

    private void addToLinkPanel(@NotNull String text, final @NotNull URI uri) {
        if (text == null) {
            DeveloperServicePanel.$$$reportNull$$$0(3);
        }
        if (uri == null) {
            DeveloperServicePanel.$$$reportNull$$$0(4);
        }
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(text);
        hyperlinkLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                try {
                    Desktop.getDesktop().browse(uri);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        if (this.myLinksPanel.getComponentCount() > 0) {
            this.myLinksPanel.add(Box.createRigidArea(new Dimension(JBUI.scale((int)10), 0)));
        }
        this.myLinksPanel.add((Component)hyperlinkLabel);
    }

    @Override
    public void apply() {
        this.myService.getContext().finishEditing();
        if (!this.isModified()) {
            return;
        }
        this.myService.install();
    }

    @Override
    public boolean isModified() {
        return (Boolean)this.myService.getContext().modified().get();
    }

    public void dispose() {
        this.myDetailsPanel.removeAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "developerServiceMetadata";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/structure/services/view/DeveloperServicePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeHeaderPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initializeFooterPanel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addToLinkPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JLabel jLabel;
        JPanel jPanel5;
        JLabel jLabel2;
        JPanel jPanel6;
        this.myRootPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel6).setEnabled(true);
        this.myIcon = jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(0);
        jLabel2.setText("");
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 1, 2, 1, 9, 0, 0, 0, new Dimension(64, 64), new Dimension(64, 64), new Dimension(64, 64)));
        this.myOverviewPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 2, 2, 1, 0, 3, 3, 0, null, null, null));
        this.myHeaderLabel = jLabel = new JLabel();
        jLabel.setText("<html><b>NAME</b><br>DESCRIPTION</html>");
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLinksPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 9, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 5), null));
        this.myDetailsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel3).setVisible(false);
        jPanel6.add((Component)jPanel3, new GridConstraints(2, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySummaryPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel2, new GridConstraints(3, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCheckboxBorder = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(20, 20, 20, 20), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 2, 1, 0, 3, 1, 1, null, null, null));
        this.myEnabledCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

