/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.android.tools.idea.ui.GuiTestingStatusProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class GuiTestingService {
    public static Key<Runnable> EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY = Key.create((String)"gui.test.execute.before.build");
    public static Key<String> GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY = Key.create((String)"gui.test.gradle.build.output");
    private boolean myGuiTestingMode;
    private GuiTestSuiteState myGuiTestSuiteState;

    public static GuiTestingService getInstance() {
        return (GuiTestingService)ServiceManager.getService(GuiTestingService.class);
    }

    private GuiTestingService() {
        ExtensionPointName epName = ExtensionPointName.create((String)"com.android.tools.idea.ui.guiTestingStatusProvider");
        for (GuiTestingStatusProvider provider : (GuiTestingStatusProvider[])epName.getExtensions()) {
            this.myGuiTestingMode = provider.enableUiTestMode() || this.myGuiTestingMode;
        }
    }

    public boolean isGuiTestingMode() {
        return this.myGuiTestingMode;
    }

    public void setGuiTestingMode(boolean guiTestingMode) {
        this.myGuiTestingMode = guiTestingMode;
        this.myGuiTestSuiteState = this.myGuiTestingMode ? new GuiTestSuiteState() : null;
    }

    @NotNull
    public GuiTestSuiteState getGuiTestSuiteState() {
        if (!this.myGuiTestingMode) {
            throw new UnsupportedOperationException("The method 'getGuiTestSuiteState' can only be invoked when running UI tests");
        }
        GuiTestSuiteState guiTestSuiteState = this.myGuiTestSuiteState;
        if (guiTestSuiteState == null) {
            GuiTestingService.$$$reportNull$$$0(0);
        }
        return guiTestSuiteState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/ui/GuiTestingService", "getGuiTestSuiteState"));
    }

    public static class GuiTestSuiteState {
        private boolean mySkipSdkMerge;

        public boolean isSkipSdkMerge() {
            return this.mySkipSdkMerge;
        }

        public void setSkipSdkMerge(boolean skipSdkMerge) {
            this.mySkipSdkMerge = skipSdkMerge;
        }
    }
}

