/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.error;

import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.uibuilder.error.NlIssue;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.collect.ImmutableList;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ModalityState;
import com.intellij.ui.GuiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IssueModel {
    @Nullable
    private RenderErrorModel myRenderErrorModel;
    @Nullable
    private LintAnnotationsModel myLintAnnotationsModel;
    private ImmutableList<NlIssue> myIssues = ImmutableList.of();
    private final ListenerCollection<IssueModelListener> myListeners = ListenerCollection.createWithExecutor(command -> GuiUtils.invokeLaterIfNeeded((Runnable)command, (ModalityState)ModalityState.defaultModalityState()));
    private int myWarningCount;
    private int myErrorCount;

    public void setRenderErrorModel(@NotNull RenderErrorModel renderErrorModel) {
        if (renderErrorModel == null) {
            IssueModel.$$$reportNull$$$0(0);
        }
        this.myRenderErrorModel = renderErrorModel;
        this.updateErrorsList();
    }

    private void updateErrorsList() {
        NlIssue issue;
        this.myWarningCount = 0;
        this.myErrorCount = 0;
        ImmutableList.Builder issueListBuilder = ImmutableList.builder();
        if (this.myRenderErrorModel != null) {
            for (Comparable<RenderErrorModel.Issue> error : this.myRenderErrorModel.getIssues()) {
                issue = NlIssue.wrapIssue(error);
                issueListBuilder.add((Object)issue);
                this.updateIssuesCounts(issue);
            }
        }
        if (this.myLintAnnotationsModel != null) {
            for (Comparable<RenderErrorModel.Issue> error : this.myLintAnnotationsModel.getIssues()) {
                issue = NlIssue.wrapIssue((LintAnnotationsModel.IssueData)error);
                issueListBuilder.add((Object)issue);
                this.updateIssuesCounts(issue);
            }
        }
        this.myIssues = issueListBuilder.build();
        this.myListeners.forEach(IssueModelListener::errorModelChanged);
    }

    private void updateIssuesCounts(@NotNull NlIssue issue) {
        if (issue == null) {
            IssueModel.$$$reportNull$$$0(1);
        }
        if (issue.getSeverity().equals((Object)HighlightSeverity.WARNING)) {
            ++this.myWarningCount;
        } else if (issue.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
            ++this.myErrorCount;
        }
    }

    public void setLintAnnotationsModel(@NotNull LintAnnotationsModel lintAnnotationsModel) {
        if (lintAnnotationsModel == null) {
            IssueModel.$$$reportNull$$$0(2);
        }
        this.myLintAnnotationsModel = lintAnnotationsModel;
        this.updateErrorsList();
    }

    @NotNull
    public ImmutableList<NlIssue> getNlErrors() {
        ImmutableList<NlIssue> immutableList = this.myIssues;
        if (immutableList == null) {
            IssueModel.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public boolean hasRenderError() {
        return this.myRenderErrorModel != null && !this.myRenderErrorModel.getIssues().isEmpty();
    }

    public int getIssueCount() {
        return this.myIssues.size();
    }

    public void addErrorModelListener(@NotNull IssueModelListener listener) {
        if (listener == null) {
            IssueModel.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener);
    }

    public void removeErrorModelListener(@NotNull IssueModelListener listener) {
        if (listener == null) {
            IssueModel.$$$reportNull$$$0(5);
        }
        this.myListeners.remove(listener);
    }

    public int getWarningCount() {
        return this.myWarningCount;
    }

    public int getErrorCount() {
        return this.myErrorCount;
    }

    public boolean hasIssues() {
        return !this.myIssues.isEmpty();
    }

    @Nullable
    public NlIssue findIssue(@NotNull NlComponent component2) {
        if (component2 == null) {
            IssueModel.$$$reportNull$$$0(6);
        }
        for (NlIssue issue : this.myIssues) {
            if (!component2.equals(issue.getSource())) continue;
            return issue;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderErrorModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lintAnnotationsModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/error/IssueModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/error/IssueModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNlErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setRenderErrorModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateIssuesCounts";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLintAnnotationsModel";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addErrorModelListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeErrorModelListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findIssue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface IssueModelListener {
        public void errorModelChanged();
    }
}

