/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.AttributeBrowser;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewTagHandler
extends ViewHandler {
    private static final String DIVIDER_BACKGROUND = "?android:attr/listDivider";
    public static final Predicate<String> SUITABLE_LAYOUT_CLASS = ViewTagHandler::isViewSuitableForLayout;

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"class", (Object)"style");
        if (immutableList == null) {
            ViewTagHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @Nullable
    public AttributeBrowser getBrowser(@NotNull String attributeName) {
        if (attributeName == null) {
            ViewTagHandler.$$$reportNull$$$0(1);
        }
        if (!attributeName.equals("class")) {
            return null;
        }
        return ViewTagHandler::browseClasses;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        if (tagName == null) {
            ViewTagHandler.$$$reportNull$$$0(2);
        }
        if ("<view>" == null) {
            ViewTagHandler.$$$reportNull$$$0(3);
        }
        return "<view>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component2) {
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(4);
        }
        if ("<view>" == null) {
            ViewTagHandler.$$$reportNull$$$0(5);
        }
        return "<view>";
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        if (tagName == null) {
            ViewTagHandler.$$$reportNull$$$0(6);
        }
        if (xmlType == null) {
            ViewTagHandler.$$$reportNull$$$0(7);
        }
        switch (xmlType) {
            case COMPONENT_CREATION: {
                if ("<view/>" == null) {
                    ViewTagHandler.$$$reportNull$$$0(8);
                }
                return "<view/>";
            }
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                if ("" == null) {
                    ViewTagHandler.$$$reportNull$$$0(9);
                }
                return "";
            }
        }
        String string = super.getXml(tagName, xmlType);
        if (string == null) {
            ViewTagHandler.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public boolean onCreate(@NotNull ViewEditor editor, @Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (editor == null) {
            ViewTagHandler.$$$reportNull$$$0(11);
        }
        if (newChild == null) {
            ViewTagHandler.$$$reportNull$$$0(12);
        }
        if (insertType == null) {
            ViewTagHandler.$$$reportNull$$$0(13);
        }
        if (insertType == InsertType.CREATE && newChild.getAttribute(null, "class") == null && !ViewTagHandler.isVerticalDivider(newChild) && !ViewTagHandler.isHorizontalDivider(newChild)) {
            String src = ViewTagHandler.browseClasses(editor, null);
            if (src != null) {
                newChild.setAttribute(null, "class", src);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component2) {
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(14);
        }
        if (!component2.getTagName().equals("view")) {
            Icon icon = super.getIcon(component2);
            if (icon == null) {
                ViewTagHandler.$$$reportNull$$$0(15);
            }
            return icon;
        }
        if (ViewTagHandler.isVerticalDivider(component2)) {
            Icon icon = StudioIcons.LayoutEditor.Palette.VERTICAL_DIVIDER;
            if (icon == null) {
                ViewTagHandler.$$$reportNull$$$0(16);
            }
            return icon;
        }
        if (ViewTagHandler.isHorizontalDivider(component2)) {
            Icon icon = StudioIcons.LayoutEditor.Palette.HORIZONTAL_DIVIDER;
            if (icon == null) {
                ViewTagHandler.$$$reportNull$$$0(17);
            }
            return icon;
        }
        Icon icon = StudioIcons.LayoutEditor.Palette.VIEW;
        if (icon == null) {
            ViewTagHandler.$$$reportNull$$$0(18);
        }
        return icon;
    }

    private static boolean isVerticalDivider(@NotNull NlComponent component2) {
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(19);
        }
        return DIVIDER_BACKGROUND.equals(component2.getAttribute("http://schemas.android.com/apk/res/android", "background")) && ViewTagHandler.hasShortWidth(component2, "layout_width");
    }

    private static boolean isHorizontalDivider(@NotNull NlComponent component2) {
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(20);
        }
        return DIVIDER_BACKGROUND.equals(component2.getAttribute("http://schemas.android.com/apk/res/android", "background")) && ViewTagHandler.hasShortWidth(component2, "layout_height");
    }

    private static boolean hasShortWidth(@NotNull NlComponent component2, @NotNull String attributeName) {
        String value;
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(21);
        }
        if (attributeName == null) {
            ViewTagHandler.$$$reportNull$$$0(22);
        }
        if ((value = component2.getAttribute("http://schemas.android.com/apk/res/android", attributeName)) == null) {
            return false;
        }
        switch (value) {
            case "1": 
            case "1px": 
            case "1dp": 
            case "1dip": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String browseClasses(@NotNull ViewEditor editor, @Nullable String existingValue) {
        if (editor == null) {
            ViewTagHandler.$$$reportNull$$$0(23);
        }
        return editor.displayClassInput("Views", Collections.singleton("android.view.View"), SUITABLE_LAYOUT_CLASS, existingValue);
    }

    private static boolean isViewSuitableForLayout(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ViewTagHandler.$$$reportNull$$$0(24);
        }
        return !qualifiedName.startsWith("android.") || qualifiedName.startsWith("android.support.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewTagHandler";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 4: 
            case 14: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlType";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewTagHandler";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getXml";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBrowser";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getXml";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onCreate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isVerticalDivider";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isHorizontalDivider";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasShortWidth";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "browseClasses";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isViewSuitableForLayout";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

