/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class ConnectionDraw {
    private static final boolean DEBUG = false;
    private static Polygon sLeftArrow;
    private static Polygon sTopArrow;
    private static Polygon sRightArrow;
    private static Polygon sBottomArrow;
    static Font sFont;
    private static Font sSmallFont;
    public static Stroke sSpreadDashedStroke;
    public static Stroke sDashedStroke;
    public static final int ARROW_SIDE = 5;
    public static int CONNECTION_ANCHOR_SIZE;
    public static final int CONNECTION_ARROW_SIZE = 3;
    static final int CONNECTION_RESIZE_SIZE = 4;

    public static void drawCircledText(Graphics2D g, Font font, String text, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setFont(font);
        FontMetrics fm = g2.getFontMetrics();
        int padding = 4;
        Rectangle2D bounds = fm.getStringBounds(text, g2);
        double th = bounds.getHeight();
        double tw = bounds.getWidth();
        float radius = (float)(Math.max(th, tw) / 2.0 + (double)padding);
        Ellipse2D.Float circle = new Ellipse2D.Float((float)x - radius, (float)y - radius, 2.0f * radius + 1.0f, 2.0f * radius + 1.0f);
        g2.fill(circle);
        g2.setColor(Color.BLACK);
        g2.drawString(text, (int)((double)x - tw / 2.0), y + fm.getAscent() / 2);
        g2.dispose();
    }

    public static void drawHorizontalMarginIndicator(Graphics2D g, String text, int x1, int x2, int y) {
        if (x1 > x2) {
            int temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (text == null) {
            g.drawLine(x1, y, x2, y);
            g.drawLine(x1, y, x1 + 3, y - 3);
            g.drawLine(x1, y, x1 + 3, y + 3);
            g.drawLine(x2, y, x2 - 3, y - 3);
            g.drawLine(x2, y, x2 - 3, y + 3);
            return;
        }
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(sFont);
        g.setFont(sFont);
        int padding = 4;
        Rectangle2D bounds = fm.getStringBounds(text, g);
        int th = (int)bounds.getHeight();
        int tw = (int)bounds.getWidth();
        int offset = 9;
        int w = (x2 - x1 - (tw + 2 * padding)) / 2;
        if (w <= padding) {
            g.drawLine(x1, y, x2, y);
            g.drawString(text, x1 + w + padding, y + offset);
            g.drawLine(x1, y - 3, x1, y + 3);
            g.drawLine(x2, y - 3, x2, y + 3);
        } else {
            g.drawLine(x1, y, x1 + w, y);
            g.drawLine(x2 - w, y, x2, y);
            g.drawString(text, x1 + w + padding, (int)((double)y + bounds.getHeight() / 2.0));
            g.drawLine(x1, y, x1 + 3, y - 3);
            g.drawLine(x1, y, x1 + 3, y + 3);
            g.drawLine(x2, y, x2 - 3, y - 3);
            g.drawLine(x2, y, x2 - 3, y + 3);
        }
    }

    public static void drawVerticalMarginIndicator(Graphics2D g, String text, int x, int y1, int y2) {
        if (y1 > y2) {
            int temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (text == null) {
            g.drawLine(x, y1, x, y2);
            g.drawLine(x, y1, x - 3, y1 + 3);
            g.drawLine(x, y1, x + 3, y1 + 3);
            g.drawLine(x, y2, x - 3, y2 - 3);
            g.drawLine(x, y2, x + 3, y2 - 3);
            return;
        }
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(sFont);
        g.setFont(sFont);
        int padding = 4;
        Rectangle2D bounds = fm.getStringBounds(text, g);
        int th = (int)bounds.getHeight();
        int offset = 9;
        int h = (y2 - y1 - (th + 2 * padding)) / 2;
        if (h <= padding) {
            g.drawLine(x, y1, x, y2);
            g.drawString(text, (int)((double)x - bounds.getWidth() / 2.0) + offset, y2 - h - padding);
            g.drawLine(x - 3, y1, x + 3, y1);
            g.drawLine(x - 3, y2, x + 3, y2);
        } else {
            g.drawLine(x, y1, x, y1 + h);
            g.drawLine(x, y2 - h, x, y2);
            g.drawString(text, (int)((double)x - bounds.getWidth() / 2.0), y2 - h - padding);
            g.drawLine(x, y1, x - 3, y1 + 3);
            g.drawLine(x, y1, x + 3, y1 + 3);
            g.drawLine(x, y2, x - 3, y2 - 3);
            g.drawLine(x, y2, x + 3, y2 - 3);
        }
    }

    public static void drawArrow(Graphics2D g, Polygon arrow, int x, int y) {
        arrow.translate(x, y);
        g.draw(arrow);
        g.fill(arrow);
        arrow.translate(-x, -y);
    }

    public static Polygon getLeftArrow() {
        if (sLeftArrow == null) {
            sLeftArrow = new Polygon();
            sLeftArrow.addPoint(0, 0);
            sLeftArrow.addPoint(5, -3);
            sLeftArrow.addPoint(5, 3);
        }
        return sLeftArrow;
    }

    public static Polygon getRightArrow() {
        if (sRightArrow == null) {
            sRightArrow = new Polygon();
            sRightArrow.addPoint(0, 0);
            sRightArrow.addPoint(-5, -3);
            sRightArrow.addPoint(-5, 3);
        }
        return sRightArrow;
    }

    public static Polygon getTopArrow() {
        if (sTopArrow == null) {
            sTopArrow = new Polygon();
            sTopArrow.addPoint(0, 0);
            sTopArrow.addPoint(-3, 5);
            sTopArrow.addPoint(3, 5);
        }
        return sTopArrow;
    }

    public static Polygon getBottomArrow() {
        if (sBottomArrow == null) {
            sBottomArrow = new Polygon();
            sBottomArrow.addPoint(0, 0);
            sBottomArrow.addPoint(-3, -5);
            sBottomArrow.addPoint(3, -5);
        }
        return sBottomArrow;
    }

    static {
        sFont = new Font("Helvetica", 0, 12);
        sSmallFont = new Font("Helvetica", 0, 8);
        sSpreadDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 4.0f}, 0.0f);
        sDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{2.0f}, 0.0f);
        CONNECTION_ANCHOR_SIZE = 6;
    }
}

