/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.interaction;

import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ViewTransform;
import com.android.tools.idea.uibuilder.handlers.constraint.interaction.ConnectionCandidate;
import com.android.tools.idea.uibuilder.handlers.constraint.interaction.ConstraintHandle;
import com.android.tools.idea.uibuilder.handlers.constraint.interaction.ResizeHandle;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchor;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidgetContainer;
import com.android.tools.idea.uibuilder.handlers.constraint.model.Guideline;
import com.android.tools.idea.uibuilder.handlers.constraint.structure.WidgetCompanion;
import java.util.ArrayList;

public class WidgetInteractionTargets {
    private static final boolean USE_SIDE_RESIZE = false;
    private ResizeHandle mLeftTop = new ResizeHandle(this, ResizeHandle.Type.LEFT_TOP);
    private ResizeHandle mLeftBottom = new ResizeHandle(this, ResizeHandle.Type.LEFT_BOTTOM);
    private ResizeHandle mRightTop = new ResizeHandle(this, ResizeHandle.Type.RIGHT_TOP);
    private ResizeHandle mRightBottom = new ResizeHandle(this, ResizeHandle.Type.RIGHT_BOTTOM);
    private ResizeHandle mLeftSide = new ResizeHandle(this, ResizeHandle.Type.LEFT_SIDE);
    private ResizeHandle mRightSide = new ResizeHandle(this, ResizeHandle.Type.RIGHT_SIDE);
    private ResizeHandle mTopSide = new ResizeHandle(this, ResizeHandle.Type.TOP_SIDE);
    private ResizeHandle mBottomSide = new ResizeHandle(this, ResizeHandle.Type.BOTTOM_SIDE);
    protected ArrayList<ResizeHandle> mResizeHandles = new ArrayList();
    private ConstraintHandle mLeftAnchor = new ConstraintHandle(this, ConstraintAnchor.Type.LEFT);
    private ConstraintHandle mTopAnchor = new ConstraintHandle(this, ConstraintAnchor.Type.TOP);
    private ConstraintHandle mRightAnchor = new ConstraintHandle(this, ConstraintAnchor.Type.RIGHT);
    private ConstraintHandle mBottomAnchor = new ConstraintHandle(this, ConstraintAnchor.Type.BOTTOM);
    private ConstraintHandle mBaselineAnchor = new ConstraintHandle(this, ConstraintAnchor.Type.BASELINE);
    private ConstraintHandle mCenterXAnchor = new ConstraintHandle(this, ConstraintAnchor.Type.CENTER_X);
    private ConstraintHandle mCenterYAnchor = new ConstraintHandle(this, ConstraintAnchor.Type.CENTER_Y);
    private ConstraintHandle mCenterAnchor = new ConstraintHandle(this, ConstraintAnchor.Type.CENTER);
    protected ArrayList<ConstraintHandle> mConstraintHandles = new ArrayList();
    private final ConstraintWidget mWidget;

    public WidgetInteractionTargets(ConstraintWidget widget) {
        this.mWidget = widget;
        this.addResizeHandles();
        this.resetConstraintHandles();
    }

    public ConstraintWidget getConstraintWidget() {
        return this.mWidget;
    }

    private void addResizeHandles() {
        this.mResizeHandles.add(this.mLeftTop);
        this.mResizeHandles.add(this.mLeftBottom);
        this.mResizeHandles.add(this.mRightTop);
        this.mResizeHandles.add(this.mRightBottom);
        if (this.mWidget instanceof Guideline) {
            this.mResizeHandles.add(this.mLeftSide);
            this.mResizeHandles.add(this.mTopSide);
        }
    }

    public void resetConstraintHandles() {
        this.mConstraintHandles.clear();
        for (ConstraintAnchor anchor : this.mWidget.getAnchors()) {
            switch (anchor.getType()) {
                case LEFT: {
                    this.mConstraintHandles.add(this.mLeftAnchor);
                    break;
                }
                case TOP: {
                    this.mConstraintHandles.add(this.mTopAnchor);
                    break;
                }
                case RIGHT: {
                    this.mConstraintHandles.add(this.mRightAnchor);
                    break;
                }
                case BOTTOM: {
                    this.mConstraintHandles.add(this.mBottomAnchor);
                    break;
                }
                case BASELINE: {
                    this.mConstraintHandles.add(this.mBaselineAnchor);
                    break;
                }
                case CENTER_X: {
                    this.mConstraintHandles.add(this.mCenterXAnchor);
                    break;
                }
                case CENTER_Y: {
                    this.mConstraintHandles.add(this.mCenterYAnchor);
                    break;
                }
                case CENTER: {
                    this.mConstraintHandles.add(this.mCenterAnchor);
                    break;
                }
            }
        }
        for (ConstraintHandle handle : this.mConstraintHandles) {
            handle.updateAnchor();
        }
    }

    public ArrayList<ResizeHandle> getResizeHandles() {
        return this.mResizeHandles;
    }

    public ArrayList<ConstraintHandle> getConstraintHandles() {
        return this.mConstraintHandles;
    }

    private void updateResizeHandlesPositions(ViewTransform viewTransform) {
        for (ResizeHandle mResizeHandle : this.mResizeHandles) {
            mResizeHandle.updatePosition(viewTransform);
        }
    }

    private void updateConstraintHandlesPositions() {
        for (ConstraintHandle mConstraintHandle : this.mConstraintHandles) {
            mConstraintHandle.updatePosition();
        }
    }

    public void updatePosition(ViewTransform viewTransform) {
        this.updateResizeHandlesPositions(viewTransform);
        this.updateConstraintHandlesPositions();
    }

    public ResizeHandle findResizeHandle(float x, float y) {
        ResizeHandle candidate = null;
        if (this.mWidget instanceof Guideline) {
            Guideline guideline = (Guideline)this.mWidget;
            if (guideline.getOrientation() == 1) {
                if (this.mLeftSide.hit(x, y)) {
                    return this.mLeftSide;
                }
            } else if (this.mTopSide.hit(x, y)) {
                return this.mTopSide;
            }
        }
        ConstraintAnchor leftAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor topAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor rightAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.RIGHT);
        ConstraintAnchor bottomAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.BOTTOM);
        ConstraintAnchor baselineAnchor = this.mWidget.getAnchor(ConstraintAnchor.Type.BASELINE);
        block10: for (ResizeHandle handle : this.mResizeHandles) {
            if (!handle.hit(x, y)) continue;
            boolean leftAnchorIsConnected = leftAnchor != null && leftAnchor.isConnected();
            boolean topAnchorIsConnected = topAnchor != null && topAnchor.isConnected();
            boolean rightAnchorIsConnected = rightAnchor != null && rightAnchor.isConnected();
            boolean bottomAnchorIsConnected = bottomAnchor != null && bottomAnchor.isConnected();
            boolean baselineAnchorIsConnected = baselineAnchor != null && baselineAnchor.isConnected();
            switch (handle.getType()) {
                case LEFT_TOP: {
                    if (!leftAnchorIsConnected && !topAnchorIsConnected) break;
                    continue block10;
                }
                case RIGHT_TOP: {
                    if (!rightAnchorIsConnected && !topAnchorIsConnected) break;
                    continue block10;
                }
                case LEFT_BOTTOM: {
                    if (!leftAnchorIsConnected && !bottomAnchorIsConnected) break;
                    continue block10;
                }
                case RIGHT_BOTTOM: {
                    if (!rightAnchorIsConnected && !bottomAnchorIsConnected) break;
                    continue block10;
                }
                case LEFT_SIDE: {
                    if (!leftAnchorIsConnected) break;
                    continue block10;
                }
                case RIGHT_SIDE: {
                    if (!rightAnchorIsConnected) break;
                    continue block10;
                }
                case TOP_SIDE: {
                    if (!topAnchorIsConnected && !baselineAnchorIsConnected) break;
                    continue block10;
                }
                case BOTTOM_SIDE: {
                    if (!bottomAnchorIsConnected) break;
                    continue block10;
                }
            }
            if (candidate != null && !candidate.isSideHandle()) continue;
            candidate = handle;
        }
        return candidate;
    }

    public ConstraintHandle getConstraintHandle(ConstraintAnchor anchor) {
        for (ConstraintHandle handle : this.mConstraintHandles) {
            if (handle.getAnchor() != anchor) continue;
            return handle;
        }
        return null;
    }

    public static ConstraintHandle constraintHandle(ConstraintAnchor anchor) {
        if (anchor == null) {
            return null;
        }
        ConstraintWidget widget = anchor.getOwner();
        if (widget == null) {
            return null;
        }
        if (widget.getCompanionWidget() == null) {
            return null;
        }
        WidgetCompanion widgetCompanion = (WidgetCompanion)widget.getCompanionWidget();
        WidgetInteractionTargets widgetInteraction = widgetCompanion.getWidgetInteractionTargets();
        return widgetInteraction.getConstraintHandle(anchor);
    }

    public void findClosestConnection(ViewTransform viewTransform, float x, float y, ConnectionCandidate candidate, boolean mousePress) {
        block14: {
            block13: {
                if (!(this.mWidget instanceof Guideline)) break block13;
                Guideline guideline = (Guideline)this.mWidget;
                ConstraintAnchor anchor = guideline.getAnchor();
                ConstraintHandle handle = WidgetInteractionTargets.constraintHandle(anchor);
                if (handle == null) {
                    return;
                }
                float distance = guideline.getOrientation() == 1 ? ((float)handle.getDrawX() - x) * ((float)handle.getDrawX() - x) : ((float)handle.getDrawY() - y) * ((float)handle.getDrawY() - y);
                if (!((distance = viewTransform.getSwingDimensionF(distance)) < candidate.distance)) break block14;
                candidate.anchorTarget = anchor;
                candidate.distance = distance;
                break block14;
            }
            if (this.mWidget instanceof ConstraintWidgetContainer) {
                for (ConstraintHandle handle : this.mConstraintHandles) {
                    ConstraintAnchor anchor = handle.getAnchor();
                    if (anchor.getType() == ConstraintAnchor.Type.CENTER_X || anchor.getType() == ConstraintAnchor.Type.CENTER_Y) continue;
                    float distance = 0.0f;
                    boolean computed = false;
                    if (!mousePress && anchor.isSideAnchor()) {
                        if (!anchor.isVerticalAnchor()) {
                            if (y >= (float)this.mWidget.getDrawY() && y <= (float)this.mWidget.getDrawBottom()) {
                                distance = ((float)handle.getDrawX() - x) * ((float)handle.getDrawX() - x);
                                computed = true;
                            }
                        } else if (x >= (float)this.mWidget.getDrawX() && x <= (float)this.mWidget.getDrawRight()) {
                            distance = ((float)handle.getDrawY() - y) * ((float)handle.getDrawY() - y);
                            computed = true;
                        }
                    }
                    if (!computed) {
                        distance = ((float)handle.getDrawX() - x) * ((float)handle.getDrawX() - x) + ((float)handle.getDrawY() - y) * ((float)handle.getDrawY() - y);
                    }
                    if (!((distance = viewTransform.getSwingDimensionF(distance)) < candidate.distance)) continue;
                    candidate.anchorTarget = anchor;
                    candidate.distance = distance;
                }
            } else {
                for (ConstraintHandle handle : this.mConstraintHandles) {
                    ConstraintAnchor anchor = handle.getAnchor();
                    float distance = ((float)handle.getDrawX() - x) * ((float)handle.getDrawX() - x) + ((float)handle.getDrawY() - y) * ((float)handle.getDrawY() - y);
                    if (anchor.getType() == ConstraintAnchor.Type.CENTER_X || anchor.getType() == ConstraintAnchor.Type.CENTER_Y) continue;
                    if (anchor.getType() == ConstraintAnchor.Type.BASELINE) {
                        if (!anchor.getOwner().hasBaseline()) continue;
                        ConstraintWidget widget = anchor.getOwner();
                        int minX = widget.getDrawX();
                        int maxX = widget.getDrawRight();
                        float d = Math.abs((float)handle.getDrawY() - y);
                        if (x >= (float)minX && x <= (float)maxX && d < 3.0f) {
                            distance = d * d;
                        }
                    }
                    if (!((distance = viewTransform.getSwingDimensionF(distance)) <= candidate.distance) || candidate.anchorTarget != null && candidate.anchorTarget.getPriorityLevel() >= anchor.getPriorityLevel()) continue;
                    candidate.anchorTarget = anchor;
                    candidate.distance = distance;
                }
            }
        }
    }
}

