/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.model;

import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchor;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.model.Rectangle;
import java.util.ArrayList;

public class Guideline
extends ConstraintWidget {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int RELATIVE_PERCENT = 0;
    public static final int RELATIVE_BEGIN = 1;
    public static final int RELATIVE_END = 2;
    public static final int RELATIVE_UNKNWON = -1;
    protected float mRelativePercent = -1.0f;
    protected int mRelativeBegin = -1;
    protected int mRelativeEnd = -1;
    private ConstraintAnchor mAnchor = this.mTop;
    private int mOrientation = 0;
    private boolean mIsPositionRelaxed = false;
    private int mMinimumPosition = 0;
    private Rectangle mHead = new Rectangle();
    private int mHeadSize = 8;

    public Guideline() {
        this.mAnchors.clear();
        this.mAnchors.add(this.mAnchor);
        int count = this.mListAnchors.length;
        for (int i = 0; i < count; ++i) {
            this.mListAnchors[i] = this.mAnchor;
        }
    }

    public int getRelativeBehaviour() {
        if (this.mRelativePercent != -1.0f) {
            return 0;
        }
        if (this.mRelativeBegin != -1) {
            return 1;
        }
        if (this.mRelativeEnd != -1) {
            return 2;
        }
        return -1;
    }

    public Rectangle getHead() {
        this.mHead.setBounds(this.getDrawX() - this.mHeadSize, this.getDrawY() - 2 * this.mHeadSize, 2 * this.mHeadSize, 2 * this.mHeadSize);
        if (this.getOrientation() == 0) {
            this.mHead.setBounds(this.getDrawX() - 2 * this.mHeadSize, this.getDrawY() - this.mHeadSize, 2 * this.mHeadSize, 2 * this.mHeadSize);
        }
        return this.mHead;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.mAnchors.clear();
        this.mAnchor = this.mOrientation == 1 ? this.mLeft : this.mTop;
        this.mAnchors.add(this.mAnchor);
        int count = this.mListAnchors.length;
        for (int i = 0; i < count; ++i) {
            this.mListAnchors[i] = this.mAnchor;
        }
    }

    public ConstraintAnchor getAnchor() {
        return this.mAnchor;
    }

    @Override
    public String getType() {
        return "Guideline";
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setMinimumPosition(int minimum) {
        this.mMinimumPosition = minimum;
    }

    public void setPositionRelaxed(boolean value) {
        if (this.mIsPositionRelaxed == value) {
            return;
        }
        this.mIsPositionRelaxed = value;
    }

    @Override
    public ConstraintAnchor getAnchor(ConstraintAnchor.Type anchorType) {
        switch (anchorType) {
            case LEFT: 
            case RIGHT: {
                if (this.mOrientation != 1) break;
                return this.mAnchor;
            }
            case TOP: 
            case BOTTOM: {
                if (this.mOrientation != 0) break;
                return this.mAnchor;
            }
            case BASELINE: 
            case CENTER: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)anchorType.name());
    }

    @Override
    public ArrayList<ConstraintAnchor> getAnchors() {
        return this.mAnchors;
    }

    public void setGuidePercent(int value) {
        this.setGuidePercent((float)value / 100.0f);
    }

    public void setGuidePercent(float value) {
        if (value > -1.0f) {
            this.mRelativePercent = value;
            this.mRelativeBegin = -1;
            this.mRelativeEnd = -1;
        }
    }

    public void setGuideBegin(int value) {
        if (value > -1) {
            this.mRelativePercent = -1.0f;
            this.mRelativeBegin = value;
            this.mRelativeEnd = -1;
        }
    }

    public void setGuideEnd(int value) {
        if (value > -1) {
            this.mRelativePercent = -1.0f;
            this.mRelativeBegin = -1;
            this.mRelativeEnd = value;
        }
    }

    public float getRelativePercent() {
        return this.mRelativePercent;
    }

    public int getRelativeBegin() {
        return this.mRelativeBegin;
    }

    public int getRelativeEnd() {
        return this.mRelativeEnd;
    }

    @Override
    public void setDrawOrigin(int x, int y) {
        if (this.mOrientation == 1) {
            int position = x - this.mOffsetX;
            if (this.mRelativeBegin != -1) {
                this.setGuideBegin(position);
            } else if (this.mRelativeEnd != -1) {
                this.setGuideEnd(this.getParent().getWidth() - position);
            } else if (this.mRelativePercent != -1.0f) {
                float percent = (float)position / (float)this.getParent().getWidth();
                this.setGuidePercent(percent);
            }
        } else {
            int position = y - this.mOffsetY;
            if (this.mRelativeBegin != -1) {
                this.setGuideBegin(position);
            } else if (this.mRelativeEnd != -1) {
                this.setGuideEnd(this.getParent().getHeight() - position);
            } else if (this.mRelativePercent != -1.0f) {
                float percent = (float)position / (float)this.getParent().getHeight();
                this.setGuidePercent(percent);
            }
        }
    }

    void inferRelativePercentPosition() {
        float percent = (float)this.getX() / (float)this.getParent().getWidth();
        if (this.mOrientation == 0) {
            percent = (float)this.getY() / (float)this.getParent().getHeight();
        }
        this.setGuidePercent(percent);
    }

    void inferRelativeBeginPosition() {
        int position = this.getX();
        if (this.mOrientation == 0) {
            position = this.getY();
        }
        this.setGuideBegin(position);
    }

    void inferRelativeEndPosition() {
        int position = this.getParent().getWidth() - this.getX();
        if (this.mOrientation == 0) {
            position = this.getParent().getHeight() - this.getY();
        }
        this.setGuideEnd(position);
    }

    public void cyclePosition() {
        if (this.mRelativeBegin != -1) {
            this.inferRelativePercentPosition();
        } else if (this.mRelativePercent != -1.0f) {
            this.inferRelativeEndPosition();
        } else if (this.mRelativeEnd != -1) {
            this.inferRelativeBeginPosition();
        }
    }
}

