/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scout.Scout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnchorTarget
extends BaseTarget {
    private static final boolean DEBUG_RENDERER = false;
    private final boolean myVisibility;
    private AnchorTarget myCurrentClosestTarget;
    private boolean myThisIsTheTarget;
    private boolean myInDrag;
    private boolean myRenderingTemporaryConnection;
    protected static final int ourSize = 3;
    private static final int ourExpandSize = 200;
    private final Type myType;
    private boolean myExpandArea;
    private int myLastX;
    private int myLastY;
    private int myConnectedX;
    private int myConnectedY;
    private HashMap<String, String> mPreviousAttributes;

    public AnchorTarget(@NotNull Type type, boolean visible) {
        if (type == null) {
            AnchorTarget.$$$reportNull$$$0(0);
        }
        this.myInDrag = false;
        this.myRenderingTemporaryConnection = false;
        this.myExpandArea = false;
        this.myLastX = -1;
        this.myLastY = -1;
        this.myConnectedX = -1;
        this.myConnectedY = -1;
        this.mPreviousAttributes = new HashMap();
        this.myType = type;
        this.myVisibility = visible;
    }

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    public Type getType() {
        return this.myType;
    }

    @Override
    public void setExpandSize(boolean expand) {
        this.myExpandArea = expand;
    }

    public boolean isHorizontalAnchor() {
        return this.myType == Type.LEFT || this.myType == Type.RIGHT;
    }

    public boolean isVerticalAnchor() {
        return this.myType == Type.TOP || this.myType == Type.BOTTOM;
    }

    public void setThisIsTheTarget(boolean target) {
        this.myThisIsTheTarget = target;
    }

    @Override
    public void setMouseHovered(boolean over) {
        if (over != this.mIsOver) {
            this.changeState(this.mIsOver, over);
            this.mIsOver = over;
            this.myComponent.getScene().needsRebuildList();
            this.myComponent.getScene().repaint();
        }
    }

    private void changeState(boolean prevOver, boolean currentOver) {
        String dir;
        switch (this.myType) {
            case LEFT: {
                dir = "left";
                break;
            }
            case TOP: {
                dir = "north";
                break;
            }
            case RIGHT: {
                dir = "right";
                break;
            }
            case BOTTOM: {
                dir = "bottom";
                break;
            }
            default: {
                dir = "baseline";
            }
        }
        DecoratorUtilities.ViewStates mode = DecoratorUtilities.ViewStates.SELECTED;
        if (currentOver & !this.myThisIsTheTarget) {
            mode = DecoratorUtilities.ViewStates.WILL_DESTROY;
        }
        DecoratorUtilities.setTimeChange(this.myComponent.getNlComponent(), dir, mode);
    }

    @Override
    public void onComponentSelectionChanged(boolean selection) {
        String dir;
        switch (this.myType) {
            case LEFT: {
                dir = "left";
                break;
            }
            case TOP: {
                dir = "north";
                break;
            }
            case RIGHT: {
                dir = "right";
                break;
            }
            case BOTTOM: {
                dir = "bottom";
                break;
            }
            default: {
                dir = "baseline";
            }
        }
        DecoratorUtilities.ViewStates mode = selection ? DecoratorUtilities.ViewStates.SELECTED : DecoratorUtilities.ViewStates.NORMAL;
        DecoratorUtilities.setTimeChange(this.myComponent.getNlComponent(), dir, mode);
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float d;
        float ratio;
        if (sceneTransform == null) {
            AnchorTarget.$$$reportNull$$$0(1);
        }
        if ((ratio = 1.0f / (float)sceneTransform.getScale()) > 2.0f) {
            ratio = 2.0f;
        }
        float size = 3.0f * ratio;
        float minWidth = 4.0f * size;
        float minHeight = 4.0f * size;
        if ((float)(r - l) < minWidth) {
            d = (minWidth - (float)(r - l)) / 2.0f;
            l = (int)((float)l - d);
            r = (int)((float)r + d);
        }
        if ((float)(b - t) < minHeight) {
            d = (minHeight - (float)(b - t)) / 2.0f;
            t = (int)((float)t - d);
            b = (int)((float)b + d);
        }
        int w = r - l;
        int h = b - t;
        int mw = l + w / 2;
        int mh = t + h / 2;
        switch (this.myType) {
            case LEFT: {
                this.myLeft = (float)l - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)l + size;
                this.myBottom = (float)mh + size;
                if (!this.myExpandArea) break;
                this.myLeft = l - 200;
                this.myTop = t;
                this.myBottom = b;
                break;
            }
            case TOP: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)t - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)t + size;
                if (!this.myExpandArea) break;
                this.myTop = t - 200;
                this.myLeft = l;
                this.myRight = r;
                break;
            }
            case RIGHT: {
                this.myLeft = (float)r - size;
                this.myTop = (float)mh - size;
                this.myRight = (float)r + size;
                this.myBottom = (float)mh + size;
                if (!this.myExpandArea) break;
                this.myRight = r + 200;
                this.myTop = t;
                this.myBottom = b;
                break;
            }
            case BOTTOM: {
                this.myLeft = (float)mw - size;
                this.myTop = (float)b - size;
                this.myRight = (float)mw + size;
                this.myBottom = (float)b + size;
                if (!this.myExpandArea) break;
                this.myBottom = b + 200;
                this.myLeft = l;
                this.myRight = r;
                break;
            }
            case BASELINE: {
                this.myLeft = (float)l + size;
                this.myTop = (float)(t + this.myComponent.getBaseline()) - size / 2.0f;
                this.myRight = (float)r - size;
                this.myBottom = (float)(t + this.myComponent.getBaseline()) + size / 2.0f;
            }
        }
        return false;
    }

    private boolean isConnected(AnchorTarget target) {
        if (target == null) {
            return false;
        }
        if (!this.isConnected()) {
            return false;
        }
        String attribute = null;
        switch (this.myType) {
            case LEFT: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourLeftAttributes);
                break;
            }
            case RIGHT: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourRightAttributes);
                break;
            }
            case TOP: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                break;
            }
            case BOTTOM: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                break;
            }
            case BASELINE: {
                attribute = this.myComponent.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf");
                if (attribute == null) break;
                attribute = NlComponent.extractId(attribute);
            }
        }
        if (attribute == null) {
            return false;
        }
        return attribute.equalsIgnoreCase(target.getComponent().getId());
    }

    private boolean isConnected() {
        return ConstraintComponentUtilities.isAnchorConnected(this.myType, this.myComponent.getAuthoritativeNlComponent(), this.useRtlAttributes(), this.isRtl());
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        boolean is_connected;
        if (list == null) {
            AnchorTarget.$$$reportNull$$$0(2);
        }
        if (sceneContext == null) {
            AnchorTarget.$$$reportNull$$$0(3);
        }
        if (!this.myVisibility) {
            return;
        }
        if (!this.myComponent.getScene().allowsTarget(this)) {
            return;
        }
        if (this.myComponent.isDragging() && !this.isConnected()) {
            return;
        }
        int mode = 0;
        int[] modeTable = new int[]{4, 2, 1, 2, 0, 2, 1, 2, 0, 0, 4, 2, 0, 0, 3, 2, 0, 0, 1, 2, 0, 0, 1, 2, 0, 0, 3, 2, 0, 0, 1, 2};
        Integer state = DecoratorUtilities.getTryingToConnectState(this.myComponent.getNlComponent());
        boolean can_connect = state != null && (state & this.myType.getMask()) != 0;
        int drawState = (can_connect ? 1 : 0) | (this.mIsOver ? 2 : 0) | ((is_connected = this.isConnected()) ? 4 : 0) | (this.myThisIsTheTarget ? 8 : 0) | (this.myComponent.isSelected() ? 16 : 0);
        mode = modeTable[drawState];
        if (mode != 4) {
            DrawAnchor.add(list, sceneContext, this.myLeft, this.myTop, this.myRight, this.myBottom, this.myType == Type.BASELINE ? 1 : 0, is_connected && !this.myThisIsTheTarget, mode);
        }
        if (!this.myRenderingTemporaryConnection && this.myLastX != -1 && this.myLastY != -1 && (this.myConnectedX == -1 && this.myConnectedY == -1 || this.myLastX != this.myConnectedX || this.myLastY != this.myConnectedY)) {
            float x = this.myLeft + (this.myRight - this.myLeft) / 2.0f;
            float y = this.myTop + (this.myBottom - this.myTop) / 2.0f;
            list.addConnection(sceneContext, x, y, this.myLastX, this.myLastY, this.myType.ordinal());
        }
    }

    private void clearMe(@NotNull AttributesTransaction transaction) {
        if (transaction == null) {
            AnchorTarget.$$$reportNull$$$0(4);
        }
        ConstraintComponentUtilities.clearAnchor(this.myType, transaction, this.useRtlAttributes(), this.isRtl());
    }

    private void rememberPreviousAttribute(@NotNull String uri, @NotNull ArrayList<String> attributes) {
        if (uri == null) {
            AnchorTarget.$$$reportNull$$$0(5);
        }
        if (attributes == null) {
            AnchorTarget.$$$reportNull$$$0(6);
        }
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            this.mPreviousAttributes.put(attribute, component2.getLiveAttribute(uri, attribute));
        }
    }

    private boolean useRtlAttributes() {
        return this.myComponent.useRtlAttributes();
    }

    private boolean isRtl() {
        return this.myComponent.getScene().isInRTL();
    }

    private String getAttribute(@NotNull Target target) {
        if (target == null) {
            AnchorTarget.$$$reportNull$$$0(7);
        }
        if (!(target instanceof AnchorTarget)) {
            return null;
        }
        AnchorTarget anchorTarget = (AnchorTarget)target;
        return ConstraintComponentUtilities.getAttribute(this.myType, anchorTarget.myType, this.useRtlAttributes(), this.isRtl());
    }

    private void revertToPreviousState() {
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction attributes = component2.startAttributeTransaction();
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
        for (String key : this.mPreviousAttributes.keySet()) {
            if (key.equalsIgnoreCase("layout_editor_absoluteX")) {
                attributes.setAttribute("http://schemas.android.com/tools", key, this.mPreviousAttributes.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("layout_editor_absoluteY")) {
                attributes.setAttribute("http://schemas.android.com/tools", key, this.mPreviousAttributes.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("layout_marginTop") || key.equalsIgnoreCase("layout_marginBottom") || key.equalsIgnoreCase("layout_marginLeft") || key.equalsIgnoreCase("layout_marginRight") || key.equalsIgnoreCase("layout_marginStart") || key.equalsIgnoreCase("layout_marginEnd")) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", key, this.mPreviousAttributes.get(key));
                continue;
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", key, this.mPreviousAttributes.get(key));
        }
        attributes.apply();
        this.myComponent.getScene().needsLayout(2);
    }

    private AttributesTransaction connectMe(NlComponent component2, String attribute, NlComponent targetComponent) {
        AttributesTransaction attributes = component2.startAttributeTransaction();
        String targetId = null;
        NlComponent parent = component2.getParent();
        if (NlComponentHelperKt.isOrHasSuperclass(parent, "android.support.constraint.Constraints")) {
            parent = parent.getParent();
        }
        targetId = targetComponent == parent ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(targetComponent);
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", attribute, targetId);
        if (this.myType == Type.BASELINE) {
            ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes, attributes);
            ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes, attributes);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
        } else if (ConstraintComponentUtilities.ourReciprocalAttributes.get(attribute) != null) {
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourReciprocalAttributes.get(attribute), null);
        }
        if (ConstraintComponentUtilities.ourMapMarginAttributes.get(attribute) != null) {
            Scene scene = this.myComponent.getScene();
            int marginValue = this.getDistance(attribute, targetComponent, scene);
            marginValue = !scene.isControlDown() ? (marginValue < 0 ? 0 : Scout.getMargin()) : Math.max(marginValue, 0);
            String margin = String.format("%ddp", marginValue);
            String attr = ConstraintComponentUtilities.ourMapMarginAttributes.get(attribute);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", attr, margin);
            if ("layout_marginEnd".equals(attr)) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", margin);
            } else if ("layout_marginStart".equals(attr)) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", margin);
            }
            scene.needsRebuildList();
            this.myConnectedX = this.myLastX;
            this.myConnectedY = this.myLastY;
        }
        ConstraintComponentUtilities.cleanup(attributes, this.myComponent.getNlComponent());
        attributes.apply();
        this.myComponent.getScene().needsLayout(2);
        this.myRenderingTemporaryConnection = true;
        return attributes;
    }

    private int getDistance(String attribute, NlComponent targetComponent, Scene scene) {
        int marginValue;
        AnchorTarget targetAnchor = ConstraintComponentUtilities.getTargetAnchor(scene, targetComponent, attribute, this.useRtlAttributes(), this.isRtl());
        if (targetAnchor == null) {
            return 0;
        }
        block0 : switch (this.myType) {
            case LEFT: {
                switch (targetAnchor.getType()) {
                    case LEFT: 
                    case RIGHT: {
                        marginValue = (int)(this.getCenterX() - targetAnchor.getCenterX());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case RIGHT: {
                switch (targetAnchor.getType()) {
                    case LEFT: 
                    case RIGHT: {
                        marginValue = (int)(targetAnchor.getCenterX() - this.getCenterX());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case TOP: {
                switch (targetAnchor.getType()) {
                    case TOP: 
                    case BOTTOM: {
                        marginValue = (int)(this.getCenterY() - targetAnchor.getCenterY());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case BOTTOM: {
                switch (targetAnchor.getType()) {
                    case TOP: 
                    case BOTTOM: {
                        marginValue = (int)(targetAnchor.getCenterY() - this.getCenterY());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            default: {
                marginValue = 0;
            }
        }
        return marginValue;
    }

    private void disconnectMe(NlComponent component2) {
        AttributesTransaction attributes = component2.startAttributeTransaction();
        this.clearMe(attributes);
        ConstraintComponentUtilities.cleanup(attributes, this.myComponent.getNlComponent());
        attributes.apply();
        NlWriteCommandAction.run(component2, "Constraint Disconnected", attributes::commit);
        this.myComponent.getScene().needsLayout(2);
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myLastX = -1;
        this.myLastY = -1;
        this.myConnectedX = -1;
        this.myConnectedY = -1;
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        this.mPreviousAttributes.clear();
        this.mPreviousAttributes.put("layout_editor_absoluteX", component2.getLiveAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX"));
        this.mPreviousAttributes.put("layout_editor_absoluteY", component2.getLiveAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY"));
        this.mPreviousAttributes.put("layout_constraintBaseline_toBaselineOf", component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf"));
        if (this.myComponent.getParent() != null) {
            this.myComponent.getParent().setExpandTargetArea(true);
        }
        switch (this.myType) {
            case LEFT: 
            case RIGHT: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourLeftAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourRightAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourStartAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourEndAttributes);
                this.mPreviousAttributes.put("layout_marginLeft", component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft"));
                this.mPreviousAttributes.put("layout_marginRight", component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight"));
                this.mPreviousAttributes.put("layout_marginStart", component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart"));
                this.mPreviousAttributes.put("layout_marginEnd", component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd"));
                this.mPreviousAttributes.put("layout_constraintHorizontal_bias", component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias"));
                break;
            }
            case TOP: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                this.mPreviousAttributes.put("layout_marginTop", component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
                break;
            }
            case BOTTOM: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                this.mPreviousAttributes.put("layout_marginBottom", component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
                break;
            }
            case BASELINE: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                this.mPreviousAttributes.put("layout_marginTop", component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop"));
                this.mPreviousAttributes.put("layout_marginBottom", component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
            }
        }
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable List<Target> closestTargets) {
        this.myLastX = x;
        this.myLastY = y;
        Target closestTarget = null;
        for (Target target : closestTargets) {
            if (!(target instanceof AnchorTarget) || target == this) continue;
            closestTarget = target;
            break;
        }
        if (!this.myInDrag) {
            this.myInDrag = true;
            DecoratorUtilities.setTryingToConnectState(this.myComponent.getNlComponent(), this.myType, true);
        }
        if (this.myCurrentClosestTarget != closestTarget) {
            if (this.myCurrentClosestTarget != null) {
                this.myCurrentClosestTarget.setThisIsTheTarget(false);
            }
            this.myCurrentClosestTarget = null;
            if (closestTarget instanceof AnchorTarget) {
                this.myCurrentClosestTarget = (AnchorTarget)closestTarget;
                if (this.myCurrentClosestTarget != null) {
                    this.myCurrentClosestTarget.setThisIsTheTarget(true);
                }
            }
        }
        if (closestTarget != null && closestTarget instanceof AnchorTarget) {
            NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
            String attribute = this.getAttribute(closestTarget);
            if (attribute != null) {
                AnchorTarget targetAnchor = (AnchorTarget)closestTarget;
                if (targetAnchor.myComponent != this.myComponent && !targetAnchor.isConnected(this)) {
                    if (this.myComponent.getParent() != targetAnchor.myComponent) {
                        Integer state = DecoratorUtilities.getTryingToConnectState(targetAnchor.myComponent.getNlComponent());
                        if (targetAnchor.myType == null || state == null) {
                            return;
                        }
                        int mask = state & targetAnchor.myType.getMask();
                        if (mask == 0) {
                            return;
                        }
                    }
                    NlComponent targetComponent = targetAnchor.myComponent.getAuthoritativeNlComponent();
                    this.connectMe(component2, attribute, targetComponent);
                    return;
                }
            }
        }
        this.revertToPreviousState();
        this.myRenderingTemporaryConnection = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseRelease(int x, int y, @Nullable List<Target> closestTargets) {
        this.myLastX = -1;
        this.myLastY = -1;
        try {
            if (this.myComponent.getParent() != null) {
                this.myComponent.getParent().setExpandTargetArea(false);
            }
            Target closestTarget = null;
            for (Target target : closestTargets) {
                if (!(target instanceof AnchorTarget) || target == this) continue;
                closestTarget = target;
                break;
            }
            if (closestTarget == null && closestTargets.contains(this)) {
                closestTarget = this;
            }
            if (closestTarget != null && closestTarget instanceof AnchorTarget && !closestTarget.isConnected(this)) {
                NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
                if (closestTarget == this) {
                    this.disconnectMe(component2);
                } else {
                    String attribute = this.getAttribute(closestTarget);
                    if (attribute != null) {
                        Target targetAnchor = closestTarget;
                        if (targetAnchor.myComponent == this.myComponent) {
                            return;
                        }
                        if (this.myComponent.getParent() != targetAnchor.myComponent) {
                            Integer state = DecoratorUtilities.getTryingToConnectState(targetAnchor.myComponent.getNlComponent());
                            if (targetAnchor.myType == null || state == null) {
                                return;
                            }
                            int mask = state & targetAnchor.myType.getMask();
                            if (mask == 0) {
                                return;
                            }
                        }
                        NlComponent targetComponent = targetAnchor.myComponent.getAuthoritativeNlComponent();
                        AttributesTransaction attributes = this.connectMe(component2, attribute, targetComponent);
                        NlWriteCommandAction.run(component2, "Constraint Connected", attributes::commit);
                        this.myComponent.getScene().needsLayout(2);
                    }
                }
            }
        }
        finally {
            if (this.myInDrag) {
                this.myInDrag = false;
                DecoratorUtilities.setTryingToConnectState(this.myComponent.getNlComponent(), this.myType, false);
            }
        }
    }

    @Override
    public String getToolTipText() {
        return this.isConnected() ? "Delete Connection" : "Create Connection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/AnchorTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearMe";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "rememberPreviousAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Type {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        BASELINE;


        public int getMask() {
            switch (this) {
                case LEFT: {
                    return DecoratorUtilities.MASK_LEFT;
                }
                case TOP: {
                    return DecoratorUtilities.MASK_TOP;
                }
                case RIGHT: {
                    return DecoratorUtilities.MASK_RIGHT;
                }
                case BOTTOM: {
                    return DecoratorUtilities.MASK_BOTTOM;
                }
                case BASELINE: {
                    return DecoratorUtilities.MASK_BASELINE;
                }
            }
            return 0;
        }
    }
}

