/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutGuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.scout.ScoutArrange;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.awt.Point;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintDragDndTarget
extends ConstraintDragTarget {
    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent instanceof TemporarySceneComponent) {
            this.getTargetNotchSnapper().gatherNotches(this.myComponent);
        } else {
            super.mouseDown(x, y);
        }
    }

    @Override
    public void mouseDrag(int x, int y, @Nullable List<Target> closestTarget) {
        if (this.myComponent instanceof TemporarySceneComponent) {
            Scene scene = this.myComponent.getScene();
            int dx = this.getTargetNotchSnapper().trySnapX(x);
            int dy = this.getTargetNotchSnapper().trySnapY(y);
            this.myComponent.setPosition(dx, dy);
            scene.needsRebuildList();
        } else {
            super.mouseDrag(x, y, closestTarget);
        }
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(0);
        }
        if (sceneContext == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(1);
        }
        super.render(list, sceneContext);
    }

    public void mouseRelease(int x, int y, @NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(2);
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            AttributesTransaction attributes = component2.startAttributeTransaction();
            int dx = x - this.myOffsetX;
            int dy = y - this.myOffsetY;
            Point snappedCoordinates = this.getTargetNotchSnapper().applyNotches(this.myComponent, attributes, dx, dy);
            this.updateAttributes(attributes, snappedCoordinates.x, snappedCoordinates.y);
            this.setGuidelineBegin(attributes, x, y);
            boolean horizontalMatchParent = false;
            boolean verticalMatchParent = false;
            if ("match_parent".equals(component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_width"))) {
                horizontalMatchParent = true;
            }
            if ("match_parent".equals(component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_height"))) {
                verticalMatchParent = true;
            }
            if (horizontalMatchParent || verticalMatchParent) {
                NlComponentHelperKt.setX(component2, Coordinates.dpToPx(this.getComponent().getScene().getDesignSurface(), (float)dx));
                NlComponentHelperKt.setY(component2, Coordinates.dpToPx(this.getComponent().getScene().getDesignSurface(), (float)dy));
                ScoutWidget parentScoutWidget = new ScoutWidget(this.myComponent.getParent().getNlComponent(), null);
                ScoutWidget[] scoutWidgets = ScoutWidget.create(Arrays.asList(component2), parentScoutWidget);
                int margin = Scout.getMargin();
                if (horizontalMatchParent) {
                    ScoutArrange.expandHorizontally(scoutWidgets, parentScoutWidget, margin, false);
                }
                if (verticalMatchParent) {
                    ScoutArrange.expandVertically(scoutWidgets, parentScoutWidget, margin, false);
                }
            }
            attributes.apply();
            NlWriteCommandAction.run(component2, "drag", attributes::commit);
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().needsLayout(1);
        }
    }

    private void setGuidelineBegin(@NotNull AttributesTransaction attributes, int x, int y) {
        if (attributes == null) {
            ConstraintDragDndTarget.$$$reportNull$$$0(3);
        }
        if (ConstraintComponentUtilities.isGuideLine(this.myComponent.getNlComponent())) {
            if (ConstraintLayoutGuidelineHandler.isVertical(this.myComponent.getNlComponent())) {
                int dx = x - this.getLeftTargetOrigin(this.myComponent.getParent());
                String positionX = String.format("%ddp", dx);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", positionX);
            } else {
                int dy = y - this.getTopTargetOrigin(this.myComponent.getParent());
                String positionY = String.format("%ddp", dy);
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", positionY);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/ConstraintDragDndTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseRelease";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setGuidelineBegin";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

