/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawHorizontalGuideline;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawVerticalGuideline;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintDragTarget;
import java.awt.Cursor;
import org.jetbrains.annotations.NotNull;

public class GuidelineTarget
extends ConstraintDragTarget {
    boolean myIsHorizontal = true;
    int myBegin = 20;
    int myEnd = -1;
    float myPercent = -1.0f;

    @Override
    public int getPreferenceLevel() {
        return 40;
    }

    public GuidelineTarget(boolean isHorizontal) {
        this.myIsHorizontal = isHorizontal;
    }

    @Override
    public Cursor getMouseCursor() {
        if (this.myIsHorizontal) {
            return Cursor.getPredefinedCursor(8);
        }
        return Cursor.getPredefinedCursor(11);
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (list == null) {
            GuidelineTarget.$$$reportNull$$$0(0);
        }
        if (sceneContext == null) {
            GuidelineTarget.$$$reportNull$$$0(1);
        }
        if (this.myIsHorizontal) {
            int y = (int)(this.myTop + (this.myBottom - this.myTop) / 2.0f);
            SceneComponent parent = this.myComponent.getParent();
            DrawHorizontalGuideline.add(list, sceneContext, this.myLeft, y, this.myRight, parent.getDrawX(), parent.getDrawY(), parent.getDrawHeight(), this.myBegin, this.myEnd, this.myPercent, this.myComponent.isSelected());
        } else {
            int x = (int)(this.myLeft + (this.myRight - this.myLeft) / 2.0f);
            SceneComponent parent = this.myComponent.getParent();
            DrawVerticalGuideline.add(list, sceneContext, x, this.myTop, this.myBottom, parent.getDrawX(), parent.getDrawY(), parent.getDrawWidth(), this.myBegin, this.myEnd, this.myPercent, this.myComponent.isSelected());
        }
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        if (sceneTransform == null) {
            GuidelineTarget.$$$reportNull$$$0(2);
        }
        int dist = 6;
        SceneComponent parent = this.myComponent.getParent();
        if (parent != null) {
            if (this.myIsHorizontal) {
                this.myLeft = parent.getDrawX();
                this.myRight = parent.getDrawX() + parent.getDrawWidth();
                this.myTop = t - dist;
                this.myBottom = t + dist;
            } else {
                this.myLeft = l - dist;
                this.myRight = l + dist;
                this.myTop = parent.getDrawY();
                this.myBottom = parent.getDrawY() + parent.getDrawHeight();
            }
        }
        NlComponent component2 = this.myComponent.getAuthoritativeNlComponent();
        String begin = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        if (begin != null) {
            this.myBegin = ConstraintComponentUtilities.getDpValue(component2, begin);
            this.myEnd = -1;
            this.myPercent = -1.0f;
        } else if (end != null) {
            this.myBegin = -1;
            this.myEnd = ConstraintComponentUtilities.getDpValue(component2, end);
            this.myPercent = -1.0f;
        } else if (percent != null) {
            this.myBegin = -1;
            this.myEnd = -1;
            try {
                this.myPercent = Float.valueOf(percent).floatValue();
            }
            catch (NumberFormatException e) {
                this.myPercent = 0.0f;
            }
        }
        return false;
    }

    @Override
    protected void updateAttributes(@NotNull AttributesTransaction attributes, int x, int y) {
        if (attributes == null) {
            GuidelineTarget.$$$reportNull$$$0(3);
        }
        String begin = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        String percent = attributes.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent");
        SceneComponent parent = this.myComponent.getParent();
        int value = y - parent.getDrawY();
        float dimension = parent.getDrawHeight();
        if (!this.myIsHorizontal) {
            value = x - parent.getDrawX();
            dimension = parent.getDrawWidth();
        }
        if (begin != null) {
            String position = String.format("%ddp", value);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin", position);
        } else if (end != null) {
            String position = String.format("%ddp", (int)dimension - value);
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end", position);
        } else if (percent != null) {
            String percentStringValue = null;
            float percentValue = (float)value / dimension;
            if (percentValue > 1.0f) {
                percentValue = 1.0f;
            }
            if (percentValue < 0.0f) {
                percentValue = 0.0f;
            }
            if ((percentStringValue = String.valueOf(percentValue = (float)Math.round(percentValue * 100.0f) / 100.0f)).equalsIgnoreCase("NaN")) {
                percentStringValue = "0.5";
            }
            attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_percent", percentStringValue);
        }
        ConstraintComponentUtilities.cleanup(attributes, this.myComponent.getNlComponent());
    }

    @Override
    public String getToolTipText() {
        String str = "Guideline (";
        if (this.myBegin != -1) {
            str = str + "< " + this.myBegin + ")";
        } else if (this.myEnd != -1) {
            str = str + this.myEnd + " >)";
        } else {
            float percentValue = this.myPercent;
            if (percentValue > 1.0f) {
                percentValue = 1.0f;
            }
            if (percentValue < 0.0f) {
                percentValue = 0.0f;
            }
            str = !Float.isNaN(percentValue = (float)(100 * Math.round(percentValue * 100.0f)) / 100.0f) ? str + String.valueOf(percentValue) + "%)" : str + "50";
        }
        return str;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/targets/GuidelineTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "layout";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

