/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeDragHandlerKt$WhenMappings;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeLayoutHandlerKt;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeDragTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J \u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0016R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/relative/RelativeDragHandlerKt;", "Lcom/android/tools/idea/uibuilder/api/DragHandler;", "editor", "Lcom/android/tools/idea/uibuilder/api/ViewEditor;", "handler", "Lcom/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandlerKt;", "layout", "Lcom/android/tools/idea/common/scene/SceneComponent;", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "type", "Lcom/android/tools/idea/uibuilder/api/DragType;", "(Lcom/android/tools/idea/uibuilder/api/ViewEditor;Lcom/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandlerKt;Lcom/android/tools/idea/common/scene/SceneComponent;Ljava/util/List;Lcom/android/tools/idea/uibuilder/api/DragType;)V", "component", "dragTarget", "Lcom/android/tools/idea/uibuilder/handlers/relative/targets/RelativeDragTarget;", "cancel", "", "commit", "x", "", "y", "modifiers", "insertType", "Lcom/android/tools/idea/uibuilder/api/InsertType;", "dragWidgetFromComponentTree", "dragWidgetFromPalette", "start", "update", "", "intellij.android.designer"})
public final class RelativeDragHandlerKt
extends DragHandler {
    private final SceneComponent component;
    private final RelativeDragTarget dragTarget;

    @Override
    public void start(int x, int y, int modifiers) {
        super.start(x, y, modifiers);
        this.dragTarget.mouseDown(x, y);
    }

    @Override
    @Nullable
    public String update(int x, int y, int modifiers) {
        String result = super.update(x, y, modifiers);
        int dx = x + this.startX - this.component.getDrawWidth() / 2;
        int dy = y + this.startY - this.component.getDrawHeight() / 2;
        this.dragTarget.mouseDrag(dx, dy, (List<? extends Target>)null);
        return result;
    }

    @Override
    public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)insertType), (String)"insertType");
        switch (RelativeDragHandlerKt$WhenMappings.$EnumSwitchMapping$0[insertType.ordinal()]) {
            case 1: {
                this.dragWidgetFromPalette(x, y);
                break;
            }
            case 2: {
                this.dragWidgetFromComponentTree(x, y);
                break;
            }
            default: {
                Logger.getInstance((String)this.getClass().getName()).error("Unexpected InsertType in " + this.getClass().getName() + "#commit}");
            }
        }
        SceneComponent sceneComponent = this.layout;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"layout");
        this.editor.insertChildren(sceneComponent.getNlComponent(), this.components, -1, insertType);
        SceneComponent sceneComponent2 = this.layout;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"layout");
        sceneComponent2.getScene().removeComponent(this.component);
        SceneComponent sceneComponent3 = this.layout;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent3, (String)"layout");
        sceneComponent3.getScene().checkRequestLayoutStatus();
    }

    /*
     * WARNING - void declaration
     */
    private final void dragWidgetFromPalette(int x, int y) {
        SceneComponent sceneComponent = this.layout;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"layout");
        sceneComponent.getScene().needsRebuildList();
        for (NlComponent child : this.components) {
            void $receiver$iv$iv;
            int dx = x + this.startX - this.lastX - this.component.getDrawWidth() / 2;
            int dy = y + this.startY - this.lastY - this.component.getDrawHeight() / 2;
            ImmutableList<Target> immutableList = this.component.getTargets();
            Intrinsics.checkExpressionValueIsNotNull(immutableList, (String)"component.targets");
            Iterable $receiver$iv = (Iterable)immutableList;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof RelativeDragTarget)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                RelativeDragTarget it = (RelativeDragTarget)element$iv;
                NlComponent nlComponent = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"child");
                it.mouseRelease(dx, dy, nlComponent);
            }
        }
    }

    private final void dragWidgetFromComponentTree(int x, int y) {
        for (NlComponent child : this.components) {
            SceneComponent sceneComponent;
            if (this.layout.getSceneComponent(child) == null) {
                continue;
            }
            this.dragTarget.setComponent(sceneComponent);
            SceneComponent sceneComponent2 = sceneComponent;
            Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"sceneComponent");
            int dx = x + this.startX - this.lastX - sceneComponent2.getDrawWidth() / 2;
            int dy = y + this.startY - this.lastY - sceneComponent.getDrawHeight() / 2;
            this.dragTarget.mouseDrag(dx, dy, (List<? extends Target>)null);
            this.dragTarget.mouseRelease(dx, dy, (List<? extends Target>)null);
        }
    }

    @Override
    public void cancel() {
        SceneComponent sceneComponent = this.layout;
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"layout");
        sceneComponent.getScene().removeComponent(this.component);
        this.dragTarget.cancel();
    }

    public RelativeDragHandlerKt(@NotNull ViewEditor editor, @NotNull RelativeLayoutHandlerKt handler, @NotNull SceneComponent layout, @NotNull List<? extends NlComponent> components, @NotNull DragType type) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        Intrinsics.checkParameterIsNotNull(components, (String)"components");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        super(editor, handler, layout, components, type);
        this.dragTarget = new RelativeDragTarget();
        boolean bl2 = bl = !components.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        NlComponent dragged = components.get(0);
        RelativeDragHandlerKt relativeDragHandlerKt = this;
        SceneComponent sceneComponent = layout.getScene().getSceneComponent(dragged);
        if (sceneComponent == null) {
            TemporarySceneComponent temporarySceneComponent = new TemporarySceneComponent(layout.getScene(), dragged);
            RelativeDragHandlerKt relativeDragHandlerKt2 = relativeDragHandlerKt;
            TemporarySceneComponent $receiver = temporarySceneComponent;
            $receiver.setSize(editor.pxToDp(NlComponentHelperKt.getW(dragged)), editor.pxToDp(NlComponentHelperKt.getH(dragged)), false);
            TemporarySceneComponent temporarySceneComponent2 = temporarySceneComponent;
            relativeDragHandlerKt = relativeDragHandlerKt2;
            sceneComponent = temporarySceneComponent2;
        }
        relativeDragHandlerKt.component = sceneComponent;
        this.component.setTargetProvider(new TargetProvider(){

            @Override
            @NotNull
            public final List<Target> createTargets(@NotNull SceneComponent $noName_0) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                return CollectionsKt.mutableListOf((Object[])new Target[]{dragTarget});
            }
        });
        layout.addChild(this.component);
        this.component.setDrawState(SceneComponent.DrawState.DRAG);
    }
}

