/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ResizeHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.relative.GuidelinePainter;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeDragHandler;
import com.android.tools.idea.uibuilder.handlers.relative.RelativeResizeHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.model.SegmentType;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeLayoutHandler
extends ViewGroupHandler {
    @Override
    @Nullable
    public DragHandler createDragHandler(@NotNull ViewEditor editor, @NotNull SceneComponent layout, @NotNull List<NlComponent> components, @NotNull DragType type) {
        if (editor == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(1);
        }
        if (components == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(2);
        }
        if (type == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(3);
        }
        final RelativeDragHandler moveHandler = new RelativeDragHandler(editor, layout, components);
        return new DragHandler(editor, this, layout, components, type){

            @Override
            @Nullable
            public String update(int x, int y, int modifiers) {
                super.update(x, y, modifiers);
                if (this.components.isEmpty()) {
                    return null;
                }
                NlComponent primary = (NlComponent)this.components.get(0);
                int deltaX = this.lastX;
                int deltaY = this.lastY;
                if (!primary.isRoot()) {
                    deltaX -= this.startX;
                    deltaY -= this.startY;
                } else {
                    deltaX -= this.editor.pxToDp(NlComponentHelperKt.getW(primary) / 2);
                    deltaY -= this.editor.pxToDp(NlComponentHelperKt.getH(primary) / 2);
                }
                moveHandler.updateMove(primary, deltaX, deltaY, modifiers);
                return null;
            }

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                if (graphics == null) {
                    1.$$$reportNull$$$0(0);
                }
                GuidelinePainter.paint(graphics, moveHandler);
            }

            @Override
            public void commit(int x, int y, int modifiers, @NotNull InsertType insertType) {
                if (insertType == null) {
                    1.$$$reportNull$$$0(1);
                }
                moveHandler.removeCycles();
                NlComponent previous = null;
                for (NlComponent component2 : this.components) {
                    NlComponent finalPrevious = previous;
                    NlWriteCommandAction.run(component2, "Apply Constraints", () -> {
                        if (finalPrevious == null) {
                            moveHandler.applyConstraints(component2);
                        } else {
                            moveHandler.attachPrevious(finalPrevious, component2);
                        }
                    });
                    previous = component2;
                }
                this.insertAddedComponents(insertType);
            }

            private void insertAddedComponents(@NotNull InsertType insertType) {
                if (insertType == null) {
                    1.$$$reportNull$$$0(2);
                }
                List<NlComponent> added = this.components.stream().filter(component2 -> component2.getParent() != this.layout.getNlComponent()).collect(Collectors.toList());
                this.editor.getModel().addComponents(added, this.layout.getNlComponent(), null, insertType, this.editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "graphics";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "insertType";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "insertAddedComponents";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @Nullable
    public ResizeHandler createResizeHandler(@NotNull ViewEditor editor, @NotNull NlComponent component2, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        NlComponent parent;
        if (editor == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(4);
        }
        if (component2 == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(5);
        }
        if ((parent = component2.getParent()) == null) {
            return null;
        }
        final RelativeResizeHandler resizeHandler = new RelativeResizeHandler(editor, parent, component2, horizontalEdgeType, verticalEdgeType);
        return new ResizeHandler(editor, this, component2, horizontalEdgeType, verticalEdgeType){

            @Override
            @Nullable
            public String update(int x, int y, int modifiers, @NotNull Rectangle newBounds) {
                if (newBounds == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.update(x, y, modifiers, newBounds);
                resizeHandler.updateResize(this.component, newBounds, modifiers);
                return null;
            }

            @Override
            public void commit(int px, int py, int modifiers, @NotNull Rectangle newBounds) {
                if (newBounds == null) {
                    2.$$$reportNull$$$0(1);
                }
                resizeHandler.removeCycles();
                resizeHandler.applyConstraints(this.component);
            }

            @Override
            public void paint(@NotNull NlGraphics graphics) {
                if (graphics == null) {
                    2.$$$reportNull$$$0(2);
                }
                GuidelinePainter.paint(graphics, resizeHandler);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newBounds";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "graphics";
                        break;
                    }
                }
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commit";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "paint";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView screenView, @NotNull NlComponent layout) {
        SelectionModel selectionModel;
        if (screenView == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(6);
        }
        if (layout == null) {
            RelativeLayoutHandler.$$$reportNull$$$0(7);
        }
        if ((selectionModel = screenView.getSelectionModel()).getSelection().isEmpty()) {
            selectionModel.setSelection(Collections.singletonList(layout));
        }
        return super.createInteraction(screenView, layout);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/relative/RelativeLayoutHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createDragHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createResizeHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createInteraction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

