/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.relative.GuidelineHandler;
import com.android.tools.idea.uibuilder.handlers.relative.Match;
import com.android.tools.idea.uibuilder.model.MarginType;
import com.android.tools.idea.uibuilder.model.Segment;
import com.android.tools.idea.uibuilder.model.SegmentType;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeResizeHandler
extends GuidelineHandler {
    @Nullable
    private final SegmentType myHorizontalEdgeType;
    @Nullable
    private final SegmentType myVerticalEdgeType;

    public RelativeResizeHandler(@NotNull ViewEditor viewEditor, @NotNull NlComponent layout, @NotNull NlComponent resized, @Nullable SegmentType horizontalEdgeType, @Nullable SegmentType verticalEdgeType) {
        Set<NlComponent> nodes;
        if (viewEditor == null) {
            RelativeResizeHandler.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            RelativeResizeHandler.$$$reportNull$$$0(1);
        }
        if (resized == null) {
            RelativeResizeHandler.$$$reportNull$$$0(2);
        }
        super(viewEditor, layout);
        assert (horizontalEdgeType != null || verticalEdgeType != null);
        assert (horizontalEdgeType != SegmentType.BASELINE && verticalEdgeType != SegmentType.BASELINE);
        assert (horizontalEdgeType != SegmentType.CENTER_HORIZONTAL && verticalEdgeType != SegmentType.CENTER_HORIZONTAL);
        assert (horizontalEdgeType != SegmentType.CENTER_VERTICAL && verticalEdgeType != SegmentType.CENTER_VERTICAL);
        this.myHorizontalEdgeType = horizontalEdgeType;
        this.myVerticalEdgeType = verticalEdgeType;
        this.myDraggedNodes = nodes = Collections.singleton(resized);
        this.myHorizontalDeps = this.myDependencyGraph.dependsOn(nodes, false);
        this.myVerticalDeps = this.myDependencyGraph.dependsOn(nodes, true);
        if (horizontalEdgeType != null) {
            if (horizontalEdgeType == SegmentType.TOP) {
                this.myMoveTop = true;
            } else if (horizontalEdgeType == SegmentType.BOTTOM) {
                this.myMoveBottom = true;
            }
        }
        if (verticalEdgeType != null) {
            if (this.myTextDirection.isLeftSegment(verticalEdgeType)) {
                this.myMoveLeft = true;
            } else if (this.myTextDirection.isRightSegment(verticalEdgeType)) {
                this.myMoveRight = true;
            }
        }
        for (NlComponent child : layout.getChildren()) {
            if (child == resized || child == null) continue;
            String id = child.getId();
            this.addBounds(child, id, !this.myHorizontalDeps.contains(child), !this.myVerticalDeps.contains(child), false);
        }
        this.addBounds(layout, layout.getId(), true, true, true);
    }

    @Override
    protected void snapVertical(Segment vEdge, int x, Rectangle newBounds) {
        int maxDistance = 20;
        if (vEdge.edgeType == SegmentType.LEFT) {
            int margin;
            int n = margin = this.mySnap ? 0 : Math.abs(newBounds.x - x);
            if (margin > maxDistance) {
                this.myLeftMargin = margin;
            } else {
                newBounds.width += newBounds.x - x;
                newBounds.x = x;
            }
        } else if (vEdge.edgeType == SegmentType.RIGHT) {
            int margin;
            int n = margin = this.mySnap ? 0 : Math.abs(newBounds.x - (x - newBounds.width));
            if (margin > maxDistance) {
                this.myRightMargin = margin;
            } else {
                newBounds.width = x - newBounds.x;
            }
        } else assert (false) : vEdge;
    }

    @Override
    protected void snapHorizontal(Segment hEdge, int y, Rectangle newBounds) {
        int maxDistance = 20;
        if (hEdge.edgeType == SegmentType.TOP) {
            int margin;
            int n = margin = this.mySnap ? 0 : Math.abs(newBounds.y - y);
            if (margin > maxDistance) {
                this.myTopMargin = margin;
            } else {
                newBounds.height += newBounds.y - y;
                newBounds.y = y;
            }
        } else if (hEdge.edgeType == SegmentType.BOTTOM) {
            int margin;
            int n = margin = this.mySnap ? 0 : Math.abs(newBounds.y - (y - newBounds.height));
            if (margin > maxDistance) {
                this.myBottomMargin = margin;
            } else {
                newBounds.height = y - newBounds.y;
            }
        } else assert (false) : hEdge;
    }

    @Override
    protected boolean isEdgeTypeCompatible(SegmentType edge, SegmentType dragged, int delta) {
        boolean compatible = super.isEdgeTypeCompatible(edge, dragged, delta);
        if (compatible && !this.mySnap) {
            switch (dragged) {
                case LEFT: 
                case TOP: {
                    return delta <= 0;
                }
            }
            return delta >= 0;
        }
        return compatible;
    }

    public void updateResize(NlComponent child, Rectangle newBounds, int modifierMask) {
        Match match;
        this.mySnap = (modifierMask & 1) == 0;
        this.myBounds = newBounds;
        this.clearSuggestions();
        Rectangle b = newBounds;
        Segment hEdge = null;
        Segment vEdge = null;
        String childId = child.getId();
        if (this.myHorizontalEdgeType == SegmentType.TOP) {
            hEdge = new Segment(b.y, b.x, RelativeResizeHandler.x2(b), child, childId, this.myHorizontalEdgeType, MarginType.NO_MARGIN);
        } else if (this.myHorizontalEdgeType == SegmentType.BOTTOM) {
            hEdge = new Segment(RelativeResizeHandler.y2(b), b.x, RelativeResizeHandler.x2(b), child, childId, this.myHorizontalEdgeType, MarginType.NO_MARGIN);
        } else assert (this.myHorizontalEdgeType == null);
        if (this.myVerticalEdgeType != null && this.myTextDirection.isLeftSegment(this.myVerticalEdgeType)) {
            vEdge = new Segment(b.x, b.y, RelativeResizeHandler.y2(b), child, childId, this.myVerticalEdgeType, MarginType.NO_MARGIN);
        } else if (this.myVerticalEdgeType != null && this.myTextDirection.isRightSegment(this.myVerticalEdgeType)) {
            vEdge = new Segment(RelativeResizeHandler.x2(b), b.y, RelativeResizeHandler.y2(b), child, childId, this.myVerticalEdgeType, MarginType.NO_MARGIN);
        } else assert (this.myVerticalEdgeType == null);
        this.myRightMargin = 0;
        this.myLeftMargin = 0;
        this.myBottomMargin = 0;
        this.myTopMargin = 0;
        if (hEdge != null && !this.myHorizontalEdges.isEmpty()) {
            this.myHorizontalSuggestions = this.findClosest(hEdge, this.myHorizontalEdges);
            match = this.pickBestMatch(this.myHorizontalSuggestions);
            if (!(match == null || this.mySnap && Math.abs(match.delta) >= 20)) {
                if (this.myHorizontalDeps.contains(match.edge.component)) {
                    match.cycle = true;
                }
                this.snapHorizontal(hEdge, match.edge.at, newBounds);
                if (hEdge.edgeType == SegmentType.TOP) {
                    this.myCurrentTopMatch = match;
                } else if (hEdge.edgeType == SegmentType.BOTTOM) {
                    this.myCurrentBottomMatch = match;
                } else {
                    assert (hEdge.edgeType == SegmentType.CENTER_HORIZONTAL || hEdge.edgeType == SegmentType.BASELINE) : hEdge;
                    this.myCurrentTopMatch = match;
                }
            }
        }
        if (vEdge != null && !this.myVerticalEdges.isEmpty()) {
            this.myVerticalSuggestions = this.findClosest(vEdge, this.myVerticalEdges);
            match = this.pickBestMatch(this.myVerticalSuggestions);
            if (!(match == null || this.mySnap && Math.abs(match.delta) >= 20)) {
                if (this.myVerticalDeps.contains(match.edge.component)) {
                    match.cycle = true;
                }
                this.snapVertical(vEdge, match.edge.at, newBounds);
                if (this.myTextDirection.isLeftSegment(vEdge.edgeType)) {
                    this.myCurrentLeftMatch = match;
                } else if (this.myTextDirection.isRightSegment(vEdge.edgeType)) {
                    this.myCurrentRightMatch = match;
                } else {
                    assert (vEdge.edgeType == SegmentType.CENTER_VERTICAL);
                    this.myCurrentLeftMatch = match;
                }
            }
        }
        this.checkCycles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "viewEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "layout";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "resized";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/uibuilder/handlers/relative/RelativeResizeHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

